/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.credential.store.impl;

import java.nio.charset.StandardCharsets;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.credential.store.impl.CommandCredentialStore;
import org.wildfly.security.util.Alphabet;
import org.wildfly.security.util.ByteIterator;

public class MaskedPasswordStore
extends CommandCredentialStore {
    public static final String SALT = "salt";
    public static final String ITERATION_COUNT = "iteration";
    public static final String PBE_ALGORITHM = "algorithm";
    public static final String INITIAL_KEY = "initialKey";
    public static String PASS_MASK_PREFIX = "MASK-";
    private static final char[] DEFAULT_PBE_KEY = "somearbitrarycrazystringthatdoesnotmatter".toCharArray();
    static final String DEFAULT_PBE_ALGORITHM = "PBEwithMD5andDES";
    public static final String MASKED_PASSWORD_STORE = "MaskedPasswordStore";

    public MaskedPasswordStore() {
        this.storeName = "masked";
    }

    @Override
    char[] executePasswordCommand(String passwordCommand) throws Throwable {
        String secret = passwordCommand.startsWith(PASS_MASK_PREFIX) ? passwordCommand.substring(PASS_MASK_PREFIX.length()) : passwordCommand;
        return this.decode(secret, this.getSalt(), this.getIterationCount(), this.getPbeAlgorithm(), this.getInitialKey());
    }

    private char[] decode(String maskedString, String salt, int iterationCount, String pbeAlgorithm, String initialKey) throws Exception {
        String algorithm = pbeAlgorithm != null ? pbeAlgorithm : DEFAULT_PBE_ALGORITHM;
        String encryptedBase64EncodedSecret = maskedString.startsWith(PASS_MASK_PREFIX) ? maskedString.substring(PASS_MASK_PREFIX.length()) : maskedString;
        SecretKeyFactory factory = SecretKeyFactory.getInstance(algorithm);
        char[] initialKeyMaterial = initialKey != null ? initialKey.toCharArray() : DEFAULT_PBE_KEY;
        PBEParameterSpec cipherSpec = new PBEParameterSpec(salt.getBytes(StandardCharsets.UTF_8), iterationCount);
        PBEKeySpec keySpec = new PBEKeySpec(initialKeyMaterial);
        SecretKey cipherKey = factory.generateSecret(keySpec);
        return this.decode64(encryptedBase64EncodedSecret, algorithm, cipherKey, cipherSpec).toCharArray();
    }

    private String decode64(String secret, String cipherAlgorithm, SecretKey cipherKey, PBEParameterSpec cipherSpec) throws Exception {
        byte[] encoding;
        try {
            encoding = ByteIterator.ofBytes(secret.getBytes(StandardCharsets.UTF_8)).base64Decode(Alphabet.Base64Alphabet.PICKETBOX_COMPATIBILITY).drain();
        }
        catch (IllegalArgumentException e) {
            String fallBack = "0" + secret;
            encoding = ByteIterator.ofBytes(fallBack.getBytes(StandardCharsets.UTF_8)).base64Decode().drain();
            ElytronMessages.log.warnWrongBase64EncodedString(fallBack);
        }
        byte[] decoded = this.decode(encoding, cipherAlgorithm, cipherKey, cipherSpec);
        return new String(decoded, StandardCharsets.UTF_8);
    }

    private byte[] decode(byte[] secret, String cipherAlgorithm, SecretKey cipherKey, PBEParameterSpec cipherSpec) throws Exception {
        Cipher cipher = Cipher.getInstance(cipherAlgorithm);
        cipher.init(2, (Key)cipherKey, cipherSpec);
        byte[] decode = cipher.doFinal(secret);
        return decode;
    }

    String getSalt() {
        return (String)this.attributes.get(SALT);
    }

    int getIterationCount() {
        String iterationCount = (String)this.attributes.get(ITERATION_COUNT);
        if (iterationCount != null) {
            return Integer.parseInt(iterationCount);
        }
        throw new IllegalArgumentException(ITERATION_COUNT);
    }

    String getPbeAlgorithm() {
        return (String)this.attributes.get(PBE_ALGORITHM);
    }

    String getInitialKey() {
        return (String)this.attributes.get(INITIAL_KEY);
    }
}

