/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.ssl;

import java.security.Provider;
import java.security.Security;
import java.util.function.Supplier;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSessionContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509TrustManager;
import org.wildfly.common.Assert;
import org.wildfly.security.FixedSecurityFactory;
import org.wildfly.security.OneTimeSecurityFactory;
import org.wildfly.security.SecurityFactory;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.ssl.CipherSuiteSelector;
import org.wildfly.security.ssl.ConfiguredSSLContextSpi;
import org.wildfly.security.ssl.DelegatingSSLContext;
import org.wildfly.security.ssl.ProtocolSelector;
import org.wildfly.security.ssl.SSLUtils;
import org.wildfly.security.ssl.SecurityDomainTrustManager;
import org.wildfly.security.ssl.ServerSSLConfigurator;

public final class ServerSSLContextBuilder {
    private SecurityDomain securityDomain;
    private CipherSuiteSelector cipherSuiteSelector = CipherSuiteSelector.openSslDefault();
    private ProtocolSelector protocolSelector = ProtocolSelector.DEFAULT_SELECTOR;
    private boolean wantClientAuth;
    private boolean needClientAuth;
    private boolean authenticationOptional;
    private int sessionCacheSize;
    private int sessionTimeout;
    private SecurityFactory<X509ExtendedKeyManager> keyManagerSecurityFactory;
    private SecurityFactory<X509TrustManager> trustManagerSecurityFactory = () -> SSLUtils.getDefaultX509TrustManagerSecurityFactory().create();
    private Supplier<Provider[]> providerSupplier = Security::getProviders;

    public ServerSSLContextBuilder setSecurityDomain(SecurityDomain securityDomain) {
        this.securityDomain = securityDomain;
        return this;
    }

    public ServerSSLContextBuilder setCipherSuiteSelector(CipherSuiteSelector cipherSuiteSelector) {
        Assert.checkNotNullParam((String)"cipherSuiteSelector", (Object)cipherSuiteSelector);
        this.cipherSuiteSelector = cipherSuiteSelector;
        return this;
    }

    public ServerSSLContextBuilder setProtocolSelector(ProtocolSelector protocolSelector) {
        Assert.checkNotNullParam((String)"protocolSelector", (Object)protocolSelector);
        this.protocolSelector = protocolSelector;
        return this;
    }

    public ServerSSLContextBuilder setWantClientAuth(boolean wantClientAuth) {
        this.wantClientAuth = wantClientAuth;
        return this;
    }

    public ServerSSLContextBuilder setNeedClientAuth(boolean needClientAuth) {
        this.needClientAuth = needClientAuth;
        return this;
    }

    public ServerSSLContextBuilder setAuthenticationOptional(boolean authenticationOptional) {
        this.authenticationOptional = authenticationOptional;
        return this;
    }

    public ServerSSLContextBuilder setSessionCacheSize(int sessionCacheSize) {
        this.sessionCacheSize = sessionCacheSize;
        return this;
    }

    public ServerSSLContextBuilder setSessionTimeout(int sessionTimeout) {
        this.sessionTimeout = sessionTimeout;
        return this;
    }

    public ServerSSLContextBuilder setKeyManagerSecurityFactory(SecurityFactory<X509ExtendedKeyManager> keyManagerSecurityFactory) {
        Assert.checkNotNullParam((String)"keyManagerSecurityFactory", keyManagerSecurityFactory);
        this.keyManagerSecurityFactory = keyManagerSecurityFactory;
        return this;
    }

    public ServerSSLContextBuilder setKeyManager(X509ExtendedKeyManager keyManager) {
        Assert.checkNotNullParam((String)"keyManager", (Object)keyManager);
        this.keyManagerSecurityFactory = new FixedSecurityFactory<X509ExtendedKeyManager>(keyManager);
        return this;
    }

    public ServerSSLContextBuilder setTrustManagerSecurityFactory(SecurityFactory<X509TrustManager> trustManagerSecurityFactory) {
        this.trustManagerSecurityFactory = (SecurityFactory)Assert.checkNotNullParam((String)"trustManagerSecurityFactory", trustManagerSecurityFactory);
        return this;
    }

    public ServerSSLContextBuilder setTrustManager(X509TrustManager trustManager) {
        Assert.checkNotNullParam((String)"trustManager", (Object)trustManager);
        this.trustManagerSecurityFactory = new FixedSecurityFactory<X509TrustManager>(trustManager);
        return this;
    }

    public ServerSSLContextBuilder setProviderSupplier(Supplier<Provider[]> providerSupplier) {
        Assert.checkNotNullParam((String)"providerSupplier", providerSupplier);
        this.providerSupplier = providerSupplier;
        return this;
    }

    public SecurityFactory<SSLContext> build() {
        SecurityDomain securityDomain = this.securityDomain;
        CipherSuiteSelector cipherSuiteSelector = this.cipherSuiteSelector;
        ProtocolSelector protocolSelector = this.protocolSelector;
        SecurityFactory<X509ExtendedKeyManager> keyManagerSecurityFactory = this.keyManagerSecurityFactory;
        Supplier<Provider[]> providerSupplier = this.providerSupplier;
        return new OneTimeSecurityFactory<SSLContext>(() -> {
            SecurityFactory<SSLContext> sslContextFactory = SSLUtils.createSslContextFactory(protocolSelector, providerSupplier);
            SSLContext sslContext = sslContextFactory.create();
            SSLSessionContext sessionContext = sslContext.getServerSessionContext();
            sessionContext.setSessionCacheSize(this.sessionCacheSize);
            sessionContext.setSessionTimeout(this.sessionTimeout);
            X509TrustManager x509TrustManager = this.trustManagerSecurityFactory.create();
            boolean canAuthClients = securityDomain != null;
            sslContext.init(new KeyManager[]{(KeyManager)keyManagerSecurityFactory.create()}, new TrustManager[]{canAuthClients ? new SecurityDomainTrustManager(x509TrustManager, securityDomain, this.authenticationOptional) : x509TrustManager}, null);
            ServerSSLConfigurator sslConfigurator = new ServerSSLConfigurator(protocolSelector, cipherSuiteSelector, this.wantClientAuth || canAuthClients, this.needClientAuth);
            ConfiguredSSLContextSpi contextSpi = new ConfiguredSSLContextSpi(sslContext, sslConfigurator);
            return new DelegatingSSLContext(contextSpi);
        });
    }
}

