/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.server;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.function.UnaryOperator;
import javax.security.auth.callback.CallbackHandler;
import org.wildfly.security.auth.server.AbstractMechanismAuthenticationFactory;
import org.wildfly.security.auth.server.MechanismConfiguration;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.credential.AlgorithmCredential;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.credential.PasswordCredential;
import org.wildfly.security.evidence.AlgorithmEvidence;
import org.wildfly.security.evidence.Evidence;
import org.wildfly.security.evidence.PasswordGuessEvidence;
import org.wildfly.security.http.HttpAuthenticationException;
import org.wildfly.security.http.HttpServerAuthenticationMechanism;
import org.wildfly.security.http.HttpServerAuthenticationMechanismFactory;

public final class HttpAuthenticationFactory
extends AbstractMechanismAuthenticationFactory<HttpServerAuthenticationMechanism, HttpServerAuthenticationMechanismFactory, HttpAuthenticationException> {
    HttpAuthenticationFactory(SecurityDomain securityDomain, Map<String, MechanismConfiguration> mechanismConfigurations, HttpServerAuthenticationMechanismFactory factory) {
        super(securityDomain, mechanismConfigurations, factory);
    }

    @Override
    HttpServerAuthenticationMechanism doCreate(String name, CallbackHandler callbackHandler, UnaryOperator<HttpServerAuthenticationMechanismFactory> factoryTransformation) throws HttpAuthenticationException {
        return ((HttpServerAuthenticationMechanismFactory)factoryTransformation.apply((HttpServerAuthenticationMechanismFactory)this.getFactory())).createAuthenticationMechanism(name, Collections.emptyMap(), callbackHandler);
    }

    @Override
    Collection<String> getAllSupportedMechNames() {
        return Arrays.asList(((HttpServerAuthenticationMechanismFactory)this.getFactory()).getMechanismNames(Collections.emptyMap()));
    }

    @Override
    Collection<Class<? extends Evidence>> getSupportedEvidenceTypes(String mechName) {
        switch (mechName) {
            case "BASIC": {
                return Collections.singleton(PasswordGuessEvidence.class);
            }
        }
        return Collections.emptySet();
    }

    @Override
    Collection<String> getSupportedEvidenceAlgorithmNames(Class<? extends AlgorithmEvidence> evidenceType, String mechName) {
        return Collections.emptySet();
    }

    @Override
    Collection<Class<? extends Credential>> getSupportedCredentialTypes(String mechName) {
        switch (mechName) {
            case "BASIC": 
            case "DIGEST": {
                return Collections.singleton(PasswordCredential.class);
            }
        }
        return Collections.emptySet();
    }

    @Override
    Collection<String> getSupportedCredentialAlgorithmNames(Class<? extends AlgorithmCredential> credentialType, String mechName) {
        switch (mechName) {
            case "BASIC": {
                return Collections.singleton("*");
            }
            case "DIGEST": {
                return Arrays.asList("clear", "digest-md5");
            }
        }
        return Collections.emptySet();
    }

    @Override
    boolean usesCredentials(String mechName) {
        switch (mechName) {
            case "BASIC": 
            case "DIGEST": {
                return true;
            }
        }
        return false;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    extends AbstractMechanismAuthenticationFactory.Builder<HttpServerAuthenticationMechanism, HttpServerAuthenticationMechanismFactory, HttpAuthenticationException> {
        Builder() {
        }

        @Override
        public Builder setSecurityDomain(SecurityDomain securityDomain) {
            super.setSecurityDomain(securityDomain);
            return this;
        }

        @Override
        public Builder addMechanism(String mechanismName, MechanismConfiguration mechanismConfiguration) {
            super.addMechanism(mechanismName, mechanismConfiguration);
            return this;
        }

        public Builder setFactory(HttpServerAuthenticationMechanismFactory factory) {
            super.setFactory(factory);
            return this;
        }

        public HttpAuthenticationFactory build() {
            return new HttpAuthenticationFactory(this.getSecurityDomain(), this.getMechanismConfigurations(), (HttpServerAuthenticationMechanismFactory)this.getFactory());
        }
    }
}

