/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.realm.ldap;

import java.io.IOException;
import java.security.Principal;
import java.security.Provider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Spliterators;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.naming.Binding;
import javax.naming.InvalidNameException;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.ReferralException;
import javax.naming.directory.Attribute;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.DirContext;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.event.EventContext;
import javax.naming.event.NamespaceChangeListener;
import javax.naming.event.NamingEvent;
import javax.naming.event.NamingExceptionEvent;
import javax.naming.event.NamingListener;
import javax.naming.event.ObjectChangeListener;
import javax.naming.ldap.Control;
import javax.naming.ldap.LdapContext;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.PagedResultsControl;
import javax.naming.ldap.PagedResultsResponseControl;
import javax.naming.ldap.Rdn;
import org.wildfly.common.Assert;
import org.wildfly.common.function.ExceptionSupplier;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.auth.SupportLevel;
import org.wildfly.security.auth.principal.NamePrincipal;
import org.wildfly.security.auth.realm.CacheableSecurityRealm;
import org.wildfly.security.auth.realm.IdentitySharedExclusiveLock;
import org.wildfly.security.auth.realm.ldap.AttributeMapping;
import org.wildfly.security.auth.realm.ldap.CredentialLoader;
import org.wildfly.security.auth.realm.ldap.CredentialPersister;
import org.wildfly.security.auth.realm.ldap.DelegatingLdapContext;
import org.wildfly.security.auth.realm.ldap.EvidenceVerifier;
import org.wildfly.security.auth.realm.ldap.IdentityCredentialLoader;
import org.wildfly.security.auth.realm.ldap.IdentityCredentialPersister;
import org.wildfly.security.auth.realm.ldap.IdentityEvidenceVerifier;
import org.wildfly.security.auth.server.CloseableIterator;
import org.wildfly.security.auth.server.ModifiableRealmIdentity;
import org.wildfly.security.auth.server.ModifiableSecurityRealm;
import org.wildfly.security.auth.server.NameRewriter;
import org.wildfly.security.auth.server.RealmIdentity;
import org.wildfly.security.auth.server.RealmUnavailableException;
import org.wildfly.security.authz.Attributes;
import org.wildfly.security.authz.AuthorizationIdentity;
import org.wildfly.security.authz.MapAttributes;
import org.wildfly.security.credential.AlgorithmCredential;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.evidence.AlgorithmEvidence;
import org.wildfly.security.evidence.Evidence;

class LdapSecurityRealm
implements ModifiableSecurityRealm,
CacheableSecurityRealm {
    private final String ENV_BINARY_ATTRIBUTES = "java.naming.ldap.attributes.binary";
    private final Supplier<Provider[]> providers;
    private final ExceptionSupplier<DirContext, NamingException> dirContextSupplier;
    private final NameRewriter nameRewriter;
    private final IdentityMapping identityMapping;
    private final int pageSize;
    private final List<CredentialLoader> credentialLoaders;
    private final List<CredentialPersister> credentialPersisters;
    private final List<EvidenceVerifier> evidenceVerifiers;
    private final ConcurrentHashMap<String, IdentitySharedExclusiveLock> realmIdentityLocks = new ConcurrentHashMap();
    private Set<Consumer<Principal>> listenersPendingRegistration = new LinkedHashSet<Consumer<Principal>>();

    LdapSecurityRealm(Supplier<Provider[]> providers, ExceptionSupplier<DirContext, NamingException> dirContextSupplier, NameRewriter nameRewriter, IdentityMapping identityMapping, List<CredentialLoader> credentialLoaders, List<CredentialPersister> credentialPersisters, List<EvidenceVerifier> evidenceVerifiers, int pageSize) {
        this.providers = providers;
        this.dirContextSupplier = dirContextSupplier;
        this.nameRewriter = nameRewriter;
        this.identityMapping = identityMapping;
        this.pageSize = pageSize;
        this.credentialLoaders = credentialLoaders;
        this.credentialPersisters = credentialPersisters;
        this.evidenceVerifiers = evidenceVerifiers;
    }

    @Override
    public RealmIdentity getRealmIdentity(Principal principal) {
        return this.getRealmIdentity(principal, false);
    }

    @Override
    public ModifiableRealmIdentity getRealmIdentityForUpdate(Principal principal) {
        return this.getRealmIdentity(principal, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerIdentityChangeListener(Consumer<Principal> listener) {
        Set<Consumer<Principal>> set = this.listenersPendingRegistration;
        synchronized (set) {
            DirContext dirContext = null;
            try {
                dirContext = this.obtainContext();
                this.registerIdentityChangeListener(dirContext, listener);
            }
            catch (Exception cause) {
                this.listenersPendingRegistration.add(listener);
                ElytronMessages.log.ldapRealmDeferRegistration();
                if (ElytronMessages.log.isDebugEnabled()) {
                    ElytronMessages.log.debug("Listener registration failure: ", cause);
                }
            }
            finally {
                if (dirContext != null) {
                    this.closeContext(dirContext);
                }
            }
        }
    }

    private void registerIdentityChangeListener(DirContext dirContext, Consumer<Principal> listener) throws NamingException {
        EventContext eventContext = (EventContext)dirContext.lookup("");
        eventContext.addNamingListener("", 2, (NamingListener)new ServerNotificationListener(listener));
    }

    private ModifiableRealmIdentity getRealmIdentity(Principal principal, boolean exclusive) {
        if (!(principal instanceof NamePrincipal)) {
            return ModifiableRealmIdentity.NON_EXISTENT;
        }
        String name = this.nameRewriter.rewriteName(principal.getName());
        if (name == null) {
            throw ElytronMessages.log.invalidName();
        }
        ElytronMessages.log.debugf("Obtaining lock for identity [%s]...", name);
        IdentitySharedExclusiveLock realmIdentityLock = this.getRealmIdentityLockForName(name);
        IdentitySharedExclusiveLock.IdentityLock lock = exclusive ? realmIdentityLock.lockExclusive() : realmIdentityLock.lockShared();
        ElytronMessages.log.debugf("Obtained lock for identity [%s].", name);
        return new LdapRealmIdentity(name, lock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DirContext obtainContext() throws RealmUnavailableException {
        try {
            DirContext ctx = (DirContext)this.dirContextSupplier.get();
            Set<Consumer<Principal>> set = this.listenersPendingRegistration;
            synchronized (set) {
                Iterator<Consumer<Principal>> it = this.listenersPendingRegistration.iterator();
                while (it.hasNext()) {
                    this.registerIdentityChangeListener(ctx, it.next());
                    it.remove();
                }
                return ctx;
            }
        }
        catch (NamingException e) {
            throw ElytronMessages.log.ldapRealmFailedToObtainContext(e);
        }
    }

    private void closeContext(DirContext dirContext) {
        try {
            dirContext.close();
        }
        catch (NamingException e) {
            ElytronMessages.log.debug("LdapSecurityRealm failed to close DirContext", e);
        }
    }

    @Override
    public CloseableIterator<ModifiableRealmIdentity> getRealmIdentityIterator() throws RealmUnavailableException {
        Stream<SearchResult> resultStream;
        DirContext dirContext;
        if (this.identityMapping.iteratorFilter == null) {
            throw ElytronMessages.log.ldapRealmNotConfiguredToSupportIteratingOverIdentities();
        }
        LdapSearch ldapSearch = new LdapSearch(this.identityMapping.searchDn, this.identityMapping.searchRecursive, this.pageSize, this.identityMapping.iteratorFilter, new String[0]);
        ldapSearch.setReturningAttributes(Collections.singleton(this.identityMapping.rdnIdentifier));
        try {
            dirContext = (DirContext)this.dirContextSupplier.get();
            resultStream = ldapSearch.search(dirContext);
        }
        catch (NamingException e) {
            throw ElytronMessages.log.ldapRealmIdentitySearchFailed(e);
        }
        final Iterator iterator = resultStream.map(entry -> {
            try {
                return (String)entry.getAttributes().get(this.identityMapping.rdnIdentifier).get();
            }
            catch (NamingException e) {
                throw new RuntimeException(ElytronMessages.log.ldapRealmIdentitySearchFailed(e));
            }
        }).distinct().iterator();
        return new CloseableIterator<ModifiableRealmIdentity>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public ModifiableRealmIdentity next() {
                String name = (String)iterator.next();
                return LdapSecurityRealm.this.getRealmIdentityForUpdate(new NamePrincipal(name));
            }

            @Override
            public void close() throws IOException {
                resultStream.close();
                LdapSecurityRealm.this.closeContext(dirContext);
            }
        };
    }

    @Override
    public SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String algorithmName) throws RealmUnavailableException {
        Assert.checkNotNullParam((String)"credentialType", credentialType);
        SupportLevel response = SupportLevel.UNSUPPORTED;
        for (CredentialLoader loader : this.credentialLoaders) {
            SupportLevel support = loader.getCredentialAcquireSupport(credentialType, algorithmName);
            if (support.isDefinitelySupported()) {
                return support;
            }
            if (response.compareTo(support) >= 0) continue;
            response = support;
        }
        return response;
    }

    @Override
    public SupportLevel getEvidenceVerifySupport(Class<? extends Evidence> evidenceType, String algorithmName) throws RealmUnavailableException {
        Assert.checkNotNullParam((String)"evidenceType", evidenceType);
        SupportLevel response = SupportLevel.UNSUPPORTED;
        for (EvidenceVerifier verifier : this.evidenceVerifiers) {
            SupportLevel support = verifier.getEvidenceVerifySupport(evidenceType, algorithmName);
            if (support.isDefinitelySupported()) {
                return support;
            }
            if (response.compareTo(support) >= 0) continue;
            response = support;
        }
        return response;
    }

    private IdentitySharedExclusiveLock getRealmIdentityLockForName(String name) {
        IdentitySharedExclusiveLock newRealmIdentityLock;
        IdentitySharedExclusiveLock realmIdentityLock = this.realmIdentityLocks.get(name);
        if (realmIdentityLock == null && (realmIdentityLock = this.realmIdentityLocks.putIfAbsent(name, newRealmIdentityLock = new IdentitySharedExclusiveLock())) == null) {
            realmIdentityLock = newRealmIdentityLock;
        }
        return realmIdentityLock;
    }

    private class ServerNotificationListener
    implements ObjectChangeListener,
    NamespaceChangeListener {
        private final Consumer<Principal> listener;

        ServerNotificationListener(Consumer<Principal> listener) {
            this.listener = listener;
        }

        @Override
        public void objectAdded(NamingEvent evt) {
        }

        @Override
        public void objectRemoved(NamingEvent evt) {
            this.invokeCacheUpdateListener(evt);
        }

        @Override
        public void objectRenamed(NamingEvent evt) {
            this.invokeCacheUpdateListener(evt);
        }

        @Override
        public void objectChanged(NamingEvent evt) {
            this.invokeCacheUpdateListener(evt);
        }

        @Override
        public void namingExceptionThrown(NamingExceptionEvent evt) {
        }

        private void invokeCacheUpdateListener(NamingEvent evt) {
            LdapName ldapName;
            Binding oldBinding = evt.getOldBinding();
            try {
                ldapName = new LdapName(oldBinding.getName());
            }
            catch (InvalidNameException e) {
                throw ElytronMessages.log.ldapInvalidLdapName(oldBinding.getName(), e);
            }
            ldapName.getRdns().stream().filter(rdn -> rdn.getType().equals(LdapSecurityRealm.this.identityMapping.rdnIdentifier)).map(rdn -> new NamePrincipal(rdn.getValue().toString())).findFirst().ifPresent(this.listener::accept);
        }
    }

    static class IdentityMapping {
        private final String searchDn;
        private final boolean searchRecursive;
        private final int searchTimeLimit;
        private final String rdnIdentifier;
        private final List<AttributeMapping> attributes;
        private final LdapName newIdentityParent;
        private final javax.naming.directory.Attributes newIdentityAttributes;
        private final String filterName;
        private final String iteratorFilter;

        public IdentityMapping(String searchDn, boolean searchRecursive, int searchTimeLimit, String rdnIdentifier, List<AttributeMapping> attributes, LdapName newIdentityParent, javax.naming.directory.Attributes newIdentityAttributes, String filterName, String iteratorFilter) {
            Assert.checkNotNullParam((String)"rdnIdentifier", (Object)rdnIdentifier);
            this.searchDn = searchDn;
            this.searchRecursive = searchRecursive;
            this.searchTimeLimit = searchTimeLimit;
            this.rdnIdentifier = rdnIdentifier;
            this.attributes = attributes;
            this.newIdentityParent = newIdentityParent;
            this.newIdentityAttributes = newIdentityAttributes;
            this.filterName = filterName;
            this.iteratorFilter = iteratorFilter;
        }
    }

    private class LdapSearch {
        private final String NO_FILTER = "(objectclass=*)";
        private final String searchDn;
        private final int searchScope;
        private final int pageSize;
        private final String filter;
        private final String[] filterArgs;
        private Collection<String> returningAttributes;
        private Collection<String> binaryAttributes;
        private DirContext context;
        private NamingEnumeration<SearchResult> result;
        private byte[] cookie;

        public LdapSearch(String searchDn, boolean searchRecursive, int pageSize, String filter, String ... filterArgs) {
            this(searchDn, searchRecursive ? 2 : 1, pageSize, filter, filterArgs);
        }

        public LdapSearch(String searchDn, int searchScope, int pageSize, String filter, String ... filterArgs) {
            this.searchDn = searchDn;
            this.searchScope = searchScope;
            this.pageSize = pageSize;
            this.filter = filter;
            this.filterArgs = filterArgs;
        }

        public LdapSearch(String searchDn) {
            this.searchDn = searchDn;
            this.searchScope = 0;
            this.pageSize = 0;
            this.filter = "(objectclass=*)";
            this.filterArgs = null;
        }

        public Stream<SearchResult> search(DirContext ctx) throws RealmUnavailableException {
            if (ElytronMessages.log.isDebugEnabled()) {
                ElytronMessages.log.debugf("Executing search [%s] in context [%s] with arguments [%s]. Returning attributes are [%s]. Binary attributes are [%s].", new Object[]{this.filter, this.searchDn, this.filterArgs == null ? null : String.join((CharSequence)", ", this.filterArgs), this.returningAttributes == null ? null : String.join((CharSequence)", ", this.returningAttributes), this.binaryAttributes == null ? null : String.join((CharSequence)", ", this.binaryAttributes)});
            }
            this.context = ctx;
            this.cookie = null;
            try {
                this.result = this.searchWithPagination();
                return (Stream)StreamSupport.stream(new Spliterators.AbstractSpliterator<SearchResult>(Long.MAX_VALUE, 256){
                    boolean finished;
                    Set<Object> followedReferrals;
                    {
                        this.finished = false;
                        this.followedReferrals = new HashSet<Object>();
                    }

                    @Override
                    public boolean tryAdvance(Consumer<? super SearchResult> action) {
                        if (this.finished) {
                            return false;
                        }
                        try {
                            while (true) {
                                try {
                                    if (!LdapSearch.this.result.hasMore()) {
                                        if (LdapSearch.this.pageSize == 0 || !(LdapSearch.this.context instanceof LdapContext)) {
                                            ElytronMessages.log.trace("Identity iterating - pagination not supported - end of list");
                                            this.finished = true;
                                            return false;
                                        }
                                        Control[] controls = ((LdapContext)LdapSearch.this.context).getResponseControls();
                                        if (controls != null) {
                                            for (Control control : controls) {
                                                if (!(control instanceof PagedResultsResponseControl)) continue;
                                                LdapSearch.access$2202(LdapSearch.this, ((PagedResultsResponseControl)control).getCookie());
                                                if (LdapSearch.this.cookie != null) continue;
                                                ElytronMessages.log.trace("Identity iterating - no more pages - end of list");
                                                this.finished = true;
                                                return false;
                                            }
                                        }
                                        LdapSearch.this.result.close();
                                        LdapSearch.this.result = LdapSearch.this.searchWithPagination();
                                        if (!LdapSearch.this.result.hasMore()) {
                                            ElytronMessages.log.trace("Identity iterating - even after page loading no results - end of list");
                                            this.finished = true;
                                            return false;
                                        }
                                    }
                                    SearchResult entry = (SearchResult)LdapSearch.this.result.next();
                                    ElytronMessages.log.debugf("Found entry [%s].", entry.getNameInNamespace());
                                    action.accept(entry);
                                    return true;
                                }
                                catch (ReferralException e) {
                                    if (this.followedReferrals.add(e.getReferralInfo())) {
                                        ElytronMessages.log.debugf("Next referral following in identity iterating: [%s]", e.getReferralInfo());
                                        LdapSearch.this.context = ((DelegatingLdapContext)LdapSearch.this.context).wrapReferralContextObtaining(e);
                                        LdapSearch.this.result = LdapSearch.this.searchWithPagination();
                                        continue;
                                    }
                                    if (e.skipReferral()) {
                                        ElytronMessages.log.debugf("Referral skipped, continue: [%s]", e.getReferralInfo());
                                        LdapSearch.this.context = ((DelegatingLdapContext)LdapSearch.this.context).wrapReferralContextObtaining(e);
                                        LdapSearch.this.result = LdapSearch.this.searchWithPagination();
                                        continue;
                                    }
                                    ElytronMessages.log.debugf("Referral skipped and no more elements: [%s]", e.getReferralInfo());
                                    this.finished = true;
                                    return false;
                                }
                                break;
                            }
                        }
                        catch (IOException | NamingException e) {
                            try {
                                LdapSearch.this.result.close();
                            }
                            catch (NamingException ex) {
                                ElytronMessages.log.trace("Unable to close result", ex);
                            }
                            throw ElytronMessages.log.ldapRealmErrorWhileConsumingResultsFromSearch(LdapSearch.this.searchDn, LdapSearch.this.filter, Arrays.toString(LdapSearch.this.filterArgs), e);
                        }
                    }
                }, false).onClose(() -> {
                    if (this.result != null) {
                        try {
                            this.result.close();
                        }
                        catch (NamingException e) {
                            ElytronMessages.log.trace("Unable to close result", e);
                        }
                    }
                });
            }
            catch (NameNotFoundException e) {
                ElytronMessages.log.trace("Error searching", e);
                return Stream.empty();
            }
            catch (Exception e) {
                throw ElytronMessages.log.ldapRealmIdentitySearchFailed(e);
            }
        }

        private NamingEnumeration<SearchResult> searchWithPagination() throws NamingException, IOException {
            Control[] controlsBackup = null;
            Object binaryAttributesBackup = null;
            if (this.pageSize != 0 && this.context instanceof LdapContext) {
                controlsBackup = ((LdapContext)this.context).getRequestControls();
                ((LdapContext)this.context).setRequestControls(new Control[]{new PagedResultsControl(this.pageSize, this.cookie, true)});
            }
            if (this.binaryAttributes != null && this.binaryAttributes.size() != 0) {
                binaryAttributesBackup = this.context.getEnvironment().get("java.naming.ldap.attributes.binary");
                this.context.addToEnvironment("java.naming.ldap.attributes.binary", String.join((CharSequence)" ", this.binaryAttributes));
            }
            NamingEnumeration<SearchResult> results = this.context.search(new LdapName(this.searchDn), this.filter, (Object[])this.filterArgs, this.createSearchControls());
            if (this.binaryAttributes != null && this.binaryAttributes.size() != 0) {
                if (binaryAttributesBackup == null) {
                    this.context.removeFromEnvironment("java.naming.ldap.attributes.binary");
                } else {
                    this.context.addToEnvironment("java.naming.ldap.attributes.binary", binaryAttributesBackup);
                }
            }
            if (this.pageSize != 0 && this.context instanceof LdapContext) {
                ((LdapContext)this.context).setRequestControls(controlsBackup);
            }
            return results;
        }

        private void setReturningAttributes(Collection<String> returningAttributes) {
            this.returningAttributes = returningAttributes;
        }

        private void setBinaryAttributes(Collection<String> binaryAttributes) {
            this.binaryAttributes = binaryAttributes;
        }

        private SearchControls createSearchControls() {
            SearchControls searchControls = new SearchControls();
            searchControls.setSearchScope(this.searchScope);
            searchControls.setTimeLimit(LdapSecurityRealm.this.identityMapping.searchTimeLimit);
            if (this.returningAttributes == null) {
                searchControls.setReturningAttributes(new String[0]);
            } else {
                searchControls.setReturningAttributes(this.returningAttributes.toArray(new String[this.returningAttributes.size()]));
            }
            return searchControls;
        }

        private DirContext getContext() {
            return this.context;
        }

        static /* synthetic */ byte[] access$2202(LdapSearch x0, byte[] x1) {
            x0.cookie = x1;
            return x1;
        }
    }

    private class LdapRealmIdentity
    implements ModifiableRealmIdentity {
        private final String name;
        private IdentitySharedExclusiveLock.IdentityLock lock;

        LdapRealmIdentity(String name, IdentitySharedExclusiveLock.IdentityLock lock) {
            this.name = name;
            this.lock = lock;
        }

        @Override
        public Principal getRealmIdentityPrincipal() {
            return new NamePrincipal(this.name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String algorithmName) throws RealmUnavailableException {
            Assert.checkNotNullParam((String)"credentialType", credentialType);
            if (LdapSecurityRealm.this.getCredentialAcquireSupport(credentialType, algorithmName) == SupportLevel.UNSUPPORTED) {
                return SupportLevel.UNSUPPORTED;
            }
            DirContext dirContext = LdapSecurityRealm.this.obtainContext();
            try {
                HashSet<String> attributes = new HashSet<String>();
                HashSet<String> binaryAttributes = new HashSet<String>();
                for (Object loader : LdapSecurityRealm.this.credentialLoaders) {
                    loader.addRequiredIdentityAttributes(attributes);
                    loader.addBinaryIdentityAttributes(binaryAttributes);
                }
                LdapIdentity identity = this.getIdentity(dirContext, attributes, binaryAttributes);
                if (identity == null) {
                    Object loader;
                    loader = SupportLevel.UNSUPPORTED;
                    return loader;
                }
                SupportLevel support = SupportLevel.UNSUPPORTED;
                for (CredentialLoader loader : LdapSecurityRealm.this.credentialLoaders) {
                    if (!loader.getCredentialAcquireSupport(credentialType, algorithmName).mayBeSupported()) continue;
                    IdentityCredentialLoader icl = loader.forIdentity(identity.getDirContext(), identity.getDistinguishedName(), identity.getEntry().getAttributes());
                    SupportLevel temp = icl.getCredentialAcquireSupport(credentialType, algorithmName, LdapSecurityRealm.this.providers);
                    if (temp != null && temp.isDefinitelySupported()) {
                        SupportLevel supportLevel = temp;
                        return supportLevel;
                    }
                    if (temp == null || support.compareTo(temp) >= 0) continue;
                    support = temp;
                }
                Object object = support;
                return object;
            }
            finally {
                LdapSecurityRealm.this.closeContext(dirContext);
            }
        }

        @Override
        public <C extends Credential> C getCredential(Class<C> credentialType) throws RealmUnavailableException {
            return this.getCredential(credentialType, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <C extends Credential> C getCredential(Class<C> credentialType, String algorithmName) throws RealmUnavailableException {
            Assert.checkNotNullParam((String)"credentialType", credentialType);
            if (LdapSecurityRealm.this.getCredentialAcquireSupport(credentialType, algorithmName) == SupportLevel.UNSUPPORTED) {
                return null;
            }
            DirContext dirContext = LdapSecurityRealm.this.obtainContext();
            try {
                HashSet<String> attributes = new HashSet<String>();
                HashSet<String> binaryAttributes = new HashSet<String>();
                for (CredentialLoader loader : LdapSecurityRealm.this.credentialLoaders) {
                    loader.addRequiredIdentityAttributes(attributes);
                    loader.addBinaryIdentityAttributes(binaryAttributes);
                }
                LdapIdentity identity = this.getIdentity(dirContext, attributes, binaryAttributes);
                if (identity == null) {
                    Iterator iterator = null;
                    return (C)iterator;
                }
                for (CredentialLoader loader : LdapSecurityRealm.this.credentialLoaders) {
                    IdentityCredentialLoader icl;
                    C credential;
                    if (!loader.getCredentialAcquireSupport(credentialType, algorithmName).mayBeSupported() || !credentialType.isInstance(credential = (icl = loader.forIdentity(identity.getDirContext(), identity.getDistinguishedName(), identity.getEntry().getAttributes())).getCredential(credentialType, algorithmName, LdapSecurityRealm.this.providers))) continue;
                    Credential credential2 = (Credential)credentialType.cast(credential);
                    return (C)credential2;
                }
            }
            finally {
                LdapSecurityRealm.this.closeContext(dirContext);
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setCredentials(Collection<? extends Credential> credentials) throws RealmUnavailableException {
            Assert.checkNotNullParam((String)"credentials", credentials);
            DirContext dirContext = LdapSecurityRealm.this.obtainContext();
            try {
                String algorithmName;
                Class<?> credentialType;
                HashSet<String> attributes = new HashSet<String>();
                HashSet<String> binaryAttributes = new HashSet<String>();
                for (CredentialPersister persister : LdapSecurityRealm.this.credentialPersisters) {
                    persister.addRequiredIdentityAttributes(attributes);
                    persister.addBinaryIdentityAttributes(binaryAttributes);
                }
                LdapIdentity identity = this.getIdentity(dirContext, attributes, binaryAttributes);
                if (identity == null) {
                    throw ElytronMessages.log.ldapRealmIdentityNotExists(this.name);
                }
                for (Credential credential : credentials) {
                    credentialType = credential.getClass();
                    algorithmName = credential instanceof AlgorithmCredential ? ((AlgorithmCredential)credential).getAlgorithm() : null;
                    boolean supported = false;
                    for (CredentialPersister persister : LdapSecurityRealm.this.credentialPersisters) {
                        IdentityCredentialPersister icp = persister.forIdentity(identity.getDirContext(), identity.getDistinguishedName(), identity.getEntry().getAttributes());
                        if (!icp.getCredentialPersistSupport(credentialType, algorithmName)) continue;
                        supported = true;
                    }
                    if (supported) continue;
                    throw ElytronMessages.log.ldapRealmsPersisterNotSupported();
                }
                for (CredentialPersister credentialPersister : LdapSecurityRealm.this.credentialPersisters) {
                    IdentityCredentialPersister icp = credentialPersister.forIdentity(identity.getDirContext(), identity.getDistinguishedName(), identity.getEntry().getAttributes());
                    icp.clearCredentials();
                }
                block7: for (Credential credential : credentials) {
                    credentialType = credential.getClass();
                    algorithmName = credential instanceof AlgorithmCredential ? ((AlgorithmCredential)credential).getAlgorithm() : null;
                    for (CredentialPersister persister : LdapSecurityRealm.this.credentialPersisters) {
                        IdentityCredentialPersister icp = persister.forIdentity(identity.getDirContext(), identity.getDistinguishedName(), identity.getEntry().getAttributes());
                        if (!icp.getCredentialPersistSupport(credentialType, algorithmName)) continue;
                        icp.persistCredential(credential);
                        continue block7;
                    }
                }
            }
            finally {
                LdapSecurityRealm.this.closeContext(dirContext);
            }
        }

        @Override
        public void dispose() {
            IdentitySharedExclusiveLock.IdentityLock identityLock = this.lock;
            this.lock = null;
            if (identityLock != null) {
                identityLock.release();
            }
        }

        @Override
        public AuthorizationIdentity getAuthorizationIdentity() throws RealmUnavailableException {
            return AuthorizationIdentity.basicIdentity(this.getAttributes());
        }

        @Override
        public Attributes getAttributes() throws RealmUnavailableException {
            DirContext context = null;
            try {
                context = (DirContext)LdapSecurityRealm.this.dirContextSupplier.get();
                LdapIdentity identity = this.getIdentity(context, LdapSecurityRealm.this.identityMapping.attributes.stream().map(AttributeMapping::getIdentityLdapName).filter(Objects::nonNull).collect(Collectors.toSet()), null);
                SearchResult entry = identity != null ? identity.getEntry() : null;
                DirContext identityContext = identity != null ? identity.getDirContext() : null;
                MapAttributes attributes = new MapAttributes();
                attributes.addAll(this.extractSimpleAttributes(entry));
                attributes.addAll(this.extractFilteredAttributes(entry, context, identityContext));
                if (ElytronMessages.log.isDebugEnabled()) {
                    ElytronMessages.log.debugf("Obtaining authorization identity attributes for principal [%s]:", this.name);
                    if (attributes.isEmpty()) {
                        ElytronMessages.log.debugf("Identity [%s] does not have any attributes.", this.name);
                    } else {
                        ElytronMessages.log.debugf("Identity [%s] attributes are:", this.name);
                        attributes.keySet().forEach(key -> {
                            Attributes.Entry values = attributes.get((String)key);
                            values.forEach(value -> ElytronMessages.log.debugf("    Attribute [%s] value [%s].", key, value));
                        });
                    }
                }
                Attributes attributes2 = attributes.asReadOnly();
                return attributes2;
            }
            catch (NamingException e) {
                throw ElytronMessages.log.ldapRealmFailedObtainIdentityFromServer(this.name, e);
            }
            finally {
                LdapSecurityRealm.this.closeContext(context);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SupportLevel getEvidenceVerifySupport(Class<? extends Evidence> evidenceType, String algorithmName) throws RealmUnavailableException {
            Assert.checkNotNullParam((String)"evidenceType", evidenceType);
            DirContext dirContext = LdapSecurityRealm.this.obtainContext();
            try {
                HashSet<String> attributes = new HashSet<String>();
                HashSet<String> binaryAttributes = new HashSet<String>();
                for (Object verifier : LdapSecurityRealm.this.evidenceVerifiers) {
                    verifier.addRequiredIdentityAttributes(attributes);
                    verifier.addBinaryIdentityAttributes(binaryAttributes);
                }
                LdapIdentity identity = this.getIdentity(dirContext, attributes, binaryAttributes);
                if (identity == null) {
                    Object verifier;
                    verifier = SupportLevel.UNSUPPORTED;
                    return verifier;
                }
                SupportLevel response = SupportLevel.UNSUPPORTED;
                for (EvidenceVerifier verifier : LdapSecurityRealm.this.evidenceVerifiers) {
                    if (!verifier.getEvidenceVerifySupport(evidenceType, algorithmName).mayBeSupported()) continue;
                    IdentityEvidenceVerifier iev = verifier.forIdentity(identity.getDirContext(), identity.getDistinguishedName(), identity.getUrl(), identity.getEntry().getAttributes());
                    SupportLevel support = iev.getEvidenceVerifySupport(evidenceType, algorithmName, LdapSecurityRealm.this.providers);
                    if (support != null && support.isDefinitelySupported()) {
                        SupportLevel supportLevel = support;
                        return supportLevel;
                    }
                    if (support == null || response.compareTo(support) >= 0) continue;
                    response = support;
                }
                Object object = response;
                return object;
            }
            finally {
                LdapSecurityRealm.this.closeContext(dirContext);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean verifyEvidence(Evidence evidence) throws RealmUnavailableException {
            String algorithmName;
            Assert.checkNotNullParam((String)"evidence", (Object)evidence);
            Class<?> evidenceType = evidence.getClass();
            String string = algorithmName = evidence instanceof AlgorithmEvidence ? ((AlgorithmEvidence)evidence).getAlgorithm() : null;
            if (LdapSecurityRealm.this.getEvidenceVerifySupport(evidenceType, algorithmName) == SupportLevel.UNSUPPORTED) {
                return false;
            }
            DirContext dirContext = LdapSecurityRealm.this.obtainContext();
            try {
                HashSet<String> attributes = new HashSet<String>();
                HashSet<String> binaryAttributes = new HashSet<String>();
                for (EvidenceVerifier verifier : LdapSecurityRealm.this.evidenceVerifiers) {
                    verifier.addRequiredIdentityAttributes(attributes);
                    verifier.addBinaryIdentityAttributes(binaryAttributes);
                }
                LdapIdentity identity = this.getIdentity(dirContext, attributes, binaryAttributes);
                if (identity == null) {
                    boolean bl = false;
                    return bl;
                }
                for (EvidenceVerifier verifier : LdapSecurityRealm.this.evidenceVerifiers) {
                    IdentityEvidenceVerifier iev;
                    if (!verifier.getEvidenceVerifySupport(evidenceType, algorithmName).mayBeSupported() || !(iev = verifier.forIdentity(identity.getDirContext(), identity.getDistinguishedName(), identity.getUrl(), identity.getEntry().getAttributes())).verifyEvidence(evidence, LdapSecurityRealm.this.providers)) continue;
                    boolean bl = true;
                    return bl;
                }
            }
            finally {
                LdapSecurityRealm.this.closeContext(dirContext);
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean exists() throws RealmUnavailableException {
            DirContext dirContext = LdapSecurityRealm.this.obtainContext();
            try {
                boolean exists;
                LdapIdentity identity = this.getIdentity(dirContext);
                boolean bl = exists = identity != null;
                if (!exists) {
                    ElytronMessages.log.debugf("Principal [%s] does not exists.", this.name);
                }
                boolean bl2 = exists;
                return bl2;
            }
            finally {
                LdapSecurityRealm.this.closeContext(dirContext);
            }
        }

        private LdapSearch createLdapSearchByDn() {
            if (!this.name.regionMatches(true, 0, LdapSecurityRealm.this.identityMapping.rdnIdentifier, 0, LdapSecurityRealm.this.identityMapping.rdnIdentifier.length())) {
                return null;
            }
            try {
                LdapName ldapName = new LdapName(this.name);
                int rdnPosition = ldapName.size() - 1;
                Rdn rdnIdentifier = ldapName.getRdn(rdnPosition);
                if (!rdnIdentifier.getType().equalsIgnoreCase(LdapSecurityRealm.this.identityMapping.rdnIdentifier)) {
                    ElytronMessages.log.tracef("Getting identity [%s] by DN skipped - RDN does not match [%s]", this.name, LdapSecurityRealm.this.identityMapping.rdnIdentifier);
                    return null;
                }
                if (LdapSecurityRealm.this.identityMapping.searchDn != null) {
                    List<Rdn> expectedStart = new LdapName(LdapSecurityRealm.this.identityMapping.searchDn).getRdns();
                    if (!ldapName.startsWith(expectedStart)) {
                        ElytronMessages.log.tracef("Getting identity [%s] by DN skipped - DN not in search-dn [%s]", this.name, LdapSecurityRealm.this.identityMapping.searchDn);
                        return null;
                    }
                    if (!LdapSecurityRealm.this.identityMapping.searchRecursive && ldapName.size() != expectedStart.size() + 1) {
                        ElytronMessages.log.tracef("Getting identity [%s] by DN skipped - DN not directly in search-dn and recursive search not enabled [%s]", this.name, LdapSecurityRealm.this.identityMapping.searchDn);
                        return null;
                    }
                }
                return new LdapSearch(ldapName.toString(), 0, 0, LdapSecurityRealm.this.identityMapping.filterName, rdnIdentifier.getValue().toString());
            }
            catch (InvalidNameException e) {
                ElytronMessages.log.tracef(e, "Getting identity [%s] by DN failed - will continue by name", this.name);
                return null;
            }
        }

        private LdapIdentity getIdentity(DirContext dirContext) throws RealmUnavailableException {
            return this.getIdentity(dirContext, null, null);
        }

        private LdapIdentity getIdentity(DirContext dirContext, Collection<String> returningAttributes, Collection<String> binaryAttributes) throws RealmUnavailableException {
            ElytronMessages.log.debugf("Trying to create identity for principal [%s].", this.name);
            LdapSearch ldapSearch = this.createLdapSearchByDn();
            if (ldapSearch == null) {
                if (LdapSecurityRealm.this.identityMapping.searchDn != null) {
                    ldapSearch = new LdapSearch(LdapSecurityRealm.this.identityMapping.searchDn, LdapSecurityRealm.this.identityMapping.searchRecursive, 0, LdapSecurityRealm.this.identityMapping.filterName, this.name);
                } else {
                    ElytronMessages.log.debugf("Identity for principal [%s] not found. The name is not a valid DN and the search base DN is null", this.name);
                    return null;
                }
            }
            ldapSearch.setReturningAttributes(returningAttributes);
            ldapSearch.setBinaryAttributes(binaryAttributes);
            LdapSearch ldapSearchFinal = ldapSearch;
            try (Stream<SearchResult> resultsStream = ldapSearch.search(dirContext);){
                SearchResult result = resultsStream.findFirst().orElse(null);
                if (result != null) {
                    LdapIdentity identity = new LdapIdentity(this.name, ldapSearchFinal.getContext(), result.getNameInNamespace(), result.isRelative() ? null : result.getName(), result);
                    ElytronMessages.log.debugf("Identity for principal [%s] found at [%s].", this.name, identity.getDistinguishedName());
                    LdapIdentity ldapIdentity = identity;
                    return ldapIdentity;
                }
                ElytronMessages.log.debugf("Identity for principal [%s] not found.", this.name);
                LdapIdentity ldapIdentity = null;
                return ldapIdentity;
            }
        }

        private String extractRdn(AttributeMapping mapping, String dn) {
            String valueRdn = mapping.getRdn();
            try {
                for (Rdn rdn : new LdapName(dn).getRdns()) {
                    if (!rdn.getType().equalsIgnoreCase(valueRdn)) continue;
                    return rdn.getValue().toString();
                }
            }
            catch (Exception cause) {
                throw ElytronMessages.log.ldapRealmInvalidRdnForAttribute(mapping.getName(), dn, valueRdn, cause);
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean valuesFromAttribute(SearchResult entry, AttributeMapping mapping, Collection<String> outputCollection) throws NamingException {
            if (mapping.getLdapName() == null) {
                String value = entry.getNameInNamespace();
                if (mapping.getRdn() != null) {
                    value = this.extractRdn(mapping, value);
                }
                return outputCollection.add(value);
            }
            javax.naming.directory.Attributes entryAttributes = entry.getAttributes();
            Attribute ldapAttribute = entryAttributes.get(mapping.getLdapName());
            if (ldapAttribute == null) {
                return false;
            }
            NamingEnumeration<?> attributesEnum = null;
            try {
                attributesEnum = ldapAttribute.getAll();
                Stream<String> values = Collections.list(attributesEnum).stream().map(Object::toString);
                if (mapping.getRdn() != null) {
                    values = values.map(val -> this.extractRdn(mapping, (String)val)).filter(Objects::nonNull);
                }
                boolean bl = values.map(outputCollection::add).filter(changed -> changed).count() != 0L;
                return bl;
            }
            finally {
                if (attributesEnum != null) {
                    try {
                        attributesEnum.close();
                    }
                    catch (NamingException namingException) {}
                }
            }
        }

        private Map<String, Collection<String>> extractFilteredAttributes(SearchResult identityEntry, DirContext context, DirContext identityContext) {
            return this.extractAttributes(AttributeMapping::isFilteredOrReference, mapping -> {
                ArrayList<String> values = mapping.getRoleRecursionDepth() == 0 ? new ArrayList() : new HashSet();
                String searchDn = mapping.getSearchDn() != null ? mapping.getSearchDn() : LdapSecurityRealm.this.identityMapping.searchDn;
                LinkedList<SearchResult> toSearch = new LinkedList<SearchResult>();
                toSearch.add(identityEntry);
                for (int depth = 0; depth <= mapping.getRoleRecursionDepth() && !toSearch.isEmpty(); ++depth) {
                    LinkedList<SearchResult> toSearchInNextLevel = new LinkedList<SearchResult>();
                    for (SearchResult entry : toSearch) {
                        String entryDn;
                        String string = entryDn = entry != null ? entry.getNameInNamespace() : null;
                        if (mapping.getReference() != null && entry != null) {
                            this.forEachAttributeValue(entry, mapping.getReference(), value -> {
                                LdapSearch search = new LdapSearch((String)value);
                                this.extractFilteredAttributesFromSearch(search, entry, (AttributeMapping)mapping, context, identityContext, (Collection<String>)values, (Collection<SearchResult>)toSearchInNextLevel);
                            });
                            continue;
                        }
                        if (mapping.getReference() != null) continue;
                        if (depth == 0) {
                            LdapSearch search = new LdapSearch(searchDn, mapping.getRecursiveSearch(), 0, mapping.getFilter(), this.name, entryDn);
                            this.extractFilteredAttributesFromSearch(search, entry, (AttributeMapping)mapping, context, identityContext, (Collection<String>)values, (Collection<SearchResult>)toSearchInNextLevel);
                            continue;
                        }
                        if (entry == null) continue;
                        this.forEachAttributeValue(entry, mapping.getRoleRecursionName(), roleName -> {
                            LdapSearch search = new LdapSearch(searchDn, mapping.getRecursiveSearch(), 0, mapping.getFilter(), (String)roleName, entryDn);
                            this.extractFilteredAttributesFromSearch(search, entry, (AttributeMapping)mapping, context, identityContext, (Collection<String>)values, (Collection<SearchResult>)toSearchInNextLevel);
                        });
                    }
                    toSearch = toSearchInNextLevel;
                }
                return values;
            });
        }

        private void extractFilteredAttributesFromSearch(LdapSearch search, SearchResult referencedEntry, AttributeMapping mapping, DirContext context, DirContext identityContext, Collection<String> identityAttributeValues, Collection<SearchResult> toSearchInNextLevel) {
            String referencedDn = referencedEntry != null ? referencedEntry.getNameInNamespace() : null;
            HashSet<String> attributes = new HashSet<String>();
            attributes.add(mapping.getLdapName());
            attributes.add(mapping.getReference());
            attributes.add(mapping.getRoleRecursionName());
            search.setReturningAttributes(attributes);
            try (Stream<SearchResult> entries = search.search(mapping.searchInIdentityContext() ? identityContext : context);){
                entries.forEach(entry -> {
                    try {
                        if (this.valuesFromAttribute((SearchResult)entry, mapping, identityAttributeValues)) {
                            toSearchInNextLevel.add((SearchResult)entry);
                        }
                    }
                    catch (Exception cause) {
                        throw ElytronMessages.log.ldapRealmFailedObtainAttributes(referencedDn, cause);
                    }
                });
            }
            catch (Exception cause) {
                throw ElytronMessages.log.ldapRealmFailedObtainAttributes(referencedDn, cause);
            }
        }

        private Map<String, Collection<String>> extractSimpleAttributes(SearchResult identityEntry) {
            if (identityEntry == null) {
                return Collections.emptyMap();
            }
            return this.extractAttributes(mapping -> !mapping.isFilteredOrReference(), mapping -> {
                ArrayList<String> identityAttributeValues = new ArrayList<String>();
                try {
                    this.valuesFromAttribute(identityEntry, (AttributeMapping)mapping, (Collection<String>)identityAttributeValues);
                }
                catch (Exception cause) {
                    throw ElytronMessages.log.ldapRealmFailedObtainAttributes(identityEntry.getNameInNamespace(), cause);
                }
                return identityAttributeValues;
            });
        }

        private Map<String, Collection<String>> extractAttributes(Predicate<AttributeMapping> filter, Function<AttributeMapping, Collection<String>> valueFunction) {
            return LdapSecurityRealm.this.identityMapping.attributes.stream().filter(filter).collect(Collectors.toMap(AttributeMapping::getName, valueFunction, (values1, values2) -> {
                ArrayList merged = new ArrayList(values1);
                merged.addAll(values2);
                return merged;
            }));
        }

        private void forEachAttributeValue(SearchResult entry, String attrId, Consumer<String> action) {
            NamingEnumeration<?> attributesEnum = null;
            try {
                Attribute attribute = entry.getAttributes().get(attrId);
                if (attribute == null) {
                    return;
                }
                attributesEnum = attribute.getAll();
                Collections.list(attributesEnum).stream().map(Object::toString).forEach(action);
            }
            catch (NamingException e) {
                throw ElytronMessages.log.ldapRealmFailedObtainAttributes(entry.getNameInNamespace(), e);
            }
            finally {
                if (attributesEnum != null) {
                    try {
                        attributesEnum.close();
                    }
                    catch (NamingException e) {
                        ElytronMessages.log.trace("Unable to close attributesEnum", e);
                    }
                }
            }
        }

        @Override
        public void delete() throws RealmUnavailableException {
            DirContext context;
            try {
                context = (DirContext)LdapSecurityRealm.this.dirContextSupplier.get();
            }
            catch (NamingException e) {
                throw ElytronMessages.log.ldapRealmFailedDeleteIdentityFromServer(e);
            }
            try {
                LdapIdentity identity = this.getIdentity(context);
                if (identity == null) {
                    throw ElytronMessages.log.noSuchIdentity();
                }
                ElytronMessages.log.debugf("Removing identity [%s] with DN [%s] from LDAP", this.name, identity.getDistinguishedName());
                identity.getDirContext().destroySubcontext(new LdapName(identity.getDistinguishedName()));
            }
            catch (NamingException e) {
                throw ElytronMessages.log.ldapRealmFailedDeleteIdentityFromServer(e);
            }
            finally {
                LdapSecurityRealm.this.closeContext(context);
            }
        }

        @Override
        public void create() throws RealmUnavailableException {
            DirContext context;
            if (LdapSecurityRealm.this.identityMapping.newIdentityParent == null || LdapSecurityRealm.this.identityMapping.newIdentityAttributes == null) {
                throw ElytronMessages.log.ldapRealmNotConfiguredToSupportCreatingIdentities();
            }
            try {
                context = (DirContext)LdapSecurityRealm.this.dirContextSupplier.get();
            }
            catch (NamingException e) {
                throw ElytronMessages.log.ldapRealmFailedCreateIdentityOnServer(e);
            }
            try {
                LdapName distinguishName = (LdapName)LdapSecurityRealm.this.identityMapping.newIdentityParent.clone();
                distinguishName.add(new Rdn(LdapSecurityRealm.this.identityMapping.rdnIdentifier, this.name));
                ElytronMessages.log.debugf("Creating identity [%s] with DN [%s] in LDAP", this.name, distinguishName.toString());
                context.createSubcontext(distinguishName, LdapSecurityRealm.this.identityMapping.newIdentityAttributes);
            }
            catch (NamingException e) {
                throw ElytronMessages.log.ldapRealmFailedCreateIdentityOnServer(e);
            }
            finally {
                LdapSecurityRealm.this.closeContext(context);
            }
        }

        @Override
        public void setAttributes(Attributes attributes) throws RealmUnavailableException {
            DirContext context;
            ElytronMessages.log.debugf("Trying to set attributes for principal [%s].", this.name);
            try {
                context = (DirContext)LdapSecurityRealm.this.dirContextSupplier.get();
            }
            catch (Exception e) {
                throw ElytronMessages.log.ldapRealmAttributesSettingFailed(this.name, e);
            }
            try {
                LdapIdentity identity = this.getIdentity(context);
                if (identity == null) {
                    throw ElytronMessages.log.noSuchIdentity();
                }
                LinkedList<ModificationItem> modItems = new LinkedList<ModificationItem>();
                LdapName identityLdapName = new LdapName(identity.getDistinguishedName());
                String renameTo = null;
                for (AttributeMapping mapping : LdapSecurityRealm.this.identityMapping.attributes) {
                    BasicAttribute attribute;
                    if (mapping.getFilter() != null || mapping.getReference() != null || mapping.getRdn() != null) {
                        if (attributes.size(mapping.getName()) == 0) continue;
                        ElytronMessages.log.ldapRealmDoesNotSupportSettingFilteredAttribute(mapping.getName(), this.name);
                        continue;
                    }
                    if (LdapSecurityRealm.this.identityMapping.rdnIdentifier.equalsIgnoreCase(mapping.getLdapName())) {
                        if (attributes.size(mapping.getName()) == 1) {
                            renameTo = attributes.get(mapping.getName(), 0);
                            continue;
                        }
                        throw ElytronMessages.log.ldapRealmRequiresExactlyOneRdnAttribute(mapping.getName(), this.name);
                    }
                    if (attributes.size(mapping.getName()) == 0) {
                        attribute = new BasicAttribute(mapping.getLdapName());
                        modItems.add(new ModificationItem(3, attribute));
                        continue;
                    }
                    attribute = new BasicAttribute(mapping.getLdapName());
                    attributes.get(mapping.getName()).forEach(attribute::add);
                    modItems.add(new ModificationItem(2, attribute));
                }
                for (Attributes.Entry entry : attributes.entries()) {
                    if (LdapSecurityRealm.this.identityMapping.attributes.stream().filter(mp -> mp.getName().equals(entry.getKey())).count() != 0L) continue;
                    throw ElytronMessages.log.ldapRealmCannotSetAttributeWithoutMapping(entry.getKey(), this.name);
                }
                ModificationItem[] modItemsArray = modItems.toArray(new ModificationItem[modItems.size()]);
                identity.getDirContext().modifyAttributes(identityLdapName, modItemsArray);
                if (renameTo != null && !renameTo.equals(identityLdapName.getRdn(identityLdapName.size() - 1).getValue())) {
                    LdapName newLdapName = new LdapName(identityLdapName.getRdns().subList(0, identityLdapName.size() - 1));
                    newLdapName.add(new Rdn(LdapSecurityRealm.this.identityMapping.rdnIdentifier, renameTo));
                    identity.getDirContext().rename(identityLdapName, newLdapName);
                }
            }
            catch (Exception e) {
                throw ElytronMessages.log.ldapRealmAttributesSettingFailed(this.name, e);
            }
            finally {
                LdapSecurityRealm.this.closeContext(context);
            }
        }

        private class LdapIdentity {
            private final String name;
            private final DirContext dirContext;
            private final String distinguishedName;
            private final String url;
            private final SearchResult entry;

            LdapIdentity(String name, DirContext dirContext, String distinguishedName, String url, SearchResult entry) {
                this.name = name;
                this.dirContext = dirContext;
                this.distinguishedName = distinguishedName;
                this.url = url;
                this.entry = entry;
            }

            String getName() {
                return this.name;
            }

            DirContext getDirContext() {
                return this.dirContext;
            }

            String getDistinguishedName() {
                return this.distinguishedName;
            }

            String getUrl() {
                return this.url;
            }

            SearchResult getEntry() {
                return this.entry;
            }
        }
    }
}

