/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.sasl.digest;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.Provider;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.function.Supplier;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.RealmCallback;
import javax.security.sasl.RealmChoiceCallback;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;
import org.wildfly.common.Assert;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.mechanism.AuthenticationMechanismException;
import org.wildfly.security.mechanism.digest.DigestQuote;
import org.wildfly.security.sasl.digest.AbstractDigestMechanism;
import org.wildfly.security.sasl.digest._private.DigestUtil;
import org.wildfly.security.util.ByteStringBuilder;
import org.wildfly.security.util.DefaultTransformationMapper;
import org.wildfly.security.util.TransformationSpec;

class DigestSaslClient
extends AbstractDigestMechanism
implements SaslClient {
    private static final byte STEP_TWO = 2;
    private static final byte STEP_FOUR = 4;
    private String[] realms;
    private String[] clientQops;
    private boolean stale = false;
    private int maxbuf = 65536;
    private String cipher_opts;
    private final String authorizationId;
    private final boolean hasInitialResponse;
    private final String[] demandedCiphers;

    DigestSaslClient(String mechanism, String protocol, String serverName, CallbackHandler callbackHandler, String authorizationId, boolean hasInitialResponse, Charset charset, String[] qops, String[] ciphers, Supplier<Provider[]> providers) throws SaslException {
        super(mechanism, protocol, serverName, callbackHandler, AbstractDigestMechanism.FORMAT.CLIENT, charset, ciphers, providers);
        this.hasInitialResponse = hasInitialResponse;
        this.authorizationId = authorizationId;
        this.clientQops = qops == null ? DigestUtil.QOP_VALUES : qops;
        this.demandedCiphers = ciphers == null ? new String[]{} : ciphers;
    }

    private void noteChallengeData(HashMap<String, byte[]> parsedChallenge) throws SaslException {
        LinkedList<String> realmList = new LinkedList<String>();
        for (String keyWord : parsedChallenge.keySet()) {
            if (keyWord.startsWith("realm")) {
                realmList.add(new String(parsedChallenge.get(keyWord), StandardCharsets.UTF_8));
                continue;
            }
            if (keyWord.equals("qop")) {
                String serverQops = new String(parsedChallenge.get(keyWord), StandardCharsets.UTF_8);
                this.qop = this.selectQop(serverQops.split(String.valueOf(',')), this.clientQops);
                continue;
            }
            if (keyWord.equals("stale")) {
                this.stale = Boolean.parseBoolean(new String(parsedChallenge.get(keyWord), StandardCharsets.UTF_8));
                continue;
            }
            if (keyWord.equals("maxbuf")) {
                int maxbuf = Integer.parseInt(new String(parsedChallenge.get(keyWord), StandardCharsets.UTF_8));
                if (maxbuf <= 0) continue;
                this.maxbuf = maxbuf;
                continue;
            }
            if (keyWord.equals("nonce")) {
                this.nonce = parsedChallenge.get(keyWord);
                continue;
            }
            if (!keyWord.equals("cipher")) continue;
            this.cipher_opts = new String(parsedChallenge.get(keyWord), StandardCharsets.UTF_8);
            this.cipher = this.selectCipher(this.cipher_opts);
        }
        if (this.qop != null && !this.qop.equals("auth")) {
            this.setWrapper(new AbstractDigestMechanism.DigestWrapper(this, this.qop.equals("auth-conf")));
        }
        this.realms = new String[realmList.size()];
        realmList.toArray(this.realms);
    }

    private String selectQop(String[] serverQops, String[] clientQops) throws SaslException {
        for (String clientQop : clientQops) {
            if (!this.arrayContains(serverQops, clientQop)) continue;
            return clientQop;
        }
        throw ElytronMessages.log.mechNoCommonProtectionLayer(this.getMechanismName()).toSaslException();
    }

    private String selectCipher(String ciphersFromServer) throws SaslException {
        if (ciphersFromServer == null) {
            throw ElytronMessages.log.mechNoCiphersOfferedByServer(this.getMechanismName()).toSaslException();
        }
        DefaultTransformationMapper trans = new DefaultTransformationMapper();
        String[] tokensToChooseFrom = ciphersFromServer.split(String.valueOf(','));
        for (TransformationSpec ts : trans.getTransformationSpecByStrength("DIGEST-MD5", tokensToChooseFrom)) {
            for (String c : this.demandedCiphers) {
                if (!c.equals(ts.getToken())) continue;
                return ts.getToken();
            }
        }
        throw ElytronMessages.log.mechNoCommonCipher(this.getMechanismName()).toSaslException();
    }

    private byte[] createResponse(HashMap<String, byte[]> parsedChallenge) throws SaslException {
        NameCallback nameCallback;
        RealmCallback realmCallback;
        byte[] digest_urp;
        String chs;
        ByteStringBuilder digestResponse = new ByteStringBuilder();
        byte[] chb = parsedChallenge.get("charset");
        Charset serverHashedURPUsingcharset = chb != null ? ("utf-8".equals(chs = new String(chb, StandardCharsets.UTF_8)) ? StandardCharsets.UTF_8 : StandardCharsets.ISO_8859_1) : StandardCharsets.ISO_8859_1;
        if (StandardCharsets.UTF_8.equals(serverHashedURPUsingcharset)) {
            digestResponse.append("charset=");
            digestResponse.append("utf-8");
            digestResponse.append(',');
        }
        String realm = null;
        if (this.realms != null && this.realms.length > 0) {
            try {
                if (this.realms.length > 1) {
                    RealmChoiceCallback realmChoiceCallBack = new RealmChoiceCallback("User realm", this.realms, 0, false);
                    this.tryHandleCallbacks(realmChoiceCallBack);
                    realm = this.realms[realmChoiceCallBack.getSelectedIndexes()[0]];
                } else {
                    realm = this.realms[0];
                }
            }
            catch (UnsupportedCallbackException e) {
                throw ElytronMessages.log.mechCallbackHandlerFailedForUnknownReason(this.getMechanismName(), e).toSaslException();
            }
        }
        if ((digest_urp = this.getPredigestedSaltedPassword(realmCallback = realm != null ? new RealmCallback("User realm", realm) : new RealmCallback("User realm"), nameCallback = this.authorizationId != null ? new NameCallback("User name", this.authorizationId) : new NameCallback("User name"))) == null) {
            digest_urp = this.getSaltedPasswordFromTwoWay(realmCallback, nameCallback, false);
        }
        if (digest_urp == null) {
            digest_urp = this.getSaltedPasswordFromPasswordCallback(realmCallback, nameCallback, false);
        }
        if (digest_urp == null) {
            throw ElytronMessages.log.mechCallbackHandlerDoesNotSupportCredentialAcquisition(this.getMechanismName(), null).toSaslException();
        }
        realm = realmCallback.getText();
        String userName = nameCallback.getName();
        if (userName == null) {
            throw ElytronMessages.log.mechNotProvidedUserName(this.getMechanismName()).toSaslException();
        }
        digestResponse.append("username=\"");
        digestResponse.append(DigestQuote.quote(userName).getBytes(serverHashedURPUsingcharset));
        digestResponse.append("\"").append(',');
        if (realm != null) {
            digestResponse.append("realm=\"");
            digestResponse.append(DigestQuote.quote(realm).getBytes(serverHashedURPUsingcharset));
            digestResponse.append("\"").append(',');
        }
        if (this.nonce == null) {
            throw ElytronMessages.log.mechMissingDirective(this.getMechanismName(), "nonce").toSaslException();
        }
        digestResponse.append("nonce=\"");
        digestResponse.append(this.nonce);
        digestResponse.append("\"").append(',');
        digestResponse.append("nc=");
        int nonceCount = this.getNonceCount();
        digestResponse.append(DigestUtil.convertToHexBytesWithLeftPadding(nonceCount, 8));
        digestResponse.append(',');
        digestResponse.append("cnonce=\"");
        this.cnonce = DigestSaslClient.generateNonce();
        digestResponse.append(this.cnonce);
        digestResponse.append("\"").append(',');
        digestResponse.append("digest-uri=\"");
        digestResponse.append(this.digestURI);
        digestResponse.append("\"").append(',');
        digestResponse.append("maxbuf=");
        digestResponse.append(String.valueOf(this.maxbuf));
        digestResponse.append(',');
        this.hA1 = DigestUtil.H_A1(this.messageDigest, digest_urp, this.nonce, this.cnonce, this.authorizationId, serverHashedURPUsingcharset);
        byte[] response_value = DigestUtil.digestResponse(this.messageDigest, this.hA1, this.nonce, nonceCount, this.cnonce, this.authorizationId, this.qop, this.digestURI, true);
        digestResponse.append("response=");
        digestResponse.append(response_value);
        digestResponse.append(',');
        digestResponse.append("qop=");
        digestResponse.append(this.qop != null ? this.qop : "auth");
        if (this.cipher != null && this.cipher.length() != 0) {
            digestResponse.append(',');
            digestResponse.append("cipher=\"");
            digestResponse.append(this.cipher);
            digestResponse.append("\"");
        }
        if (this.authorizationId != null) {
            digestResponse.append(',');
            digestResponse.append("authzid=\"");
            digestResponse.append(DigestQuote.quote(this.authorizationId).getBytes(serverHashedURPUsingcharset));
            digestResponse.append("\"");
        }
        this.createCiphersAndKeys();
        return digestResponse.toArray();
    }

    private int getNonceCount() {
        return 1;
    }

    private void checkResponseAuth(HashMap<String, byte[]> parsedChallenge) throws SaslException {
        byte[] expected = DigestUtil.digestResponse(this.messageDigest, this.hA1, this.nonce, this.getNonceCount(), this.cnonce, this.authzid, this.qop, this.digestURI, false);
        if (!Arrays.equals(expected, parsedChallenge.get("rspauth"))) {
            throw ElytronMessages.log.mechServerAuthenticityCannotBeVerified(this.getMechanismName()).toSaslException();
        }
    }

    @Override
    public void init() {
        this.setNegotiationState(2);
    }

    @Override
    public boolean hasInitialResponse() {
        return this.hasInitialResponse;
    }

    @Override
    public byte[] evaluateChallenge(byte[] challenge) throws SaslException {
        return this.evaluateMessage(challenge);
    }

    @Override
    protected byte[] evaluateMessage(int state, byte[] message) throws SaslException {
        HashMap<String, byte[]> parsedChallenge;
        try {
            parsedChallenge = org.wildfly.security.mechanism.digest.DigestUtil.parseResponse(message, this.charset, true, this.getMechanismName());
        }
        catch (AuthenticationMechanismException e) {
            throw e.toSaslException();
        }
        switch (state) {
            case 2: {
                this.noteChallengeData(parsedChallenge);
                this.setNegotiationState(4);
                return this.createResponse(parsedChallenge);
            }
            case 4: {
                this.checkResponseAuth(parsedChallenge);
                this.negotiationComplete();
                return null;
            }
        }
        throw Assert.impossibleSwitchCase((int)state);
    }
}

