/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.sasl.gs2;

import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.SaslException;
import org.ietf.jgss.ChannelBinding;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;
import org.wildfly.common.Assert;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.asn1.ASN1Exception;
import org.wildfly.security.asn1.DEREncoder;
import org.wildfly.security.auth.callback.CredentialCallback;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.credential.GSSCredentialCredential;
import org.wildfly.security.sasl.gs2.Gs2;
import org.wildfly.security.sasl.gs2.Gs2Util;
import org.wildfly.security.sasl.util.AbstractSaslServer;
import org.wildfly.security.util.ByteIterator;
import org.wildfly.security.util.ByteStringBuilder;
import org.wildfly.security.util.CodePointIterator;

final class Gs2SaslServer
extends AbstractSaslServer {
    private static final int ST_NO_MESSAGE = 1;
    private static final int ST_FIRST_MESSAGE = 2;
    private static final int ST_ACCEPTOR = 3;
    private final boolean plus;
    private final String bindingType;
    private final byte[] bindingData;
    private final Oid mechanism;
    private GSSContext gssContext;
    private String authorizationID;

    Gs2SaslServer(String mechanismName, String protocol, String serverName, CallbackHandler callbackHandler, GSSManager gssManager, boolean plus, String bindingType, byte[] bindingData) throws SaslException {
        super(mechanismName, protocol, serverName, callbackHandler);
        this.plus = plus;
        this.bindingType = bindingType;
        this.bindingData = bindingData;
        try {
            this.mechanism = Gs2.getMechanismForSaslName(gssManager, mechanismName);
        }
        catch (GSSException e) {
            throw ElytronMessages.log.mechMechanismToOidMappingFailed(this.getMechanismName(), e).toSaslException();
        }
        GSSCredential credential = null;
        CredentialCallback credentialCallback = new CredentialCallback(GSSCredentialCredential.class);
        try {
            this.tryHandleCallbacks(credentialCallback);
            Credential credentialHolder = credentialCallback.getCredential();
            if (credentialHolder instanceof GSSCredentialCredential) {
                credential = ((GSSCredentialCredential)credentialHolder).getGssCredential();
            }
        }
        catch (IllegalStateException | UnsupportedCallbackException | SaslException e) {
            try {
                String localNameStr = protocol + "@" + serverName;
                GSSName localName = gssManager.createName(localNameStr, GSSName.NT_HOSTBASED_SERVICE, this.mechanism);
                credential = gssManager.createCredential(localName, Integer.MAX_VALUE, this.mechanism, 2);
            }
            catch (GSSException e1) {
                throw ElytronMessages.log.mechUnableToCreateGssContext(this.getMechanismName(), e1).toSaslException();
            }
        }
        try {
            this.gssContext = gssManager.createContext(credential);
        }
        catch (GSSException e) {
            throw ElytronMessages.log.mechUnableToCreateGssContext(this.getMechanismName(), e).toSaslException();
        }
    }

    @Override
    public void init() {
        this.setNegotiationState(1);
    }

    @Override
    public String getAuthorizationID() {
        return this.authorizationID;
    }

    @Override
    protected byte[] evaluateMessage(int state, byte[] message) throws SaslException {
        switch (state) {
            case 1: {
                if (message == null || message.length == 0) {
                    this.setNegotiationState(3);
                    return NO_BYTES;
                }
            }
            case 2: {
                byte[] token;
                int gs2HeaderLength;
                int gs2HeaderStartIndex;
                assert (!this.gssContext.isEstablished());
                if (message == null || message.length == 0) {
                    throw ElytronMessages.log.mechClientRefusesToInitiateAuthentication(this.getMechanismName()).toSaslException();
                }
                ByteIterator bi = ByteIterator.ofBytes(message);
                ByteIterator di = bi.delimitedBy(44);
                CodePointIterator cpi = di.asUtf8String();
                boolean gs2CbFlagPUsed = false;
                boolean nonStd = false;
                int b = bi.next();
                if (b == 70) {
                    this.skipDelimiter(bi);
                    nonStd = true;
                    b = bi.next();
                }
                if (b == 112) {
                    gs2CbFlagPUsed = true;
                    if (!this.plus) {
                        throw ElytronMessages.log.mechChannelBindingNotSupported(this.getMechanismName()).toSaslException();
                    }
                    if (bi.next() != 61) {
                        throw ElytronMessages.log.mechInvalidMessageReceived(this.getMechanismName()).toSaslException();
                    }
                    assert (this.bindingType != null);
                    assert (this.bindingData != null);
                    if (!this.bindingType.equals(cpi.drainToString())) {
                        throw ElytronMessages.log.mechChannelBindingTypeMismatch(this.getMechanismName()).toSaslException();
                    }
                    this.skipDelimiter(bi);
                } else if (b == 121 || b == 110) {
                    if (this.plus) {
                        throw ElytronMessages.log.mechChannelBindingNotProvided(this.getMechanismName()).toSaslException();
                    }
                    this.skipDelimiter(bi);
                } else {
                    throw ElytronMessages.log.mechInvalidMessageReceived(this.getMechanismName()).toSaslException();
                }
                b = bi.next();
                if (b == 97) {
                    if (bi.next() != 61) {
                        throw ElytronMessages.log.mechInvalidMessageReceived(this.getMechanismName()).toSaslException();
                    }
                    this.authorizationID = cpi.drainToString();
                    this.skipDelimiter(bi);
                } else if (b != 44) {
                    throw ElytronMessages.log.mechInvalidMessageReceived(this.getMechanismName()).toSaslException();
                }
                if (nonStd) {
                    gs2HeaderStartIndex = 2;
                    gs2HeaderLength = bi.offset() - 2;
                    token = bi.drain();
                } else {
                    gs2HeaderStartIndex = 0;
                    gs2HeaderLength = bi.offset();
                    try {
                        token = this.restoreTokenHeader(bi.drain());
                    }
                    catch (ASN1Exception e) {
                        throw ElytronMessages.log.mechUnableToCreateResponseTokenWithCause(this.getMechanismName(), e).toSaslException();
                    }
                }
                ByteStringBuilder gs2HeaderExcludingNonStdFlag = new ByteStringBuilder();
                gs2HeaderExcludingNonStdFlag.append(message, gs2HeaderStartIndex, gs2HeaderLength);
                try {
                    ChannelBinding channelBinding = Gs2Util.createChannelBinding(gs2HeaderExcludingNonStdFlag, gs2CbFlagPUsed, this.bindingData);
                    this.gssContext.setChannelBinding(channelBinding);
                }
                catch (GSSException e) {
                    throw ElytronMessages.log.mechUnableToSetChannelBinding(this.getMechanismName(), e).toSaslException();
                }
                try {
                    byte[] response = this.gssContext.acceptSecContext(token, 0, token.length);
                    if (this.gssContext.isEstablished()) {
                        Oid actualMechanism = this.gssContext.getMech();
                        if (!this.mechanism.equals(actualMechanism)) {
                            throw ElytronMessages.log.mechGssApiMechanismMismatch(this.getMechanismName()).toSaslException();
                        }
                        this.checkAuthorizationID();
                        this.negotiationComplete();
                    } else {
                        this.setNegotiationState(3);
                    }
                    return response;
                }
                catch (GSSException e) {
                    throw ElytronMessages.log.mechUnableToAcceptClientMessage(this.getMechanismName(), e).toSaslException();
                }
            }
            case 3: {
                assert (!this.gssContext.isEstablished());
                try {
                    byte[] response = this.gssContext.acceptSecContext(message, 0, message.length);
                    if (this.gssContext.isEstablished()) {
                        Oid actualMechanism = this.gssContext.getMech();
                        if (!this.mechanism.equals(actualMechanism)) {
                            throw ElytronMessages.log.mechGssApiMechanismMismatch(this.getMechanismName()).toSaslException();
                        }
                        this.checkAuthorizationID();
                        this.negotiationComplete();
                    }
                    return response;
                }
                catch (GSSException e) {
                    throw ElytronMessages.log.mechUnableToAcceptClientMessage(this.getMechanismName(), e).toSaslException();
                }
            }
            case 0: {
                if (message != null && message.length != 0) {
                    throw ElytronMessages.log.mechMessageAfterComplete(this.getMechanismName()).toSaslException();
                }
                return null;
            }
        }
        throw Assert.impossibleSwitchCase((int)state);
    }

    @Override
    public void dispose() throws SaslException {
        try {
            this.gssContext.dispose();
        }
        catch (GSSException e) {
            throw ElytronMessages.log.mechUnableToDisposeGssContext(this.getMechanismName(), e).toSaslException();
        }
        finally {
            this.gssContext = null;
        }
    }

    private byte[] restoreTokenHeader(byte[] token) throws ASN1Exception {
        ByteStringBuilder headerAndToken = new ByteStringBuilder();
        DEREncoder encoder = new DEREncoder(headerAndToken);
        encoder.encodeImplicit(64, 0);
        encoder.startSequence();
        try {
            encoder.writeEncoded(this.mechanism.getDER());
        }
        catch (GSSException e) {
            throw new ASN1Exception(e);
        }
        encoder.writeEncoded(token);
        encoder.endSequence();
        return headerAndToken.toArray();
    }

    private void checkAuthorizationID() throws SaslException {
        String authenticationID;
        try {
            authenticationID = this.gssContext.getSrcName().toString();
        }
        catch (GSSException e) {
            throw ElytronMessages.log.mechUnableToDeterminePeerName(this.getMechanismName(), e).toSaslException();
        }
        if (this.authorizationID == null) {
            this.authorizationID = authenticationID;
        }
        AuthorizeCallback authorizeCallback = new AuthorizeCallback(authenticationID, this.authorizationID);
        this.handleCallbacks(authorizeCallback);
        if (!authorizeCallback.isAuthorized()) {
            throw ElytronMessages.log.mechAuthorizationFailed(this.getMechanismName(), authenticationID, this.authorizationID).toSaslException();
        }
    }

    private void skipDelimiter(ByteIterator bi) throws SaslException {
        if (bi.next() != 44) {
            throw ElytronMessages.log.mechInvalidMessageReceived(this.getMechanismName()).toSaslException();
        }
    }
}

