/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.http.util;

import java.lang.reflect.UndeclaredThrowableException;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.List;
import org.wildfly.common.Assert;
import org.wildfly.security.auth.server.SecurityIdentity;
import org.wildfly.security.http.HttpAuthenticationException;
import org.wildfly.security.http.HttpServerAuthenticationMechanism;
import org.wildfly.security.http.HttpServerMechanismsResponder;
import org.wildfly.security.http.HttpServerRequest;

final class PrivilegedServerMechanism
implements HttpServerAuthenticationMechanism {
    private final HttpServerAuthenticationMechanism mechanism;
    private final AccessControlContext accessControlContext;

    PrivilegedServerMechanism(HttpServerAuthenticationMechanism mechanism, AccessControlContext accessControlContext) {
        this.mechanism = (HttpServerAuthenticationMechanism)Assert.checkNotNullParam((String)"mechanism", (Object)mechanism);
        this.accessControlContext = (AccessControlContext)Assert.checkNotNullParam((String)"accessControlContext", (Object)accessControlContext);
    }

    @Override
    public String getMechanismName() {
        return this.mechanism.getMechanismName();
    }

    @Override
    public void evaluateRequest(HttpServerRequest request) throws HttpAuthenticationException {
        try {
            AccessController.doPrivileged(() -> {
                this.mechanism.evaluateRequest(new HttpServerRequestWrapper(request));
                return null;
            }, this.accessControlContext);
        }
        catch (PrivilegedActionException pae) {
            try {
                throw pae.getCause();
            }
            catch (Error | RuntimeException | HttpAuthenticationException e) {
                throw e;
            }
            catch (Throwable throwable) {
                throw new UndeclaredThrowableException(throwable);
            }
        }
    }

    private HttpServerMechanismsResponder wrap(HttpServerMechanismsResponder toWrap) {
        return toWrap != null ? r -> AccessController.doPrivileged(() -> {
            toWrap.sendResponse(r);
            return null;
        }, this.accessControlContext) : null;
    }

    private class HttpServerRequestWrapper
    implements HttpServerRequest {
        private final HttpServerRequest wrapped;

        private HttpServerRequestWrapper(HttpServerRequest toWrap) {
            this.wrapped = toWrap;
        }

        @Override
        public List<String> getRequestHeaderValues(String headerName) {
            return this.wrapped.getRequestHeaderValues(headerName);
        }

        @Override
        public String getFirstRequestHeaderValue(String headerName) {
            return this.wrapped.getFirstRequestHeaderValue(headerName);
        }

        @Override
        public void noAuthenticationInProgress(HttpServerMechanismsResponder responder) {
            this.wrapped.noAuthenticationInProgress(PrivilegedServerMechanism.this.wrap(responder));
        }

        @Override
        public void authenticationInProgress(HttpServerMechanismsResponder responder) {
            this.wrapped.authenticationInProgress(PrivilegedServerMechanism.this.wrap(responder));
        }

        @Override
        public void authenticationComplete(SecurityIdentity securityIdentity, HttpServerMechanismsResponder responder) {
            this.wrapped.authenticationComplete(securityIdentity, PrivilegedServerMechanism.this.wrap(responder));
        }

        @Override
        public void authenticationFailed(String message, HttpServerMechanismsResponder responder) {
            this.wrapped.authenticationFailed(message, PrivilegedServerMechanism.this.wrap(responder));
        }

        @Override
        public void badRequest(HttpAuthenticationException failure, HttpServerMechanismsResponder responder) {
            this.wrapped.badRequest(failure, PrivilegedServerMechanism.this.wrap(responder));
        }
    }
}

