/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.server;

import java.security.Principal;
import org.wildfly.common.Assert;
import org.wildfly.security.evidence.Evidence;

public interface RealmMapper {
    public static final RealmMapper DEFAULT_REALM_MAPPER = RealmMapper.single(null);

    public String getRealmMapping(String var1, Principal var2, Evidence var3);

    public static RealmMapper single(String realmName) {
        return (name, principal, evidence) -> realmName;
    }

    public static RealmMapper aggregate(RealmMapper mapper1, RealmMapper mapper2) {
        Assert.checkNotNullParam((String)"mapper1", (Object)mapper1);
        Assert.checkNotNullParam((String)"mapper2", (Object)mapper2);
        return (name, principal, evidence) -> {
            String mapping = mapper1.getRealmMapping(name, principal, evidence);
            if (mapping == null) {
                mapping = mapper2.getRealmMapping(name, principal, evidence);
            }
            return mapping;
        };
    }

    public static RealmMapper aggregate(RealmMapper ... mappers) {
        Assert.checkNotNullParam((String)"mappers", (Object)mappers);
        return (name, principal, evidence) -> {
            for (RealmMapper mapper : mappers) {
                String mapping;
                if (mapper == null || (mapping = mapper.getRealmMapping(name, principal, evidence)) == null) continue;
                return mapping;
            }
            return null;
        };
    }
}

