/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.provider.ldap;

import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.NoSuchAttributeException;
import org.wildfly.common.Assert;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.auth.provider.ldap.CredentialPersister;
import org.wildfly.security.auth.provider.ldap.DirContextFactory;
import org.wildfly.security.auth.provider.ldap.IdentityCredentialPersister;
import org.wildfly.security.auth.server.RealmUnavailableException;
import org.wildfly.security.auth.server.SupportLevel;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.credential.PasswordCredential;
import org.wildfly.security.password.Password;
import org.wildfly.security.password.PasswordFactory;
import org.wildfly.security.password.interfaces.OneTimePassword;
import org.wildfly.security.password.spec.OneTimePasswordSpec;
import org.wildfly.security.util.Alphabet;
import org.wildfly.security.util.ByteIterator;
import org.wildfly.security.util.CodePointIterator;

class OtpCredentialLoader
implements CredentialPersister {
    private final String algorithmAttributeName;
    private final String hashAttributeName;
    private final String seedAttributeName;
    private final String sequenceAttributeName;

    OtpCredentialLoader(String algorithmAttributeName, String hashAttributeName, String seedAttributeName, String sequenceAttributeName) {
        Assert.checkNotNullParam((String)"algorithmAttributeName", (Object)algorithmAttributeName);
        Assert.checkNotNullParam((String)"hashAttributeName", (Object)hashAttributeName);
        Assert.checkNotNullParam((String)"seedAttributeName", (Object)seedAttributeName);
        Assert.checkNotNullParam((String)"sequenceAttributeName", (Object)sequenceAttributeName);
        this.algorithmAttributeName = algorithmAttributeName;
        this.hashAttributeName = hashAttributeName;
        this.seedAttributeName = seedAttributeName;
        this.sequenceAttributeName = sequenceAttributeName;
    }

    @Override
    public SupportLevel getCredentialAcquireSupport(DirContextFactory contextFactory, Class<? extends Credential> credentialType, String algorithmName) {
        if (credentialType == PasswordCredential.class) {
            if (algorithmName == null) {
                return SupportLevel.SUPPORTED;
            }
            switch (algorithmName) {
                case "otp-md5": {
                    return SupportLevel.POSSIBLY_SUPPORTED;
                }
                case "otp-sha1": {
                    return SupportLevel.POSSIBLY_SUPPORTED;
                }
            }
            return SupportLevel.UNSUPPORTED;
        }
        return SupportLevel.UNSUPPORTED;
    }

    @Override
    public ForIdentityLoader forIdentity(DirContextFactory contextFactory, String distinguishedName) {
        return new ForIdentityLoader(contextFactory, distinguishedName);
    }

    private class ForIdentityLoader
    implements IdentityCredentialPersister {
        private final DirContextFactory contextFactory;
        private final String distinguishedName;

        public ForIdentityLoader(DirContextFactory contextFactory, String distinguishedName) {
            this.contextFactory = contextFactory;
            this.distinguishedName = distinguishedName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String algorithmName) {
            if (credentialType != PasswordCredential.class) {
                return SupportLevel.UNSUPPORTED;
            }
            DirContext context = null;
            try {
                context = this.contextFactory.obtainDirContext(null);
                Attributes attributes = context.getAttributes(this.distinguishedName, new String[]{OtpCredentialLoader.this.algorithmAttributeName, OtpCredentialLoader.this.hashAttributeName, OtpCredentialLoader.this.seedAttributeName, OtpCredentialLoader.this.sequenceAttributeName});
                Attribute algorithmAttribute = attributes.get(OtpCredentialLoader.this.algorithmAttributeName);
                Attribute hashAttribute = attributes.get(OtpCredentialLoader.this.hashAttributeName);
                Attribute seedAttribute = attributes.get(OtpCredentialLoader.this.seedAttributeName);
                Attribute sequenceAttribute = attributes.get(OtpCredentialLoader.this.sequenceAttributeName);
                if (algorithmAttribute != null && hashAttribute != null && seedAttribute != null && sequenceAttribute != null && (algorithmName == null || algorithmAttribute.contains(algorithmName))) {
                    SupportLevel supportLevel = SupportLevel.SUPPORTED;
                    return supportLevel;
                }
            }
            catch (NamingException namingException) {
            }
            finally {
                this.contextFactory.returnContext(context);
            }
            return SupportLevel.UNSUPPORTED;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <C extends Credential> C getCredential(Class<C> credentialType, String algorithmName) {
            if (credentialType != PasswordCredential.class) {
                return null;
            }
            DirContext context = null;
            try {
                context = this.contextFactory.obtainDirContext(null);
                Attributes attributes = context.getAttributes(this.distinguishedName, new String[]{OtpCredentialLoader.this.algorithmAttributeName, OtpCredentialLoader.this.hashAttributeName, OtpCredentialLoader.this.seedAttributeName, OtpCredentialLoader.this.sequenceAttributeName});
                Attribute algorithmAttribute = attributes.get(OtpCredentialLoader.this.algorithmAttributeName);
                Attribute hashAttribute = attributes.get(OtpCredentialLoader.this.hashAttributeName);
                Attribute seedAttribute = attributes.get(OtpCredentialLoader.this.seedAttributeName);
                Attribute sequenceAttribute = attributes.get(OtpCredentialLoader.this.sequenceAttributeName);
                if (algorithmAttribute == null || algorithmName != null && !algorithmAttribute.contains(algorithmName) || hashAttribute == null || seedAttribute == null || sequenceAttribute == null) {
                    C c = null;
                    return c;
                }
                PasswordFactory passwordFactory = PasswordFactory.getInstance((String)algorithmAttribute.get());
                Password password = passwordFactory.generatePassword(new OneTimePasswordSpec(CodePointIterator.ofString((String)hashAttribute.get()).base64Decode(Alphabet.Base64Alphabet.STANDARD, false).drain(), CodePointIterator.ofString((String)seedAttribute.get()).base64Decode(Alphabet.Base64Alphabet.STANDARD, false).drain(), Integer.parseInt((String)sequenceAttribute.get())));
                if (credentialType.isAssignableFrom(PasswordCredential.class)) {
                    Credential credential = (Credential)credentialType.cast(new PasswordCredential(password));
                    return (C)credential;
                }
            }
            catch (NoSuchAlgorithmException | InvalidKeySpecException | NamingException e) {
                if (ElytronMessages.log.isTraceEnabled()) {
                    ElytronMessages.log.trace("Getting OTP credential of type " + credentialType.getName() + " failed. dn=" + this.distinguishedName, e);
                }
            }
            finally {
                this.contextFactory.returnContext(context);
            }
            return null;
        }

        @Override
        public boolean getCredentialPersistSupport(Class<? extends Credential> credentialType, String algorithmName) {
            return OtpCredentialLoader.this.getCredentialAcquireSupport(this.contextFactory, credentialType, algorithmName).mayBeSupported();
        }

        @Override
        public void persistCredential(Credential credential) throws RealmUnavailableException {
            PasswordCredential passwordCredential = (PasswordCredential)credential;
            OneTimePassword password = (OneTimePassword)passwordCredential.getPassword();
            DirContext context = null;
            try {
                context = this.contextFactory.obtainDirContext(null);
                BasicAttributes attributes = new BasicAttributes();
                attributes.put(OtpCredentialLoader.this.algorithmAttributeName, password.getAlgorithm());
                attributes.put(OtpCredentialLoader.this.hashAttributeName, ByteIterator.ofBytes(password.getHash()).base64Encode().drainToString());
                attributes.put(OtpCredentialLoader.this.seedAttributeName, ByteIterator.ofBytes(password.getSeed()).base64Encode().drainToString());
                attributes.put(OtpCredentialLoader.this.sequenceAttributeName, Integer.toString(password.getSequenceNumber()));
                context.modifyAttributes(this.distinguishedName, 2, (Attributes)attributes);
            }
            catch (NamingException e) {
                throw ElytronMessages.log.ldapRealmCredentialPersistingFailed(credential.toString(), this.distinguishedName, e);
            }
            finally {
                this.contextFactory.returnContext(context);
            }
        }

        @Override
        public void clearCredentials() throws RealmUnavailableException {
            DirContext context = null;
            try {
                context = this.contextFactory.obtainDirContext(null);
                BasicAttributes attributes = new BasicAttributes();
                attributes.put(new BasicAttribute(OtpCredentialLoader.this.algorithmAttributeName));
                attributes.put(new BasicAttribute(OtpCredentialLoader.this.hashAttributeName));
                attributes.put(new BasicAttribute(OtpCredentialLoader.this.seedAttributeName));
                attributes.put(new BasicAttribute(OtpCredentialLoader.this.sequenceAttributeName));
                context.modifyAttributes(this.distinguishedName, 3, (Attributes)attributes);
            }
            catch (NoSuchAttributeException attributes) {
            }
            catch (NamingException e) {
                throw ElytronMessages.log.ldapRealmCredentialClearingFailed(this.distinguishedName, e);
            }
            finally {
                this.contextFactory.returnContext(context);
            }
        }
    }
}

