/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.client;

import java.io.IOException;
import java.security.Principal;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.wildfly.security.auth.client.AuthenticationConfiguration;
import org.wildfly.security.auth.client.SetCallbackHandlerAuthenticationConfiguration;
import org.wildfly.security.auth.client.SetNamePrincipalAuthenticationConfiguration;
import org.wildfly.security.auth.principal.AnonymousPrincipal;

class SetAnonymousAuthenticationConfiguration
extends AuthenticationConfiguration {
    SetAnonymousAuthenticationConfiguration(AuthenticationConfiguration parent) {
        super(parent.without(SetCallbackHandlerAuthenticationConfiguration.class).without(SetNamePrincipalAuthenticationConfiguration.class));
    }

    @Override
    boolean filterOneSaslMechanism(String mechanismName) {
        return "ANONYMOUS".equals(mechanismName) || super.filterOneSaslMechanism(mechanismName);
    }

    @Override
    void handleCallback(Callback[] callbacks, int index) throws UnsupportedCallbackException, IOException {
        Callback callback = callbacks[index];
        if (callback instanceof NameCallback) {
            ((NameCallback)callback).setName(this.getPrincipal().getName());
        } else {
            super.handleCallback(callbacks, index);
        }
    }

    @Override
    Principal getPrincipal() {
        return AnonymousPrincipal.getInstance();
    }

    @Override
    AuthenticationConfiguration reparent(AuthenticationConfiguration newParent) {
        return new SetAnonymousAuthenticationConfiguration(newParent);
    }
}

