/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.server;

import java.security.Permission;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.ObjIntConsumer;
import java.util.function.Supplier;
import org.wildfly.common.Assert;
import org.wildfly.common.function.ExceptionBiConsumer;
import org.wildfly.common.function.ExceptionBiFunction;
import org.wildfly.common.function.ExceptionConsumer;
import org.wildfly.common.function.ExceptionFunction;
import org.wildfly.common.function.ExceptionObjIntConsumer;
import org.wildfly.common.function.ExceptionSupplier;
import org.wildfly.security.ParametricPrivilegedAction;
import org.wildfly.security.ParametricPrivilegedExceptionAction;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.auth.permission.ChangeRoleMapperPermission;
import org.wildfly.security.auth.principal.AnonymousPrincipal;
import org.wildfly.security.auth.principal.NamePrincipal;
import org.wildfly.security.auth.server.IdentityCredentials;
import org.wildfly.security.auth.server.MechanismConfiguration;
import org.wildfly.security.auth.server.MechanismConfigurationSelector;
import org.wildfly.security.auth.server.RealmInfo;
import org.wildfly.security.auth.server.RealmUnavailableException;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.auth.server.ServerAuthenticationContext;
import org.wildfly.security.auth.server.event.SecurityPermissionCheckFailedEvent;
import org.wildfly.security.auth.server.event.SecurityPermissionCheckSuccessfulEvent;
import org.wildfly.security.authz.Attributes;
import org.wildfly.security.authz.AuthorizationIdentity;
import org.wildfly.security.authz.PermissionMappable;
import org.wildfly.security.authz.RoleMapper;
import org.wildfly.security.authz.Roles;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.permission.ElytronPermission;
import org.wildfly.security.permission.PermissionVerifier;

public final class SecurityIdentity
implements PermissionVerifier,
PermissionMappable {
    private static final Permission SET_RUN_AS_PERMISSION = ElytronPermission.forName("setRunAsPrincipal");
    private static final Permission PRIVATE_CREDENTIALS_PERMISSION = ElytronPermission.forName("getPrivateCredentials");
    private static final SecurityIdentity[] NO_IDENTITIES = new SecurityIdentity[0];
    private final SecurityDomain securityDomain;
    private final Principal principal;
    private final AuthorizationIdentity authorizationIdentity;
    private final RealmInfo realmInfo;
    private final Map<String, RoleMapper> roleMappers;
    private final Instant creationTime;
    private final PermissionVerifier verifier;
    private final IdentityCredentials publicCredentials;
    private final IdentityCredentials privateCredentials;
    private final Supplier<SecurityIdentity[]> withSuppliedIdentities;
    private final SecurityIdentity[] withIdentities;

    SecurityIdentity(SecurityDomain securityDomain, Principal principal, RealmInfo realmInfo, AuthorizationIdentity authorizationIdentity, Map<String, RoleMapper> roleMappers, IdentityCredentials publicCredentials, IdentityCredentials privateCredentials) {
        this.securityDomain = securityDomain;
        this.principal = principal;
        this.realmInfo = realmInfo;
        this.authorizationIdentity = authorizationIdentity;
        this.roleMappers = roleMappers;
        this.creationTime = Instant.now();
        this.verifier = securityDomain.mapPermissions(this);
        this.publicCredentials = publicCredentials;
        this.privateCredentials = privateCredentials;
        this.withSuppliedIdentities = null;
        this.withIdentities = null;
    }

    SecurityIdentity(SecurityIdentity old, Map<String, RoleMapper> roleMappers) {
        this.securityDomain = old.securityDomain;
        this.principal = old.principal;
        this.realmInfo = old.realmInfo;
        this.authorizationIdentity = old.authorizationIdentity;
        this.roleMappers = roleMappers;
        this.creationTime = old.creationTime;
        this.verifier = old.verifier;
        this.publicCredentials = old.publicCredentials;
        this.privateCredentials = old.privateCredentials;
        this.withSuppliedIdentities = old.withSuppliedIdentities;
        this.withIdentities = old.withIdentities;
    }

    SecurityIdentity(SecurityIdentity old, PermissionVerifier verifier) {
        this.securityDomain = old.securityDomain;
        this.principal = old.principal;
        this.realmInfo = old.realmInfo;
        this.authorizationIdentity = old.authorizationIdentity;
        this.roleMappers = old.roleMappers;
        this.creationTime = old.creationTime;
        this.verifier = verifier;
        this.publicCredentials = old.publicCredentials;
        this.privateCredentials = old.privateCredentials;
        this.withSuppliedIdentities = old.withSuppliedIdentities;
        this.withIdentities = old.withIdentities;
    }

    SecurityIdentity(SecurityIdentity old, Credential credential, boolean isPrivate) {
        this.securityDomain = old.securityDomain;
        this.principal = old.principal;
        this.realmInfo = old.realmInfo;
        this.authorizationIdentity = old.authorizationIdentity;
        this.roleMappers = old.roleMappers;
        this.creationTime = old.creationTime;
        this.verifier = old.verifier;
        this.publicCredentials = isPrivate ? old.publicCredentials : old.publicCredentials.withCredential(credential);
        this.privateCredentials = isPrivate ? old.privateCredentials.withCredential(credential) : old.privateCredentials;
        this.withSuppliedIdentities = old.withSuppliedIdentities;
        this.withIdentities = old.withIdentities;
    }

    SecurityIdentity(SecurityIdentity old, IdentityCredentials credentials, boolean isPrivate) {
        this.securityDomain = old.securityDomain;
        this.principal = old.principal;
        this.realmInfo = old.realmInfo;
        this.authorizationIdentity = old.authorizationIdentity;
        this.roleMappers = old.roleMappers;
        this.creationTime = old.creationTime;
        this.verifier = old.verifier;
        this.publicCredentials = isPrivate ? old.publicCredentials : old.publicCredentials.with(credentials);
        this.privateCredentials = isPrivate ? old.privateCredentials.with(credentials) : old.privateCredentials;
        this.withSuppliedIdentities = old.withSuppliedIdentities;
        this.withIdentities = old.withIdentities;
    }

    SecurityIdentity(SecurityIdentity old, Supplier<SecurityIdentity[]> withSuppliedIdentites) {
        this.securityDomain = old.securityDomain;
        this.principal = old.principal;
        this.realmInfo = old.realmInfo;
        this.authorizationIdentity = old.authorizationIdentity;
        this.roleMappers = old.roleMappers;
        this.creationTime = old.creationTime;
        this.verifier = old.verifier;
        this.publicCredentials = old.publicCredentials;
        this.privateCredentials = old.privateCredentials;
        this.withSuppliedIdentities = withSuppliedIdentites;
        this.withIdentities = null;
    }

    SecurityIdentity(SecurityIdentity old, SecurityIdentity[] withIdentities) {
        this.securityDomain = old.securityDomain;
        this.principal = old.principal;
        this.realmInfo = old.realmInfo;
        this.authorizationIdentity = old.authorizationIdentity;
        this.roleMappers = old.roleMappers;
        this.creationTime = old.creationTime;
        this.verifier = old.verifier;
        this.publicCredentials = old.publicCredentials;
        this.privateCredentials = old.privateCredentials;
        this.withSuppliedIdentities = null;
        this.withIdentities = withIdentities;
    }

    SecurityDomain getSecurityDomain() {
        return this.securityDomain;
    }

    RealmInfo getRealmInfo() {
        return this.realmInfo;
    }

    AuthorizationIdentity getAuthorizationIdentity() {
        return this.authorizationIdentity;
    }

    private SecurityIdentity[] establishIdentities() {
        SecurityIdentity[] withIdentities;
        SecurityIdentity[] securityIdentityArray = this.withIdentities != null ? this.withIdentities : (withIdentities = this.withSuppliedIdentities != null ? this.withSuppliedIdentities.get() : NO_IDENTITIES);
        if (withIdentities.length == 0) {
            return NO_IDENTITIES;
        }
        SecurityIdentity[] oldIdentities = new SecurityIdentity[withIdentities.length];
        for (int i = 0; i < withIdentities.length; ++i) {
            SecurityIdentity securityIdentity = withIdentities[i];
            oldIdentities[i] = securityIdentity.getSecurityDomain().getAndSetCurrentSecurityIdentity(securityIdentity);
        }
        return oldIdentities;
    }

    private void restoreIdentities(SecurityIdentity[] securityIdentities) {
        for (SecurityIdentity currentIdentity : securityIdentities) {
            currentIdentity.securityDomain.setCurrentSecurityIdentity(currentIdentity);
        }
    }

    public void runAs(Runnable action) {
        if (action == null) {
            return;
        }
        this.runAsConsumer(Runnable::run, action);
    }

    public <T> T runAs(Callable<T> action) throws Exception {
        if (action == null) {
            return null;
        }
        return (T)this.runAsFunctionEx(Callable::call, action);
    }

    public <T> T runAs(PrivilegedAction<T> action) {
        if (action == null) {
            return null;
        }
        return (T)this.runAs(action, PrivilegedAction::run);
    }

    public <T> T runAs(PrivilegedExceptionAction<T> action) throws PrivilegedActionException {
        if (action == null) {
            return null;
        }
        return (T)this.runAs(action, PrivilegedExceptionAction::run);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T, P> T runAs(P parameter, ParametricPrivilegedAction<T, P> action) {
        if (action == null) {
            return null;
        }
        SecurityIdentity[] oldWithIdentities = this.establishIdentities();
        SecurityIdentity oldIdentity = this.securityDomain.getAndSetCurrentSecurityIdentity(this);
        try {
            T t = action.run(parameter);
            return t;
        }
        finally {
            this.securityDomain.setCurrentSecurityIdentity(oldIdentity);
            this.restoreIdentities(oldWithIdentities);
        }
    }

    public <T, P> T runAs(P parameter, ParametricPrivilegedExceptionAction<T, P> action) throws PrivilegedActionException {
        if (action == null) {
            return null;
        }
        SecurityIdentity[] oldWithIdentities = this.establishIdentities();
        SecurityIdentity oldIdentity = this.securityDomain.getAndSetCurrentSecurityIdentity(this);
        try {
            T t = action.run(parameter);
            return t;
        }
        catch (RuntimeException | PrivilegedActionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PrivilegedActionException(e);
        }
        finally {
            this.securityDomain.setCurrentSecurityIdentity(oldIdentity);
            this.restoreIdentities(oldWithIdentities);
        }
    }

    public <T, R> R runAsFunction(Function<T, R> action, T parameter) {
        if (action == null) {
            return null;
        }
        return (R)this.runAsFunction(Function::apply, action, parameter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T, U, R> R runAsFunction(BiFunction<T, U, R> action, T parameter1, U parameter2) {
        if (action == null) {
            return null;
        }
        SecurityIdentity[] oldWithIdentities = this.establishIdentities();
        SecurityIdentity oldIdentity = this.securityDomain.getAndSetCurrentSecurityIdentity(this);
        try {
            R r = action.apply(parameter1, parameter2);
            return r;
        }
        finally {
            this.securityDomain.setCurrentSecurityIdentity(oldIdentity);
            this.restoreIdentities(oldWithIdentities);
        }
    }

    public <T> void runAsConsumer(Consumer<T> action, T parameter) {
        if (action == null) {
            return;
        }
        this.runAsConsumer(Consumer::accept, action, parameter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T, U> void runAsConsumer(BiConsumer<T, U> action, T parameter1, U parameter2) {
        if (action == null) {
            return;
        }
        SecurityIdentity[] oldWithIdentities = this.establishIdentities();
        SecurityIdentity oldIdentity = this.securityDomain.getAndSetCurrentSecurityIdentity(this);
        try {
            action.accept(parameter1, parameter2);
        }
        finally {
            this.securityDomain.setCurrentSecurityIdentity(oldIdentity);
            this.restoreIdentities(oldWithIdentities);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void runAsObjIntConsumer(ObjIntConsumer<T> action, T parameter1, int parameter2) {
        if (action == null) {
            return;
        }
        SecurityIdentity[] oldWithIdentities = this.establishIdentities();
        SecurityIdentity oldIdentity = this.securityDomain.getAndSetCurrentSecurityIdentity(this);
        try {
            action.accept(parameter1, parameter2);
        }
        finally {
            this.securityDomain.setCurrentSecurityIdentity(oldIdentity);
            this.restoreIdentities(oldWithIdentities);
        }
    }

    public <T> T runAsSupplier(Supplier<T> action) {
        if (action == null) {
            return null;
        }
        return (T)this.runAsFunction(Supplier::get, action);
    }

    public <T, R, E extends Exception> R runAsFunctionEx(ExceptionFunction<T, R, E> action, T parameter) throws E {
        if (action == null) {
            return null;
        }
        return this.runAsFunctionEx(ExceptionFunction::apply, action, parameter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T, U, R, E extends Exception> R runAsFunctionEx(ExceptionBiFunction<T, U, R, E> action, T parameter1, U parameter2) throws E {
        if (action == null) {
            return null;
        }
        SecurityIdentity[] oldWithIdentities = this.establishIdentities();
        SecurityIdentity oldIdentity = this.securityDomain.getAndSetCurrentSecurityIdentity(this);
        try {
            Object object = action.apply(parameter1, parameter2);
            return (R)object;
        }
        finally {
            this.securityDomain.setCurrentSecurityIdentity(oldIdentity);
            this.restoreIdentities(oldWithIdentities);
        }
    }

    public <T, E extends Exception> void runAsConsumerEx(ExceptionConsumer<T, E> action, T parameter) throws E {
        if (action == null) {
            return;
        }
        this.runAsConsumerEx(ExceptionConsumer::accept, action, parameter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T, U, E extends Exception> void runAsConsumerEx(ExceptionBiConsumer<T, U, E> action, T parameter1, U parameter2) throws E {
        if (action == null) {
            return;
        }
        SecurityIdentity[] oldWithIdentities = this.establishIdentities();
        SecurityIdentity oldIdentity = this.securityDomain.getAndSetCurrentSecurityIdentity(this);
        try {
            action.accept(parameter1, parameter2);
        }
        finally {
            this.securityDomain.setCurrentSecurityIdentity(oldIdentity);
            this.restoreIdentities(oldWithIdentities);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T, E extends Exception> void runAsObjIntConsumerEx(ExceptionObjIntConsumer<T, E> action, T parameter1, int parameter2) throws E {
        if (action == null) {
            return;
        }
        SecurityIdentity[] oldWithIdentities = this.establishIdentities();
        SecurityIdentity oldIdentity = this.securityDomain.getAndSetCurrentSecurityIdentity(this);
        try {
            action.accept(parameter1, parameter2);
        }
        finally {
            this.securityDomain.setCurrentSecurityIdentity(oldIdentity);
            this.restoreIdentities(oldWithIdentities);
        }
    }

    public <T, E extends Exception> T runAsSupplierEx(ExceptionSupplier<T, E> action) throws E {
        if (action == null) {
            return null;
        }
        return (T)this.runAsFunctionEx(ExceptionSupplier::get, action);
    }

    public static <T> T runAsAll(PrivilegedExceptionAction<T> action, SecurityIdentity ... identities) throws PrivilegedActionException {
        if (action == null) {
            return null;
        }
        int length = identities.length;
        SecurityIdentity[] oldIdentities = new SecurityIdentity[length];
        for (int i = 0; i < length; ++i) {
            SecurityIdentity securityIdentity = identities[i];
            SecurityDomain securityDomain = securityIdentity.getSecurityDomain();
            oldIdentities[i] = securityDomain.getAndSetCurrentSecurityIdentity(securityIdentity);
        }
        try {
            T i = action.run();
            return i;
        }
        catch (RuntimeException | PrivilegedActionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PrivilegedActionException(e);
        }
        finally {
            for (int i = 0; i < length; ++i) {
                SecurityIdentity oldIdentity = oldIdentities[i];
                SecurityDomain securityDomain = oldIdentity.getSecurityDomain();
                securityDomain.setCurrentSecurityIdentity(oldIdentity);
            }
        }
    }

    public Roles getRoles() {
        return this.securityDomain.mapRoles(this);
    }

    public Roles getRoles(String category) {
        return this.getRoles(category, false);
    }

    public SecurityIdentity withSecurityIdentitySupplier(Supplier<SecurityIdentity[]> securityIdentities) {
        Assert.checkNotNullParam((String)"securityIdentities", securityIdentities);
        if (this.withSuppliedIdentities == securityIdentities) {
            return this;
        }
        return new SecurityIdentity(this, securityIdentities);
    }

    public SecurityIdentity withSecurityIdentity(SecurityIdentity securityIdentity) {
        Assert.checkNotNullParam((String)"securityIdentity", (Object)securityIdentity);
        if (securityIdentity == this) {
            return this;
        }
        if (this.securityDomain == securityIdentity.securityDomain) {
            throw ElytronMessages.log.cantWithSameSecurityDomainDomain();
        }
        ArrayList<SecurityIdentity> withIdentities = new ArrayList<SecurityIdentity>(this.withIdentities.length + 1);
        for (SecurityIdentity currentIdentity : this.withIdentities) {
            if (currentIdentity == securityIdentity) {
                return this;
            }
            if (currentIdentity.securityDomain != securityIdentity.securityDomain) {
                withIdentities.add(currentIdentity);
            }
            withIdentities.add(securityIdentity);
        }
        return new SecurityIdentity(this, withIdentities.toArray(new SecurityIdentity[withIdentities.size()]));
    }

    public Roles getRoles(String category, boolean fallbackToDefault) {
        RoleMapper roleMapper = this.roleMappers.get(category);
        return roleMapper == null ? (fallbackToDefault ? this.getRoles() : Roles.NONE) : roleMapper.mapRoles(this.securityDomain.mapRoles(this));
    }

    public SecurityIdentity withRoleMapper(String category, RoleMapper roleMapper) {
        Map<String, RoleMapper> newMap;
        Assert.checkNotNullParam((String)"category", (Object)category);
        Assert.checkNotNullParam((String)"roleMapper", (Object)roleMapper);
        Map<String, RoleMapper> roleMappers = this.roleMappers;
        RoleMapper existingRoleMapper = roleMappers.get(category);
        if (existingRoleMapper == roleMapper) {
            return this;
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new ChangeRoleMapperPermission(category));
        }
        if (roleMappers.isEmpty() || roleMappers.size() == 1 && roleMappers.keySet().iterator().next().equals(category)) {
            newMap = Collections.singletonMap(category, roleMapper);
        } else {
            newMap = new HashMap<String, RoleMapper>(roleMappers);
            newMap.put(category, roleMapper);
        }
        return new SecurityIdentity(this, newMap);
    }

    public SecurityIdentity createRunAsIdentity(String name) throws SecurityException {
        return this.createRunAsIdentity(name, true);
    }

    public SecurityIdentity createRunAsIdentity(String name, boolean authorize) throws SecurityException {
        Assert.checkNotNullParam((String)"name", (Object)name);
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(SET_RUN_AS_PERMISSION);
        }
        ServerAuthenticationContext context = this.securityDomain.createNewAuthenticationContext(this, MechanismConfigurationSelector.constantSelector(MechanismConfiguration.EMPTY));
        try {
            if (!context.importIdentity(this) || !context.authorize(name, authorize)) {
                throw ElytronMessages.log.runAsAuthorizationFailed(this.principal, new NamePrincipal(name), null);
            }
        }
        catch (RealmUnavailableException e) {
            throw ElytronMessages.log.runAsAuthorizationFailed(this.principal, context.getAuthenticationPrincipal(), e);
        }
        return context.getAuthorizedIdentity();
    }

    public SecurityIdentity createRunAsAnonymous() throws SecurityException {
        return this.createRunAsAnonymous(true);
    }

    public SecurityIdentity createRunAsAnonymous(boolean authorize) throws SecurityException {
        ServerAuthenticationContext context;
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(SET_RUN_AS_PERMISSION);
        }
        if (!(context = this.securityDomain.createNewAuthenticationContext(this, MechanismConfigurationSelector.constantSelector(MechanismConfiguration.EMPTY))).authorizeAnonymous(authorize)) {
            throw ElytronMessages.log.runAsAuthorizationFailed(this.principal, AnonymousPrincipal.getInstance(), null);
        }
        return context.getAuthorizedIdentity();
    }

    public SecurityIdentity intersectWith(PermissionVerifier verifier) {
        Assert.checkNotNullParam((String)"verifier", (Object)verifier);
        return new SecurityIdentity(this, this.verifier.and(verifier));
    }

    @Override
    public boolean implies(Permission permission) {
        boolean result = this.verifier.implies(permission);
        SecurityDomain.safeHandleSecurityEvent(this.securityDomain, result ? new SecurityPermissionCheckSuccessfulEvent(this, permission) : new SecurityPermissionCheckFailedEvent(this, permission));
        return result;
    }

    @Override
    public Attributes getAttributes() {
        return this.authorizationIdentity.getAttributes().asReadOnly();
    }

    @Override
    public Principal getPrincipal() {
        return this.principal;
    }

    @Override
    public Instant getCreationTime() {
        return this.creationTime;
    }

    @Override
    public IdentityCredentials getPublicCredentials() {
        return this.publicCredentials;
    }

    public boolean isAnonymous() {
        return this.principal instanceof AnonymousPrincipal;
    }

    public SecurityIdentity withPublicCredential(Credential credential) {
        Assert.checkNotNullParam((String)"credential", (Object)credential);
        return new SecurityIdentity(this, credential, false);
    }

    public SecurityIdentity withPublicCredentials(IdentityCredentials credentials) {
        Assert.checkNotNullParam((String)"credentials", (Object)credentials);
        return credentials == IdentityCredentials.NONE ? this : new SecurityIdentity(this, credentials, false);
    }

    public SecurityIdentity withPrivateCredential(Credential credential) {
        Assert.checkNotNullParam((String)"credential", (Object)credential);
        return new SecurityIdentity(this, credential, true);
    }

    public SecurityIdentity withPrivateCredentials(IdentityCredentials credentials) {
        Assert.checkNotNullParam((String)"credentials", (Object)credentials);
        return credentials == IdentityCredentials.NONE ? this : new SecurityIdentity(this, credentials, true);
    }

    public IdentityCredentials getPrivateCredentials() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(PRIVATE_CREDENTIALS_PERMISSION);
        }
        return this.getPrivateCredentialsPrivate();
    }

    IdentityCredentials getPrivateCredentialsPrivate() {
        return this.privateCredentials;
    }
}

