/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.audit;

import java.io.IOException;
import java.net.InetAddress;
import java.util.logging.Level;
import org.jboss.logmanager.ExtLogRecord;
import org.jboss.logmanager.handlers.SyslogHandler;
import org.wildfly.common.Assert;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.audit.AuditEndpoint;
import org.wildfly.security.audit.EventPriority;

public class SyslogAuditEndpoint
implements AuditEndpoint {
    private volatile boolean accepting = true;
    private final SyslogHandler syslogHandler;

    SyslogAuditEndpoint(Builder builder) throws IOException {
        this.syslogHandler = new SyslogHandler((InetAddress)Assert.checkNotNullParam((String)"serverAddress", (Object)builder.serverAddress), builder.port, SyslogHandler.Facility.SECURITY, null, builder.tcp ? SyslogHandler.Protocol.TCP : SyslogHandler.Protocol.UDP, (String)Assert.checkNotNullParam((String)"hostName", (Object)builder.hostName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void accept(EventPriority t, String u) throws IOException {
        if (!this.accepting) {
            return;
        }
        SyslogAuditEndpoint syslogAuditEndpoint = this;
        synchronized (syslogAuditEndpoint) {
            if (!this.accepting) {
                return;
            }
            this.syslogHandler.doPublish(new ExtLogRecord(SyslogAuditEndpoint.toLevel(t), u, SyslogAuditEndpoint.class.getName()));
        }
    }

    private static Level toLevel(EventPriority eventPriority) {
        switch (eventPriority) {
            case ALERT: 
            case EMERGENCY: 
            case CRITICAL: 
            case ERROR: {
                return Level.SEVERE;
            }
            case WARNING: {
                return Level.WARNING;
            }
            case INFORMATIONAL: {
                return Level.INFO;
            }
            case OFF: {
                throw ElytronMessages.audit.invalidEventPriority(eventPriority);
            }
        }
        return Level.FINEST;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        this.accepting = false;
        SyslogAuditEndpoint syslogAuditEndpoint = this;
        synchronized (syslogAuditEndpoint) {
            this.syslogHandler.close();
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private InetAddress serverAddress;
        private int port;
        private boolean tcp = true;
        private String hostName;

        Builder() {
        }

        public Builder setServerAddress(InetAddress serverAddress) {
            this.serverAddress = (InetAddress)Assert.checkNotNullParam((String)"serverAddress", (Object)serverAddress);
            return this;
        }

        public Builder setPort(int port) {
            this.port = port;
            return this;
        }

        public Builder setTcp(boolean tcp) {
            this.tcp = tcp;
            return this;
        }

        public Builder setHostName(String hostName) {
            this.hostName = (String)Assert.checkNotNullParam((String)"hostName", (Object)hostName);
            return this;
        }

        public AuditEndpoint build() throws IOException {
            return new SyslogAuditEndpoint(this);
        }
    }
}

