/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.wildfly.common.Assert;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.auth.server.RealmMapper;

public class SimpleRegexRealmMapper
implements RealmMapper {
    private final Pattern realmNamePattern;
    private final RealmMapper delegate;

    public SimpleRegexRealmMapper(Pattern realmNamePattern) {
        this(realmNamePattern, DEFAULT_REALM_MAPPER);
    }

    public SimpleRegexRealmMapper(Pattern realmNamePattern, RealmMapper delegate) {
        Assert.checkNotNullParam((String)"realmNamePattern", (Object)realmNamePattern);
        Assert.checkNotNullParam((String)"delegate", (Object)delegate);
        int groupCount = realmNamePattern.matcher("").groupCount();
        if (groupCount < 1) {
            throw ElytronMessages.log.patternRequiresCaptureGroup();
        }
        this.realmNamePattern = realmNamePattern;
        this.delegate = delegate;
    }

    @Override
    public String getRealmMapping(String userName) {
        Matcher matcher = this.realmNamePattern.matcher(userName);
        assert (matcher.groupCount() >= 1);
        return matcher.matches() ? matcher.group(1) : this.delegate.getRealmMapping(userName);
    }
}

