/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.sasl.util;

import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import javax.security.sasl.SaslServerFactory;
import org.wildfly.security.auth.callback.ChannelBindingCallback;
import org.wildfly.security.auth.callback.SSLCallback;
import org.wildfly.security.sasl.util.AbstractDelegatingSaslServerFactory;
import org.wildfly.security.sasl.util.TLSServerEndPointChannelBinding;

public final class TLSServerEndPointChannelBindingSaslServerFactory
extends AbstractDelegatingSaslServerFactory {
    public TLSServerEndPointChannelBindingSaslServerFactory(SaslServerFactory delegate) {
        super(delegate);
    }

    @Override
    public SaslServer createSaslServer(String mechanism, String protocol, String serverName, Map<String, ?> props, final CallbackHandler cbh) throws SaslException {
        return super.createSaslServer(mechanism, protocol, serverName, props, new CallbackHandler(){
            private byte[] bindingData;

            @Override
            public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                ArrayList<Callback> list = new ArrayList<Callback>(Arrays.asList(callbacks));
                Iterator<Callback> iterator = list.iterator();
                while (iterator.hasNext()) {
                    Callback callback = iterator.next();
                    if (callback instanceof SSLCallback) {
                        X509Certificate localCertificate;
                        String sigAlgOID;
                        String digestAlgorithm;
                        SSLCallback sslCallback = (SSLCallback)callback;
                        Certificate[] localCertificates = sslCallback.getSslSession().getLocalCertificates();
                        if (localCertificates == null || localCertificates.length <= 0 || (digestAlgorithm = TLSServerEndPointChannelBinding.getDigestAlgorithm(sigAlgOID = (localCertificate = (X509Certificate)localCertificates[0]).getSigAlgOID())) == null) continue;
                        try {
                            MessageDigest messageDigest = MessageDigest.getInstance(digestAlgorithm);
                            byte[] encoded = localCertificate.getEncoded();
                            this.bindingData = messageDigest.digest(encoded);
                        }
                        catch (NoSuchAlgorithmException | CertificateEncodingException generalSecurityException) {}
                        continue;
                    }
                    if (!(callback instanceof ChannelBindingCallback) || this.bindingData == null) continue;
                    ChannelBindingCallback bindingCallback = (ChannelBindingCallback)callback;
                    bindingCallback.setBindingType("tls-server-end-point");
                    bindingCallback.setBindingData(this.bindingData);
                    iterator.remove();
                }
                if (!list.isEmpty()) {
                    cbh.handle(list.toArray(new Callback[list.size()]));
                }
            }
        });
    }
}

