/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.password;

import java.security.Key;
import java.util.function.Function;

public interface Password
extends Key,
Cloneable {
    default public <P extends Password> P castAs(Class<P> passwordType, String algorithmName) {
        return (P)((Password)this.castAndApply(passwordType, algorithmName, Function.identity()));
    }

    default public <P extends Password> P castAs(Class<P> passwordType) {
        return (P)((Password)this.castAndApply(passwordType, Function.identity()));
    }

    default public <P extends Password, R> R castAndApply(Class<P> passwordType, String algorithmName, Function<P, R> function) {
        return passwordType.isInstance(this) && (algorithmName == null || algorithmName.equals(this.getAlgorithm())) ? (R)function.apply(passwordType.cast(this)) : null;
    }

    default public <P extends Password, R> R castAndApply(Class<P> passwordType, Function<P, R> function) {
        return passwordType.isInstance(this) ? (R)function.apply(passwordType.cast(this)) : null;
    }

    public Password clone();
}

