/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.ssl;

import java.net.Socket;
import java.security.Principal;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.List;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.X509ExtendedTrustManager;
import javax.net.ssl.X509TrustManager;
import org.wildfly.common.Assert;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.auth.server.AuthenticationInformation;
import org.wildfly.security.auth.server.CredentialDecoder;
import org.wildfly.security.auth.server.CredentialSupport;
import org.wildfly.security.auth.server.RealmUnavailableException;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.auth.server.ServerAuthenticationContext;
import org.wildfly.security.ssl.WrappingX509ExtendedTrustManager;

class SecurityDomainTrustManager
extends X509ExtendedTrustManager {
    private final X509ExtendedTrustManager delegate;
    private final SecurityDomain securityDomain;
    private final CredentialDecoder credentialDecoder;

    SecurityDomainTrustManager(X509ExtendedTrustManager delegate, SecurityDomain securityDomain, CredentialDecoder credentialDecoder) {
        this.delegate = delegate;
        this.securityDomain = securityDomain;
        this.credentialDecoder = credentialDecoder;
    }

    SecurityDomainTrustManager(X509TrustManager delegate, SecurityDomain securityDomain, CredentialDecoder credentialDecoder) {
        this(delegate instanceof X509ExtendedTrustManager ? (X509ExtendedTrustManager)delegate : new WrappingX509ExtendedTrustManager(delegate), securityDomain, credentialDecoder);
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
        this.delegate.checkClientTrusted(chain, authType, socket);
        this.doClientTrustCheck(chain, authType, ((SSLSocket)socket).getHandshakeSession());
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType, SSLEngine sslEngine) throws CertificateException {
        this.delegate.checkClientTrusted(chain, authType, sslEngine);
        this.doClientTrustCheck(chain, authType, sslEngine.getHandshakeSession());
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this.delegate.checkClientTrusted(chain, authType);
        this.doClientTrustCheck(chain, authType, null);
    }

    private void doClientTrustCheck(X509Certificate[] chain, String authType, SSLSession handshakeSession) throws CertificateException {
        Assert.checkNotNullParam((String)"chain", (Object)chain);
        Assert.checkNotNullParam((String)"authType", (Object)authType);
        if (chain.length == 0) {
            throw ElytronMessages.log.emptyChainNotTrusted();
        }
        X509Certificate subjectCertificate = chain[0];
        Principal principal = this.credentialDecoder.getPrincipalFromCredential(subjectCertificate);
        ServerAuthenticationContext authenticationContext = this.securityDomain.createNewAuthenticationContext();
        boolean ok = false;
        try {
            try {
                authenticationContext.setAuthenticationPrincipal(principal);
                AuthenticationInformation.Builder builder = new AuthenticationInformation.Builder();
                builder.setMechanismType("SSL");
                List<String> credentialNames = this.securityDomain.mapCredentials(builder.build());
                for (String credentialName : credentialNames) {
                    CredentialSupport credentialSupport = authenticationContext.getCredentialSupport(credentialName);
                    if (!credentialSupport.mayBeVerifiable() || !authenticationContext.verifyCredential(credentialName, subjectCertificate)) continue;
                    authenticationContext.succeed();
                    if (handshakeSession != null) {
                        handshakeSession.putValue("org.wildfly.security.ssl.identity", authenticationContext.getAuthorizedIdentity());
                    }
                    ok = true;
                }
                throw ElytronMessages.log.notTrusted(principal);
            }
            catch (RealmUnavailableException e) {
                throw ElytronMessages.log.notTrustedRealmProblem(e, principal);
            }
        }
        catch (Throwable throwable) {
            if (!ok) {
                authenticationContext.fail();
            }
            throw throwable;
        }
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
        this.delegate.checkServerTrusted(chain, authType, socket);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType, SSLEngine sslEngine) throws CertificateException {
        this.delegate.checkServerTrusted(chain, authType, sslEngine);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this.delegate.checkServerTrusted(chain, authType);
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return this.delegate.getAcceptedIssuers();
    }
}

