/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.ssl;

import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.SNIServerName;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSession;
import org.wildfly.common.Assert;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.ssl.SNIServerSSLContextSelector;
import org.wildfly.security.ssl.SSLCapabilities;
import org.wildfly.security.ssl.SSLExplorer;

class SNIServerSSLEngine
extends SSLEngine {
    private final AtomicReference<SSLEngine> currentRef;
    static final int FL_WANT_C_AUTH = 1;
    static final int FL_NEED_C_AUTH = 2;
    static final int FL_SESSION_CRE = 4;
    static final SSLEngine CLOSED_STATE = new SSLEngine(){

        @Override
        public SSLEngineResult wrap(ByteBuffer[] srcs, int offset, int length, ByteBuffer dst) throws SSLException {
            throw ElytronMessages.log.sslClosed();
        }

        @Override
        public SSLEngineResult unwrap(ByteBuffer src, ByteBuffer[] dsts, int offset, int length) throws SSLException {
            throw ElytronMessages.log.sslClosed();
        }

        @Override
        public Runnable getDelegatedTask() {
            return null;
        }

        @Override
        public void closeInbound() throws SSLException {
        }

        @Override
        public boolean isInboundDone() {
            return true;
        }

        @Override
        public void closeOutbound() {
        }

        @Override
        public boolean isOutboundDone() {
            return true;
        }

        @Override
        public String[] getSupportedCipherSuites() {
            throw Assert.unsupported();
        }

        @Override
        public String[] getEnabledCipherSuites() {
            throw Assert.unsupported();
        }

        @Override
        public void setEnabledCipherSuites(String[] suites) {
            throw Assert.unsupported();
        }

        @Override
        public String[] getSupportedProtocols() {
            throw Assert.unsupported();
        }

        @Override
        public String[] getEnabledProtocols() {
            throw Assert.unsupported();
        }

        @Override
        public void setEnabledProtocols(String[] protocols) {
            throw Assert.unsupported();
        }

        @Override
        public SSLSession getSession() {
            return null;
        }

        @Override
        public void beginHandshake() throws SSLException {
            throw ElytronMessages.log.sslClosed();
        }

        @Override
        public SSLEngineResult.HandshakeStatus getHandshakeStatus() {
            return SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING;
        }

        @Override
        public void setUseClientMode(boolean mode) {
            throw Assert.unsupported();
        }

        @Override
        public boolean getUseClientMode() {
            return false;
        }

        @Override
        public void setNeedClientAuth(boolean need) {
        }

        @Override
        public boolean getNeedClientAuth() {
            return false;
        }

        @Override
        public void setWantClientAuth(boolean want) {
        }

        @Override
        public boolean getWantClientAuth() {
            return false;
        }

        @Override
        public void setEnableSessionCreation(boolean flag) {
        }

        @Override
        public boolean getEnableSessionCreation() {
            return false;
        }
    };

    SNIServerSSLEngine(SNIServerSSLContextSelector selector) {
        this.currentRef = new AtomicReference<InitialState>(new InitialState(selector));
    }

    @Override
    public SSLEngineResult wrap(ByteBuffer[] srcs, int offset, int length, ByteBuffer dst) throws SSLException {
        return this.currentRef.get().wrap(srcs, offset, length, dst);
    }

    @Override
    public SSLEngineResult wrap(ByteBuffer src, ByteBuffer dst) throws SSLException {
        return this.currentRef.get().wrap(src, dst);
    }

    @Override
    public SSLEngineResult wrap(ByteBuffer[] srcs, ByteBuffer dst) throws SSLException {
        return this.currentRef.get().wrap(srcs, dst);
    }

    @Override
    public SSLEngineResult unwrap(ByteBuffer src, ByteBuffer[] dsts, int offset, int length) throws SSLException {
        return this.currentRef.get().unwrap(src, dsts, offset, length);
    }

    @Override
    public SSLEngineResult unwrap(ByteBuffer src, ByteBuffer dst) throws SSLException {
        return this.currentRef.get().unwrap(src, dst);
    }

    @Override
    public SSLEngineResult unwrap(ByteBuffer src, ByteBuffer[] dsts) throws SSLException {
        return this.currentRef.get().unwrap(src, dsts);
    }

    @Override
    public String getPeerHost() {
        return this.currentRef.get().getPeerHost();
    }

    @Override
    public int getPeerPort() {
        return this.currentRef.get().getPeerPort();
    }

    @Override
    public SSLSession getHandshakeSession() {
        return this.currentRef.get().getHandshakeSession();
    }

    @Override
    public SSLParameters getSSLParameters() {
        return this.currentRef.get().getSSLParameters();
    }

    @Override
    public void setSSLParameters(SSLParameters params) {
        this.currentRef.get().setSSLParameters(params);
    }

    @Override
    public Runnable getDelegatedTask() {
        return this.currentRef.get().getDelegatedTask();
    }

    @Override
    public void closeInbound() throws SSLException {
        this.currentRef.get().closeInbound();
    }

    @Override
    public boolean isInboundDone() {
        return this.currentRef.get().isInboundDone();
    }

    @Override
    public void closeOutbound() {
        this.currentRef.get().closeOutbound();
    }

    @Override
    public boolean isOutboundDone() {
        return this.currentRef.get().isOutboundDone();
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return this.currentRef.get().getSupportedCipherSuites();
    }

    @Override
    public String[] getEnabledCipherSuites() {
        return this.currentRef.get().getEnabledCipherSuites();
    }

    @Override
    public void setEnabledCipherSuites(String[] cipherSuites) {
        this.currentRef.get().setEnabledCipherSuites(cipherSuites);
    }

    @Override
    public String[] getSupportedProtocols() {
        return this.currentRef.get().getSupportedProtocols();
    }

    @Override
    public String[] getEnabledProtocols() {
        return this.currentRef.get().getEnabledProtocols();
    }

    @Override
    public void setEnabledProtocols(String[] protocols) {
        this.currentRef.get().setEnabledProtocols(protocols);
    }

    @Override
    public SSLSession getSession() {
        return this.currentRef.get().getSession();
    }

    @Override
    public void beginHandshake() throws SSLException {
        this.currentRef.get().beginHandshake();
    }

    @Override
    public SSLEngineResult.HandshakeStatus getHandshakeStatus() {
        return this.currentRef.get().getHandshakeStatus();
    }

    @Override
    public void setUseClientMode(boolean clientMode) {
        this.currentRef.get().setUseClientMode(clientMode);
    }

    @Override
    public boolean getUseClientMode() {
        return this.currentRef.get().getUseClientMode();
    }

    @Override
    public void setNeedClientAuth(boolean clientAuth) {
        this.currentRef.get().setNeedClientAuth(clientAuth);
    }

    @Override
    public boolean getNeedClientAuth() {
        return this.currentRef.get().getNeedClientAuth();
    }

    @Override
    public void setWantClientAuth(boolean want) {
        this.currentRef.get().setWantClientAuth(want);
    }

    @Override
    public boolean getWantClientAuth() {
        return this.currentRef.get().getWantClientAuth();
    }

    @Override
    public void setEnableSessionCreation(boolean flag) {
        this.currentRef.get().setEnableSessionCreation(flag);
    }

    @Override
    public boolean getEnableSessionCreation() {
        return this.currentRef.get().getEnableSessionCreation();
    }

    class InitialState
    extends SSLEngine {
        private final SNIServerSSLContextSelector selector;
        private final AtomicInteger flags = new AtomicInteger(4);

        InitialState(SNIServerSSLContextSelector selector) {
            this.selector = selector;
        }

        @Override
        public String getPeerHost() {
            return super.getPeerHost();
        }

        @Override
        public int getPeerPort() {
            return super.getPeerPort();
        }

        @Override
        public SSLSession getHandshakeSession() {
            return null;
        }

        @Override
        public SSLEngineResult wrap(ByteBuffer[] srcs, int offset, int length, ByteBuffer dst) throws SSLException {
            return new SSLEngineResult(SSLEngineResult.Status.OK, SSLEngineResult.HandshakeStatus.NEED_UNWRAP, 0, 0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SSLEngineResult unwrap(ByteBuffer src, ByteBuffer[] dsts, int offset, int length) throws SSLException {
            SSLEngine next;
            int mark = src.position();
            try {
                SSLContext sslContext;
                if (src.remaining() < 5) {
                    SSLEngineResult sSLEngineResult = new SSLEngineResult(SSLEngineResult.Status.BUFFER_UNDERFLOW, SSLEngineResult.HandshakeStatus.NEED_UNWRAP, 0, 0);
                    return sSLEngineResult;
                }
                int requiredSize = SSLExplorer.getRequiredSize(src);
                if (src.remaining() < requiredSize) {
                    SSLEngineResult sSLEngineResult = new SSLEngineResult(SSLEngineResult.Status.BUFFER_UNDERFLOW, SSLEngineResult.HandshakeStatus.NEED_UNWRAP, 0, 0);
                    return sSLEngineResult;
                }
                SSLCapabilities capabilities = SSLExplorer.explore(src);
                List<SNIServerName> serverNames = capabilities.getServerNames();
                Iterator<SNIServerName> iterator = serverNames.iterator();
                if (!iterator.hasNext()) {
                    sslContext = this.selector.selectContext(null);
                } else {
                    SNIServerName serverName;
                    while ((sslContext = this.selector.selectContext(serverName = iterator.next())) == null && iterator.hasNext()) {
                    }
                }
                if (sslContext == null) {
                    throw ElytronMessages.log.noHostForSslConnection();
                }
                next = sslContext.createSSLEngine();
                next.setUseClientMode(false);
                int flagsVal = this.flags.get();
                if ((flagsVal & 1) != 0) {
                    next.setWantClientAuth(true);
                } else if ((flagsVal & 2) != 0) {
                    next.setNeedClientAuth(true);
                }
                if ((flagsVal & 4) != 0) {
                    next.setEnableSessionCreation(true);
                }
                SNIServerSSLEngine.this.currentRef.set(next);
            }
            finally {
                src.position(mark);
            }
            return next.unwrap(src, dsts, offset, length);
        }

        @Override
        public Runnable getDelegatedTask() {
            return null;
        }

        @Override
        public void closeInbound() throws SSLException {
            SNIServerSSLEngine.this.currentRef.set(CLOSED_STATE);
        }

        @Override
        public boolean isInboundDone() {
            return false;
        }

        @Override
        public void closeOutbound() {
            SNIServerSSLEngine.this.currentRef.set(CLOSED_STATE);
        }

        @Override
        public boolean isOutboundDone() {
            return false;
        }

        @Override
        public String[] getSupportedCipherSuites() {
            throw Assert.unsupported();
        }

        @Override
        public String[] getEnabledCipherSuites() {
            throw Assert.unsupported();
        }

        @Override
        public void setEnabledCipherSuites(String[] suites) {
            throw Assert.unsupported();
        }

        @Override
        public String[] getSupportedProtocols() {
            throw Assert.unsupported();
        }

        @Override
        public String[] getEnabledProtocols() {
            throw Assert.unsupported();
        }

        @Override
        public void setEnabledProtocols(String[] protocols) {
            throw Assert.unsupported();
        }

        @Override
        public SSLSession getSession() {
            return null;
        }

        @Override
        public void beginHandshake() throws SSLException {
        }

        @Override
        public SSLEngineResult.HandshakeStatus getHandshakeStatus() {
            return SSLEngineResult.HandshakeStatus.NEED_UNWRAP;
        }

        @Override
        public void setUseClientMode(boolean mode) {
            if (mode) {
                throw Assert.unsupported();
            }
        }

        @Override
        public boolean getUseClientMode() {
            return false;
        }

        @Override
        public void setNeedClientAuth(boolean need) {
            int newVal;
            int oldVal;
            AtomicInteger flags = this.flags;
            do {
                if (((oldVal = flags.get()) & 2) != 0 != need) continue;
                return;
            } while (!flags.compareAndSet(oldVal, newVal = oldVal & 4 | 2));
        }

        @Override
        public boolean getNeedClientAuth() {
            return (this.flags.get() & 2) != 0;
        }

        @Override
        public void setWantClientAuth(boolean want) {
            int newVal;
            int oldVal;
            AtomicInteger flags = this.flags;
            do {
                if (((oldVal = flags.get()) & 1) != 0 != want) continue;
                return;
            } while (!flags.compareAndSet(oldVal, newVal = oldVal & 4 | 1));
        }

        @Override
        public boolean getWantClientAuth() {
            return (this.flags.get() & 1) != 0;
        }

        @Override
        public void setEnableSessionCreation(boolean flag) {
            int newVal;
            int oldVal;
            AtomicInteger flags = this.flags;
            do {
                if (((oldVal = flags.get()) & 4) != 0 != flag) continue;
                return;
            } while (!flags.compareAndSet(oldVal, newVal = oldVal ^ 4));
        }

        @Override
        public boolean getEnableSessionCreation() {
            return (this.flags.get() & 4) != 0;
        }
    }
}

