/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.sasl.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Predicate;
import org.wildfly.security.auth.server.CredentialMapper;
import org.wildfly.security.password.OneWayPassword;
import org.wildfly.security.password.TwoWayPassword;
import org.wildfly.security.password.interfaces.DigestPassword;
import org.wildfly.security.password.interfaces.OneTimePassword;
import org.wildfly.security.password.interfaces.ScramDigestPassword;
import org.wildfly.security.x500.X509CertificateChainPrivateCredential;

public final class SaslMechanismInformation {
    public static final CredentialMapper SASL_CREDENTIAL_MAPPER = information -> {
        switch (information.getMechanismName()) {
            case "DIGEST-MD5": {
                return Collections.unmodifiableList(Arrays.asList("password-digest-md5", "password-clear"));
            }
            case "DIGEST-SHA": {
                return Collections.unmodifiableList(Arrays.asList("password-digest-sha", "password-clear"));
            }
            case "DIGEST-SHA-256": {
                return Collections.unmodifiableList(Arrays.asList("password-digest-sha256", "password-clear"));
            }
            case "DIGEST-SHA-384": {
                return Collections.unmodifiableList(Arrays.asList("password-digest-sha384", "password-clear"));
            }
            case "DIGEST-SHA-512": {
                return Collections.unmodifiableList(Arrays.asList("password-digest-sha512", "password-clear"));
            }
            case "SCRAM-SHA-1": 
            case "SCRAM-SHA-1-PLUS": {
                return Collections.unmodifiableList(Arrays.asList("password-scram-sha1", "password-clear"));
            }
            case "SCRAM-SHA-256": 
            case "SCRAM-SHA-256-PLUS": {
                return Collections.unmodifiableList(Arrays.asList("password-scram-sha256", "password-clear"));
            }
            case "SCRAM-SHA-384": 
            case "SCRAM-SHA-384-PLUS": {
                return Collections.unmodifiableList(Arrays.asList("password-scram-sha384", "password-clear"));
            }
            case "SCRAM-SHA-512": 
            case "SCRAM-SHA-512-PLUS": {
                return Collections.unmodifiableList(Arrays.asList("password-scram-sha512", "password-clear"));
            }
            case "PLAIN": {
                return Collections.singletonList("password-clear");
            }
            case "OTP": {
                return Collections.singletonList("otp");
            }
            case "9798-M-DSA-SHA1": 
            case "9798-U-DSA-SHA1": {
                return Collections.singletonList("certificate-dsa-sha1");
            }
            case "9798-M-ECDSA-SHA1": 
            case "9798-U-ECDSA-SHA1": {
                return Collections.singletonList("certificate-ecdsa-sha1");
            }
            case "9798-M-RSA-SHA1-ENC": 
            case "9798-U-RSA-SHA1-ENC": {
                return Collections.singletonList("certificate-rsa-sha1-enc");
            }
        }
        return Collections.emptyList();
    };
    private static final Set<String> MD5_MECHS = SaslMechanismInformation.nSet("CRAM-MD5", "DIGEST-MD5");
    private static final Set<String> SHA_MECHS = SaslMechanismInformation.nSet("DIGEST-SHA", "SCRAM-SHA-1", "SCRAM-SHA-1-PLUS");
    private static final Set<String> SHA_256_MECHS = SaslMechanismInformation.nSet("DIGEST-SHA-256", "SCRAM-SHA-256", "SCRAM-SHA-256-PLUS");
    private static final Set<String> SHA_384_MECHS = SaslMechanismInformation.nSet("DIGEST-SHA-384", "SCRAM-SHA-384", "SCRAM-SHA-384-PLUS");
    private static final Set<String> SHA_512_MECHS = SaslMechanismInformation.nSet("DIGEST-SHA-512", "SCRAM-SHA-512", "SCRAM-SHA-512-PLUS");
    private static final Set<String> MUTUAL_MECHS = SaslMechanismInformation.nSet("9798-M-DSA-SHA1", "9798-M-ECDSA-SHA1", "9798-M-RSA-SHA1-ENC");
    private static final Set<String> RECOMMENDED_MECHS = SaslMechanismInformation.nSet("9798-M-DSA-SHA1", "9798-M-ECDSA-SHA1", "9798-M-RSA-SHA1-ENC", "9798-U-DSA-SHA1", "9798-U-ECDSA-SHA1", "9798-U-RSA-SHA1-ENC", "ANONYMOUS", "EAP-AES128", "EAP-AES128-PLUS", "EXTERNAL", "OAUTH10A", "OAUTHBEARER", "OPENID20", "OTP", "SAML20", "SECURID");
    public static final Predicate<String> HASH_MD5 = MD5_MECHS::contains;
    public static final Predicate<String> HASH_SHA = SHA_MECHS::contains;
    public static final Predicate<String> HASH_SHA_256 = SHA_256_MECHS::contains;
    public static final Predicate<String> HASH_SHA_384 = SHA_384_MECHS::contains;
    public static final Predicate<String> HASH_SHA_512 = SHA_512_MECHS::contains;
    public static final Predicate<String> GS2 = name -> name.startsWith("GS2-");
    public static final Predicate<String> SCRAM = name -> name.startsWith("SCRAM-");
    public static final Predicate<String> DIGEST = name -> name.startsWith("DIGEST-");
    public static final Predicate<String> IEC_ISO_9798 = name -> name.startsWith("9798-");
    public static final Predicate<String> EAP = name -> name.startsWith("EAP-");
    public static final Predicate<String> MUTUAL = ((Predicate<String>)MUTUAL_MECHS::contains).or(SCRAM).or(GS2);
    public static final Predicate<String> BINDING = name -> name.endsWith("-PLUS");
    public static final Predicate<String> RECOMMENDED = ((Predicate<String>)RECOMMENDED_MECHS::contains).or(GS2).or(SCRAM).and(HASH_MD5.negate());
    static final Set<Class<?>> JUST_ONE_WAY = Collections.singleton(OneTimePassword.class);
    static final Set<Class<?>> JUST_TWO_WAY = Collections.singleton(TwoWayPassword.class);
    static final Set<Class<?>> ONE_WAY_AND_TWO_WAY = SaslMechanismInformation.nSet(OneWayPassword.class, TwoWayPassword.class);
    static final Set<Class<?>> DIGEST_AND_TWO_WAY = SaslMechanismInformation.nSet(DigestPassword.class, TwoWayPassword.class);
    static final Set<Class<?>> SCRAM_AND_TWO_WAY = SaslMechanismInformation.nSet(ScramDigestPassword.class, TwoWayPassword.class);
    static final Set<Class<?>> JUST_X509 = Collections.singleton(X509CertificateChainPrivateCredential.class);
    static final Set<String> JUST_DIGEST_MD5 = Collections.singleton("digest-md5");
    static final Set<String> JUST_DIGEST_SHA = Collections.singleton("digest-sha");
    static final Set<String> JUST_DIGEST_SHA_256 = Collections.singleton("digest-sha-256");
    static final Set<String> JUST_DIGEST_SHA_384 = Collections.singleton("digest-sha-384");
    static final Set<String> JUST_DIGEST_SHA_512 = Collections.singleton("digest-sha-512");
    static final Set<String> JUST_SCRAM_SHA_1 = Collections.singleton("scram-sha-1");
    static final Set<String> JUST_SCRAM_SHA_256 = Collections.singleton("scram-sha-256");
    static final Set<String> JUST_SCRAM_SHA_384 = Collections.singleton("scram-sha-384");
    static final Set<String> JUST_SCRAM_SHA_512 = Collections.singleton("scram-sha-512");
    static final Set<String> JUST_DSA = Collections.singleton("DSA");
    static final Set<String> JUST_EC = Collections.singleton("EC");
    static final Set<String> JUST_RSA = Collections.singleton("RSA");

    public static Set<Class<?>> getSupportedClientCredentialTypes(String mechName) {
        switch (mechName) {
            case "EXTERNAL": 
            case "ANONYMOUS": {
                return Collections.emptySet();
            }
            case "PLAIN": 
            case "OTP": 
            case "CRAM-MD5": {
                return JUST_TWO_WAY;
            }
            case "DIGEST-MD5": 
            case "DIGEST-SHA": 
            case "DIGEST-SHA-256": 
            case "DIGEST-SHA-384": 
            case "DIGEST-SHA-512": {
                return DIGEST_AND_TWO_WAY;
            }
            case "SCRAM-SHA-1": 
            case "SCRAM-SHA-1-PLUS": 
            case "SCRAM-SHA-256": 
            case "SCRAM-SHA-256-PLUS": 
            case "SCRAM-SHA-384": 
            case "SCRAM-SHA-384-PLUS": 
            case "SCRAM-SHA-512": 
            case "SCRAM-SHA-512-PLUS": {
                return SCRAM_AND_TWO_WAY;
            }
            case "9798-M-DSA-SHA1": 
            case "9798-U-DSA-SHA1": 
            case "9798-M-ECDSA-SHA1": 
            case "9798-U-ECDSA-SHA1": 
            case "9798-M-RSA-SHA1-ENC": 
            case "9798-U-RSA-SHA1-ENC": {
                return JUST_X509;
            }
        }
        return null;
    }

    public static Set<Class<?>> getSupportedServerCredentialTypes(String mechName) {
        switch (mechName) {
            case "EXTERNAL": 
            case "ANONYMOUS": {
                return Collections.emptySet();
            }
            case "PLAIN": {
                return ONE_WAY_AND_TWO_WAY;
            }
            case "OTP": {
                return JUST_ONE_WAY;
            }
            case "CRAM-MD5": {
                return JUST_TWO_WAY;
            }
            case "DIGEST-MD5": 
            case "DIGEST-SHA": 
            case "DIGEST-SHA-256": 
            case "DIGEST-SHA-384": 
            case "DIGEST-SHA-512": {
                return DIGEST_AND_TWO_WAY;
            }
            case "SCRAM-SHA-1": 
            case "SCRAM-SHA-1-PLUS": 
            case "SCRAM-SHA-256": 
            case "SCRAM-SHA-256-PLUS": 
            case "SCRAM-SHA-384": 
            case "SCRAM-SHA-384-PLUS": 
            case "SCRAM-SHA-512": 
            case "SCRAM-SHA-512-PLUS": {
                return SCRAM_AND_TWO_WAY;
            }
            case "9798-M-DSA-SHA1": 
            case "9798-U-DSA-SHA1": 
            case "9798-M-ECDSA-SHA1": 
            case "9798-U-ECDSA-SHA1": 
            case "9798-M-RSA-SHA1-ENC": 
            case "9798-U-RSA-SHA1-ENC": {
                return null;
            }
        }
        return null;
    }

    public static Set<String> getSupportedClientCredentialAlgorithms(String mechName, Class<?> credentialType) {
        switch (mechName) {
            case "CRAM-MD5": 
            case "PLAIN": {
                return Collections.emptySet();
            }
            case "DIGEST-MD5": {
                return credentialType == DigestPassword.class ? JUST_DIGEST_MD5 : Collections.emptySet();
            }
            case "DIGEST-SHA": {
                return credentialType == DigestPassword.class ? JUST_DIGEST_SHA : Collections.emptySet();
            }
            case "DIGEST-SHA-256": {
                return credentialType == DigestPassword.class ? JUST_DIGEST_SHA_256 : Collections.emptySet();
            }
            case "DIGEST-SHA-384": {
                return credentialType == DigestPassword.class ? JUST_DIGEST_SHA_384 : Collections.emptySet();
            }
            case "DIGEST-SHA-512": {
                return credentialType == DigestPassword.class ? JUST_DIGEST_SHA_512 : Collections.emptySet();
            }
            case "SCRAM-SHA-1": 
            case "SCRAM-SHA-1-PLUS": {
                return credentialType == ScramDigestPassword.class ? JUST_SCRAM_SHA_1 : Collections.emptySet();
            }
            case "SCRAM-SHA-256": 
            case "SCRAM-SHA-256-PLUS": {
                return credentialType == ScramDigestPassword.class ? JUST_SCRAM_SHA_256 : Collections.emptySet();
            }
            case "SCRAM-SHA-384": 
            case "SCRAM-SHA-384-PLUS": {
                return credentialType == ScramDigestPassword.class ? JUST_SCRAM_SHA_384 : Collections.emptySet();
            }
            case "SCRAM-SHA-512": 
            case "SCRAM-SHA-512-PLUS": {
                return credentialType == ScramDigestPassword.class ? JUST_SCRAM_SHA_512 : Collections.emptySet();
            }
            case "9798-M-DSA-SHA1": 
            case "9798-U-DSA-SHA1": {
                return credentialType == X509CertificateChainPrivateCredential.class ? JUST_DSA : Collections.emptySet();
            }
            case "9798-M-ECDSA-SHA1": 
            case "9798-U-ECDSA-SHA1": {
                return credentialType == X509CertificateChainPrivateCredential.class ? JUST_EC : Collections.emptySet();
            }
            case "9798-M-RSA-SHA1-ENC": 
            case "9798-U-RSA-SHA1-ENC": {
                return credentialType == X509CertificateChainPrivateCredential.class ? JUST_RSA : Collections.emptySet();
            }
        }
        return Collections.emptySet();
    }

    public static Set<String> getSupportedServerCredentialAlgorithms(String mechName, Class<?> credentialType) {
        switch (mechName) {
            case "CRAM-MD5": 
            case "PLAIN": {
                return Collections.emptySet();
            }
            case "DIGEST-MD5": {
                return credentialType == DigestPassword.class ? JUST_DIGEST_MD5 : Collections.emptySet();
            }
            case "DIGEST-SHA": {
                return credentialType == DigestPassword.class ? JUST_DIGEST_SHA : Collections.emptySet();
            }
            case "DIGEST-SHA-256": {
                return credentialType == DigestPassword.class ? JUST_DIGEST_SHA_256 : Collections.emptySet();
            }
            case "DIGEST-SHA-384": {
                return credentialType == DigestPassword.class ? JUST_DIGEST_SHA_384 : Collections.emptySet();
            }
            case "DIGEST-SHA-512": {
                return credentialType == DigestPassword.class ? JUST_DIGEST_SHA_512 : Collections.emptySet();
            }
            case "SCRAM-SHA-1": 
            case "SCRAM-SHA-1-PLUS": {
                return credentialType == ScramDigestPassword.class ? JUST_SCRAM_SHA_1 : Collections.emptySet();
            }
            case "SCRAM-SHA-256": 
            case "SCRAM-SHA-256-PLUS": {
                return credentialType == ScramDigestPassword.class ? JUST_SCRAM_SHA_256 : Collections.emptySet();
            }
            case "SCRAM-SHA-384": 
            case "SCRAM-SHA-384-PLUS": {
                return credentialType == ScramDigestPassword.class ? JUST_SCRAM_SHA_384 : Collections.emptySet();
            }
            case "SCRAM-SHA-512": 
            case "SCRAM-SHA-512-PLUS": {
                return credentialType == ScramDigestPassword.class ? JUST_SCRAM_SHA_512 : Collections.emptySet();
            }
            case "9798-M-DSA-SHA1": 
            case "9798-U-DSA-SHA1": 
            case "9798-M-ECDSA-SHA1": 
            case "9798-U-ECDSA-SHA1": 
            case "9798-M-RSA-SHA1-ENC": 
            case "9798-U-RSA-SHA1-ENC": {
                return Collections.emptySet();
            }
        }
        return Collections.emptySet();
    }

    @SafeVarargs
    private static <T> Set<T> nSet(T ... values) {
        return Collections.unmodifiableSet(new LinkedHashSet<T>(Arrays.asList(values)));
    }

    public static final class Names {
        public static final String CRAM_MD5 = "CRAM-MD5";
        public static final String DIGEST_MD5 = "DIGEST-MD5";
        public static final String DIGEST_SHA = "DIGEST-SHA";
        public static final String DIGEST_SHA_256 = "DIGEST-SHA-256";
        public static final String DIGEST_SHA_384 = "DIGEST-SHA-384";
        public static final String DIGEST_SHA_512 = "DIGEST-SHA-512";
        public static final String SCRAM_SHA_1 = "SCRAM-SHA-1";
        public static final String SCRAM_SHA_1_PLUS = "SCRAM-SHA-1-PLUS";
        public static final String SCRAM_SHA_256 = "SCRAM-SHA-256";
        public static final String SCRAM_SHA_256_PLUS = "SCRAM-SHA-256-PLUS";
        public static final String SCRAM_SHA_384 = "SCRAM-SHA-384";
        public static final String SCRAM_SHA_384_PLUS = "SCRAM-SHA-384-PLUS";
        public static final String SCRAM_SHA_512 = "SCRAM-SHA-512";
        public static final String SCRAM_SHA_512_PLUS = "SCRAM-SHA-512-PLUS";
        public static final String IEC_ISO_9798_M_DSA_SHA1 = "9798-M-DSA-SHA1";
        public static final String IEC_ISO_9798_M_ECDSA_SHA1 = "9798-M-ECDSA-SHA1";
        public static final String IEC_ISO_9798_M_RSA_SHA1_ENC = "9798-M-RSA-SHA1-ENC";
        public static final String IEC_ISO_9798_U_DSA_SHA1 = "9798-U-DSA-SHA1";
        public static final String IEC_ISO_9798_U_ECDSA_SHA1 = "9798-U-ECDSA-SHA1";
        public static final String IEC_ISO_9798_U_RSA_SHA1_ENC = "9798-U-RSA-SHA1-ENC";
        public static final String ANONYMOUS = "ANONYMOUS";
        public static final String EAP_AES128 = "EAP-AES128";
        public static final String EAP_AES128_PLUS = "EAP-AES128-PLUS";
        public static final String EXTERNAL = "EXTERNAL";
        public static final String OAUTH_10_A = "OAUTH10A";
        public static final String OAUTHBEARER = "OAUTHBEARER";
        public static final String OPENID20 = "OPENID20";
        public static final String OTP = "OTP";
        public static final String SAML20 = "SAML20";
        public static final String SECURID = "SECURID";
        public static final String PLAIN = "PLAIN";
        public static final String GSSAPI = "GSSAPI";

        private Names() {
        }
    }
}

