/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.server;

import java.util.Collections;
import java.util.List;
import org.wildfly.common.Assert;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.http.HttpServerAuthenticationMechanismFactory;
import org.wildfly.security.util._private.UnmodifiableArrayList;

public final class SecurityDomainHttpConfiguration {
    private final SecurityDomain securityDomain;
    private final HttpServerAuthenticationMechanismFactory mechanismFactory;

    public SecurityDomainHttpConfiguration(SecurityDomain securityDomain, HttpServerAuthenticationMechanismFactory mechanismFactory) {
        this.securityDomain = (SecurityDomain)Assert.checkNotNullParam((String)"securityDomain", (Object)securityDomain);
        this.mechanismFactory = (HttpServerAuthenticationMechanismFactory)Assert.checkNotNullParam((String)"mechanismFactory", (Object)mechanismFactory);
    }

    public SecurityDomain getSecurityDomain() {
        return this.securityDomain;
    }

    public HttpServerAuthenticationMechanismFactory getMechanismFactory() {
        return this.mechanismFactory;
    }

    public List<String> getMechanismNames() {
        String[] names = this.mechanismFactory.getMechanismNames(Collections.emptyMap());
        if (names == null || names.length == 0) {
            return Collections.emptyList();
        }
        if (names.length == 1) {
            return Collections.singletonList(names[0]);
        }
        return new UnmodifiableArrayList<String>(names);
    }
}

