/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.server;

import org.wildfly.security._private.ElytronMessages;

public class AuthenticationInformation {
    private final String mechanismType;
    private final String mechanismName;
    private final String protocol;
    private final String authenticationName;

    private AuthenticationInformation(Builder builder) {
        this.mechanismType = builder.mechanismType;
        this.mechanismName = builder.mechanismName;
        this.protocol = builder.protocol;
        this.authenticationName = builder.authenticationName;
    }

    public String getMechanismType() {
        return this.mechanismType;
    }

    public String getMechanismName() {
        return this.mechanismName;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getAuthenticationName() {
        return this.authenticationName;
    }

    public static final class Builder {
        private boolean built = false;
        private String mechanismType;
        private String mechanismName;
        private String protocol;
        private String authenticationName;

        public Builder setMechanismType(String mechanismType) {
            this.assertNotBuilt();
            this.mechanismType = mechanismType;
            return this;
        }

        public Builder setMechanismName(String mechanismName) {
            this.assertNotBuilt();
            this.mechanismName = mechanismName;
            return this;
        }

        public Builder setProtocol(String protocol) {
            this.assertNotBuilt();
            this.protocol = protocol;
            return this;
        }

        public Builder setAuthenticationName(String authenticationName) {
            this.assertNotBuilt();
            this.authenticationName = authenticationName;
            return this;
        }

        public AuthenticationInformation build() {
            this.built = true;
            return new AuthenticationInformation(this);
        }

        private void assertNotBuilt() {
            if (this.built) {
                throw ElytronMessages.log.builderAlreadyBuilt();
            }
        }
    }
}

