/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.provider.ldap;

import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.NoSuchAttributeException;
import org.wildfly.common.Assert;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.auth.provider.ldap.CredentialLoader;
import org.wildfly.security.auth.provider.ldap.CredentialPersister;
import org.wildfly.security.auth.provider.ldap.DirContextFactory;
import org.wildfly.security.auth.provider.ldap.IdentityCredentialLoader;
import org.wildfly.security.auth.provider.ldap.IdentityCredentialPersister;
import org.wildfly.security.auth.server.CredentialSupport;
import org.wildfly.security.auth.server.RealmUnavailableException;
import org.wildfly.security.password.Password;
import org.wildfly.security.password.PasswordFactory;
import org.wildfly.security.password.interfaces.OneTimePassword;
import org.wildfly.security.password.spec.OneTimePasswordSpec;
import org.wildfly.security.util.Alphabet;
import org.wildfly.security.util.ByteIterator;
import org.wildfly.security.util.CodePointIterator;

public class OtpCredentialLoader
implements CredentialLoader,
CredentialPersister {
    public static final String DEFAULT_CREDENTIAL_NAME = "otp";
    private final String myCredentialName;
    private final String algorithmAttributeName;
    private final String hashAttributeName;
    private final String seedAttributeName;
    private final String sequenceAttributeName;

    public OtpCredentialLoader(String credentialName, String algorithmAttributeName, String hashAttributeName, String seedAttributeName, String sequenceAttributeName) {
        Assert.checkNotNullParam((String)"credentialName", (Object)credentialName);
        Assert.checkNotNullParam((String)"algorithmAttributeName", (Object)algorithmAttributeName);
        Assert.checkNotNullParam((String)"hashAttributeName", (Object)hashAttributeName);
        Assert.checkNotNullParam((String)"seedAttributeName", (Object)seedAttributeName);
        Assert.checkNotNullParam((String)"sequenceAttributeName", (Object)sequenceAttributeName);
        this.myCredentialName = credentialName;
        this.algorithmAttributeName = algorithmAttributeName;
        this.hashAttributeName = hashAttributeName;
        this.seedAttributeName = seedAttributeName;
        this.sequenceAttributeName = sequenceAttributeName;
    }

    @Override
    public CredentialSupport getCredentialSupport(DirContextFactory contextFactory, String credentialName) {
        return this.myCredentialName.equals(credentialName) ? CredentialSupport.UNKNOWN : CredentialSupport.UNSUPPORTED;
    }

    @Override
    public ForIdentityLoader forIdentity(DirContextFactory contextFactory, String distinguishedName) {
        return new ForIdentityLoader(contextFactory, distinguishedName);
    }

    private class ForIdentityLoader
    implements IdentityCredentialLoader,
    IdentityCredentialPersister {
        private final DirContextFactory contextFactory;
        private final String distinguishedName;

        public ForIdentityLoader(DirContextFactory contextFactory, String distinguishedName) {
            this.contextFactory = contextFactory;
            this.distinguishedName = distinguishedName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public CredentialSupport getCredentialSupport(String credentialName) {
            if (!OtpCredentialLoader.this.myCredentialName.equals(credentialName)) {
                return CredentialSupport.UNSUPPORTED;
            }
            DirContext context = null;
            try {
                context = this.contextFactory.obtainDirContext(null);
                Attributes attributes = context.getAttributes(this.distinguishedName, new String[]{OtpCredentialLoader.this.algorithmAttributeName, OtpCredentialLoader.this.hashAttributeName, OtpCredentialLoader.this.seedAttributeName, OtpCredentialLoader.this.sequenceAttributeName});
                Attribute algorithmAttribute = attributes.get(OtpCredentialLoader.this.algorithmAttributeName);
                Attribute hashAttribute = attributes.get(OtpCredentialLoader.this.hashAttributeName);
                Attribute seedAttribute = attributes.get(OtpCredentialLoader.this.seedAttributeName);
                Attribute sequenceAttribute = attributes.get(OtpCredentialLoader.this.sequenceAttributeName);
                if (algorithmAttribute != null && hashAttribute != null && seedAttribute != null && sequenceAttribute != null) {
                    CredentialSupport credentialSupport = CredentialSupport.FULLY_SUPPORTED;
                    return credentialSupport;
                }
            }
            catch (NamingException namingException) {
            }
            finally {
                this.contextFactory.returnContext(context);
            }
            return CredentialSupport.UNSUPPORTED;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <C> C getCredential(String credentialName, Class<C> credentialType) {
            if (!OtpCredentialLoader.this.myCredentialName.equals(credentialName)) {
                return null;
            }
            DirContext context = null;
            try {
                context = this.contextFactory.obtainDirContext(null);
                Attributes attributes = context.getAttributes(this.distinguishedName, new String[]{OtpCredentialLoader.this.algorithmAttributeName, OtpCredentialLoader.this.hashAttributeName, OtpCredentialLoader.this.seedAttributeName, OtpCredentialLoader.this.sequenceAttributeName});
                Attribute algorithmAttribute = attributes.get(OtpCredentialLoader.this.algorithmAttributeName);
                Attribute hashAttribute = attributes.get(OtpCredentialLoader.this.hashAttributeName);
                Attribute seedAttribute = attributes.get(OtpCredentialLoader.this.seedAttributeName);
                Attribute sequenceAttribute = attributes.get(OtpCredentialLoader.this.sequenceAttributeName);
                if (algorithmAttribute == null || hashAttribute == null || seedAttribute == null || sequenceAttribute == null) {
                    C c = null;
                    return c;
                }
                PasswordFactory passwordFactory = PasswordFactory.getInstance((String)algorithmAttribute.get());
                Password password = passwordFactory.generatePassword(new OneTimePasswordSpec(CodePointIterator.ofString((String)hashAttribute.get()).base64Decode(Alphabet.Base64Alphabet.STANDARD, false).drain(), CodePointIterator.ofString((String)seedAttribute.get()).base64Decode(Alphabet.Base64Alphabet.STANDARD, false).drain(), Integer.valueOf((String)sequenceAttribute.get())));
                if (credentialType.isInstance(password)) {
                    C c = credentialType.cast(password);
                    return c;
                }
            }
            catch (NoSuchAlgorithmException | InvalidKeySpecException | NamingException e) {
                if (ElytronMessages.log.isTraceEnabled()) {
                    ElytronMessages.log.trace("Getting OTP credential of type " + credentialType.getName() + " failed. dn=" + this.distinguishedName, e);
                }
            }
            finally {
                this.contextFactory.returnContext(context);
            }
            return null;
        }

        @Override
        public boolean getCredentialPersistSupport(String credentialName) {
            return OtpCredentialLoader.this.myCredentialName.equals(credentialName);
        }

        @Override
        public void persistCredential(String credentialName, Object credential) throws RealmUnavailableException {
            OneTimePassword password = (OneTimePassword)credential;
            DirContext context = null;
            try {
                context = this.contextFactory.obtainDirContext(null);
                BasicAttributes attributes = new BasicAttributes();
                attributes.put(OtpCredentialLoader.this.algorithmAttributeName, password.getAlgorithm());
                attributes.put(OtpCredentialLoader.this.hashAttributeName, ByteIterator.ofBytes(password.getHash()).base64Encode().drainToString());
                attributes.put(OtpCredentialLoader.this.seedAttributeName, ByteIterator.ofBytes(password.getSeed()).base64Encode().drainToString());
                attributes.put(OtpCredentialLoader.this.sequenceAttributeName, Integer.toString(password.getSequenceNumber()));
                context.modifyAttributes(this.distinguishedName, 2, (Attributes)attributes);
            }
            catch (NamingException e) {
                throw ElytronMessages.log.ldapRealmCredentialPersistingFailed(credential.toString(), this.distinguishedName, e);
            }
            finally {
                this.contextFactory.returnContext(context);
            }
        }

        @Override
        public void clearCredentials() throws RealmUnavailableException {
            DirContext context = null;
            try {
                context = this.contextFactory.obtainDirContext(null);
                BasicAttributes attributes = new BasicAttributes();
                attributes.put(new BasicAttribute(OtpCredentialLoader.this.algorithmAttributeName));
                attributes.put(new BasicAttribute(OtpCredentialLoader.this.hashAttributeName));
                attributes.put(new BasicAttribute(OtpCredentialLoader.this.seedAttributeName));
                attributes.put(new BasicAttribute(OtpCredentialLoader.this.sequenceAttributeName));
                context.modifyAttributes(this.distinguishedName, 3, (Attributes)attributes);
            }
            catch (NoSuchAttributeException attributes) {
            }
            catch (NamingException e) {
                throw ElytronMessages.log.ldapRealmCredentialClearingFailed(this.distinguishedName, e);
            }
            finally {
                this.contextFactory.returnContext(context);
            }
        }
    }
}

