/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.provider;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.wildfly.common.Assert;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.auth.provider.SimpleRealmEntry;
import org.wildfly.security.auth.server.CredentialSupport;
import org.wildfly.security.auth.server.NameRewriter;
import org.wildfly.security.auth.server.RealmIdentity;
import org.wildfly.security.auth.server.RealmUnavailableException;
import org.wildfly.security.auth.server.SecurityRealm;
import org.wildfly.security.authz.Attributes;
import org.wildfly.security.authz.AuthorizationIdentity;
import org.wildfly.security.password.Password;
import org.wildfly.security.password.PasswordFactory;
import org.wildfly.security.password.interfaces.ClearPassword;

public class SimpleMapBackedSecurityRealm
implements SecurityRealm {
    private final NameRewriter rewriter;
    private volatile Map<String, SimpleRealmEntry> map = Collections.emptyMap();

    public SimpleMapBackedSecurityRealm(NameRewriter rewriter) {
        Assert.checkNotNullParam((String)"rewriter", (Object)rewriter);
        this.rewriter = rewriter;
    }

    public SimpleMapBackedSecurityRealm() {
        this(NameRewriter.IDENTITY_REWRITER);
    }

    public void setPasswordMap(Map<String, SimpleRealmEntry> map) {
        Assert.checkNotNullParam((String)"map", map);
        this.map = map;
    }

    public void setPasswordMap(String name, String credentialName, Password password, Attributes attributes) {
        Assert.checkNotNullParam((String)"name", (Object)name);
        Assert.checkNotNullParam((String)"credentialName", (Object)credentialName);
        Assert.checkNotNullParam((String)"password", (Object)password);
        Assert.checkNotNullParam((String)"attributes", (Object)attributes);
        this.map = Collections.singletonMap(name, new SimpleRealmEntry(Collections.singletonMap(credentialName, password), attributes));
    }

    public void setPasswordMap(String name, String credentialName, Password password) {
        Assert.checkNotNullParam((String)"name", (Object)name);
        Assert.checkNotNullParam((String)"credentialName", (Object)credentialName);
        Assert.checkNotNullParam((String)"password", (Object)password);
        this.map = Collections.singletonMap(name, new SimpleRealmEntry(Collections.singletonMap(credentialName, password)));
    }

    @Override
    public RealmIdentity createRealmIdentity(String name) {
        if ((name = this.rewriter.rewriteName(name)) == null) {
            throw ElytronMessages.log.invalidName();
        }
        return new SimpleMapRealmIdentity(name);
    }

    private boolean checkType(Set<Class<?>> supportedTypes, HashSet<Class<?>> checked, Class<?> actualType) {
        return actualType != null && checked.add(actualType) && (supportedTypes.contains(actualType) || this.checkType(supportedTypes, checked, actualType.getSuperclass()) || this.checkInterfaces(supportedTypes, checked, actualType));
    }

    private boolean checkInterfaces(Set<Class<?>> supportedTypes, HashSet<Class<?>> checked, Class<?> actualType) {
        for (Class<?> clazz : actualType.getInterfaces()) {
            if (!this.checkType(supportedTypes, checked, clazz)) continue;
            return true;
        }
        return false;
    }

    @Override
    public CredentialSupport getCredentialSupport(String credentialName) {
        Assert.checkNotNullParam((String)"credentialName", (Object)credentialName);
        return CredentialSupport.UNKNOWN;
    }

    private class SimpleMapRealmIdentity
    implements RealmIdentity {
        private final String name;

        SimpleMapRealmIdentity(String name) {
            this.name = name;
        }

        @Override
        public CredentialSupport getCredentialSupport(String credentialName) {
            Assert.checkNotNullParam((String)"credentialName", (Object)credentialName);
            SimpleRealmEntry entry = (SimpleRealmEntry)SimpleMapBackedSecurityRealm.this.map.get(this.name);
            if (entry == null) {
                return CredentialSupport.UNSUPPORTED;
            }
            return entry.getPassword(credentialName) != null ? CredentialSupport.FULLY_SUPPORTED : CredentialSupport.UNSUPPORTED;
        }

        @Override
        public <C> C getCredential(String credentialName, Class<C> credentialType) {
            Assert.checkNotNullParam((String)"credentialName", (Object)credentialName);
            Assert.checkNotNullParam((String)"credentialType", credentialType);
            SimpleRealmEntry entry = (SimpleRealmEntry)SimpleMapBackedSecurityRealm.this.map.get(this.name);
            if (entry == null) {
                return null;
            }
            Password password = entry.getPassword(credentialName);
            return credentialType.isInstance(password) ? (C)credentialType.cast(password) : null;
        }

        @Override
        public AuthorizationIdentity getAuthorizationIdentity() {
            SimpleRealmEntry entry = (SimpleRealmEntry)SimpleMapBackedSecurityRealm.this.map.get(this.name);
            return entry == null ? AuthorizationIdentity.EMPTY : AuthorizationIdentity.basicIdentity(entry.getAttributes());
        }

        @Override
        public boolean verifyCredential(String credentialName, Object credential) throws RealmUnavailableException {
            Assert.checkNotNullParam((String)"credentialName", (Object)credentialName);
            Assert.checkNotNullParam((String)"credential", (Object)credential);
            try {
                SimpleRealmEntry entry = (SimpleRealmEntry)SimpleMapBackedSecurityRealm.this.map.get(this.name);
                if (entry == null) {
                    return false;
                }
                Password password = entry.getPassword(credentialName);
                if (credential instanceof char[]) {
                    return PasswordFactory.getInstance(password.getAlgorithm()).verify(password, (char[])credential);
                }
                if (credential instanceof ClearPassword) {
                    return PasswordFactory.getInstance(password.getAlgorithm()).verify(password, ((ClearPassword)credential).getPassword());
                }
                return false;
            }
            catch (InvalidKeyException | NoSuchAlgorithmException e) {
                throw new RealmUnavailableException(e);
            }
        }

        @Override
        public boolean exists() throws RealmUnavailableException {
            return SimpleMapBackedSecurityRealm.this.map.containsKey(this.name);
        }
    }
}

