/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.provider;

import java.security.InvalidKeyException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableEntryException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import javax.crypto.SecretKey;
import javax.security.auth.x500.X500PrivateCredential;
import org.wildfly.security.auth.server.CredentialSupport;
import org.wildfly.security.auth.server.RealmIdentity;
import org.wildfly.security.auth.server.RealmUnavailableException;
import org.wildfly.security.auth.server.SecurityRealm;
import org.wildfly.security.authz.AuthorizationIdentity;
import org.wildfly.security.keystore.PasswordEntry;
import org.wildfly.security.password.Password;
import org.wildfly.security.password.PasswordFactory;

public class KeyStoreBackedSecurityRealm
implements SecurityRealm {
    private final KeyStore keyStore;
    public final char USER_CREDENTIAL_DELIMITER = (char)124;

    public KeyStoreBackedSecurityRealm(KeyStore keyStore) {
        this.keyStore = keyStore;
    }

    @Override
    public RealmIdentity createRealmIdentity(String name) throws RealmUnavailableException {
        return new KeyStoreRealmIdentity(name);
    }

    @Override
    public CredentialSupport getCredentialSupport(String credentialName) {
        return CredentialSupport.UNKNOWN;
    }

    private KeyStore.Entry getEntry(String name) {
        try {
            return this.keyStore.getEntry(name, null);
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
        catch (UnrecoverableEntryException e) {
            return null;
        }
        catch (KeyStoreException e) {
            return null;
        }
    }

    private class KeyStoreRealmIdentity
    implements RealmIdentity {
        private final String name;

        private KeyStoreRealmIdentity(String name) {
            this.name = name;
        }

        @Override
        public CredentialSupport getCredentialSupport(String credentialName) {
            KeyStore.Entry entry = KeyStoreBackedSecurityRealm.this.getEntry(this.name + '|' + credentialName);
            if (entry == null) {
                return CredentialSupport.UNSUPPORTED;
            }
            return CredentialSupport.FULLY_SUPPORTED;
        }

        @Override
        public <C> C getCredential(String credentialName, Class<C> credentialType) {
            SecretKey secretKey;
            KeyStore.Entry entry = KeyStoreBackedSecurityRealm.this.getEntry(this.name + '|' + credentialName);
            if (entry == null) {
                return null;
            }
            if (entry instanceof PasswordEntry) {
                Password password = ((PasswordEntry)entry).getPassword();
                if (credentialType.isInstance(password)) {
                    return credentialType.cast(password);
                }
            } else if (entry instanceof KeyStore.PrivateKeyEntry) {
                KeyStore.PrivateKeyEntry privateKeyEntry = (KeyStore.PrivateKeyEntry)entry;
                PrivateKey privateKey = privateKeyEntry.getPrivateKey();
                Certificate certificate = privateKeyEntry.getCertificate();
                if (credentialType.isInstance(privateKey)) {
                    return credentialType.cast(privateKey);
                }
                if (credentialType.isInstance(certificate)) {
                    return credentialType.cast(certificate);
                }
                if (credentialType.isAssignableFrom(X500PrivateCredential.class) && certificate instanceof X509Certificate) {
                    return credentialType.cast(new X500PrivateCredential((X509Certificate)certificate, privateKey, this.name));
                }
            } else if (entry instanceof KeyStore.TrustedCertificateEntry) {
                Certificate certificate = ((KeyStore.TrustedCertificateEntry)entry).getTrustedCertificate();
                if (credentialType.isInstance(certificate)) {
                    return credentialType.cast(certificate);
                }
            } else if (entry instanceof KeyStore.SecretKeyEntry && credentialType.isInstance(secretKey = ((KeyStore.SecretKeyEntry)entry).getSecretKey())) {
                return credentialType.cast(secretKey);
            }
            return null;
        }

        @Override
        public AuthorizationIdentity getAuthorizationIdentity() {
            return new AuthorizationIdentity(){};
        }

        @Override
        public boolean verifyCredential(String credentialName, Object credential) throws RealmUnavailableException {
            KeyStore.Entry entry = KeyStoreBackedSecurityRealm.this.getEntry(this.name + '|' + credentialName);
            if (entry == null) {
                return false;
            }
            if (entry instanceof PasswordEntry) {
                Password password = ((PasswordEntry)entry).getPassword();
                if (credential instanceof char[]) {
                    try {
                        PasswordFactory passwordFactory = PasswordFactory.getInstance(password.getAlgorithm());
                        return passwordFactory.verify(passwordFactory.translate(password), (char[])credential);
                    }
                    catch (InvalidKeyException | NoSuchAlgorithmException e) {
                        throw new RealmUnavailableException(e);
                    }
                }
                return false;
            }
            return false;
        }

        @Override
        public boolean exists() throws RealmUnavailableException {
            return true;
        }
    }
}

