/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.provider;

import org.wildfly.security.auth.server.CredentialSupport;
import org.wildfly.security.auth.server.RealmIdentity;
import org.wildfly.security.auth.server.RealmUnavailableException;
import org.wildfly.security.auth.server.SecurityRealm;
import org.wildfly.security.authz.AuthorizationIdentity;

public final class AggregateSecurityRealm
implements SecurityRealm {
    private final SecurityRealm authenticationRealm;
    private final SecurityRealm authorizationRealm;

    public AggregateSecurityRealm(SecurityRealm authenticationRealm, SecurityRealm authorizationRealm) {
        this.authenticationRealm = authenticationRealm;
        this.authorizationRealm = authorizationRealm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RealmIdentity createRealmIdentity(String name) throws RealmUnavailableException {
        boolean ok = false;
        RealmIdentity authenticationIdentity = this.authenticationRealm.createRealmIdentity(name);
        try {
            RealmIdentity authorizationIdentity = this.authorizationRealm.createRealmIdentity(name);
            try {
                Identity identity = new Identity(authenticationIdentity, authorizationIdentity);
                ok = true;
                Identity identity2 = identity;
                if (!ok) {
                    authorizationIdentity.dispose();
                }
                return identity2;
            }
            catch (Throwable throwable) {
                if (!ok) {
                    authorizationIdentity.dispose();
                }
                throw throwable;
            }
        }
        finally {
            if (!ok) {
                authenticationIdentity.dispose();
            }
        }
    }

    @Override
    public CredentialSupport getCredentialSupport(String credentialName) throws RealmUnavailableException {
        return this.authenticationRealm.getCredentialSupport(credentialName);
    }

    static final class Identity
    implements RealmIdentity {
        private final RealmIdentity authenticationIdentity;
        private final RealmIdentity authorizationIdentity;

        Identity(RealmIdentity authenticationIdentity, RealmIdentity authorizationIdentity) {
            this.authenticationIdentity = authenticationIdentity;
            this.authorizationIdentity = authorizationIdentity;
        }

        @Override
        public CredentialSupport getCredentialSupport(String credentialName) throws RealmUnavailableException {
            return this.authenticationIdentity.getCredentialSupport(credentialName);
        }

        @Override
        public <C> C getCredential(String credentialName, Class<C> credentialType) throws RealmUnavailableException {
            return this.authenticationIdentity.getCredential(credentialName, credentialType);
        }

        @Override
        public boolean verifyCredential(String credentialName, Object credential) throws RealmUnavailableException {
            return this.authenticationIdentity.verifyCredential(credentialName, credential);
        }

        @Override
        public boolean exists() throws RealmUnavailableException {
            return this.authenticationIdentity.exists();
        }

        @Override
        public AuthorizationIdentity getAuthorizationIdentity() throws RealmUnavailableException {
            return this.authorizationIdentity.exists() ? this.authorizationIdentity.getAuthorizationIdentity() : AuthorizationIdentity.EMPTY;
        }

        @Override
        public void dispose() {
            this.authenticationIdentity.dispose();
            this.authorizationIdentity.dispose();
        }
    }
}

