/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.client;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.net.ssl.X509KeyManager;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.x500.X500Principal;
import org.wildfly.security.SecurityFactory;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.auth.callback.CredentialCallback;
import org.wildfly.security.auth.callback.TrustedAuthoritiesCallback;
import org.wildfly.security.auth.client.AuthenticationConfiguration;
import org.wildfly.security.auth.client.SetCallbackHandlerAuthenticationConfiguration;
import org.wildfly.security.auth.client.SetCertificateCredentialAuthenticationConfiguration;
import org.wildfly.security.auth.client.SetCertificateURLCredentialAuthenticationConfiguration;
import org.wildfly.security.auth.client.SetGSSCredentialAuthenticationConfiguration;
import org.wildfly.security.auth.client.SetKeyStoreCredentialAuthenticationConfiguration;
import org.wildfly.security.auth.client.SetPasswordAuthenticationConfiguration;
import org.wildfly.security.sasl.entity.TrustedAuthority;
import org.wildfly.security.x500.X509CertificateChainPrivateCredential;
import org.wildfly.security.x500.X509CertificateCredentialDecoder;

class SetKeyManagerCredentialAuthenticationConfiguration
extends AuthenticationConfiguration {
    private final SecurityFactory<X509KeyManager> keyManagerFactory;

    SetKeyManagerCredentialAuthenticationConfiguration(AuthenticationConfiguration parent, SecurityFactory<X509KeyManager> keyManagerFactory) {
        super(parent.without(SetPasswordAuthenticationConfiguration.class).without(SetCallbackHandlerAuthenticationConfiguration.class).without(SetGSSCredentialAuthenticationConfiguration.class).without(SetKeyStoreCredentialAuthenticationConfiguration.class).without(SetCertificateCredentialAuthenticationConfiguration.class).without(SetCertificateURLCredentialAuthenticationConfiguration.class));
        this.keyManagerFactory = keyManagerFactory;
    }

    @Override
    AuthenticationConfiguration reparent(AuthenticationConfiguration newParent) {
        return new SetKeyManagerCredentialAuthenticationConfiguration(newParent, this.keyManagerFactory);
    }

    @Override
    SecurityFactory<X509KeyManager> getX509KeyManagerFactory() throws GeneralSecurityException {
        return this.keyManagerFactory;
    }

    @Override
    void handleCallbacks(AuthenticationConfiguration config, Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        List<TrustedAuthority> trustedAuthorities = null;
        block2: for (Callback callback : callbacks) {
            if (callback instanceof TrustedAuthoritiesCallback) {
                trustedAuthorities = ((TrustedAuthoritiesCallback)callback).getTrustedAuthorities();
                continue;
            }
            if (!(callback instanceof CredentialCallback)) continue;
            X509KeyManager keyManager = null;
            try {
                keyManager = this.keyManagerFactory.create();
            }
            catch (GeneralSecurityException e) {
                throw ElytronMessages.log.unableToCreateKeyManager(e);
            }
            CredentialCallback credentialCallback = (CredentialCallback)callback;
            for (Class<?> allowedType : credentialCallback.getAllowedTypes()) {
                String[] keyType;
                String alias;
                Set<String> allowedAlgorithms = credentialCallback.getAllowedAlgorithms(allowedType);
                if (allowedAlgorithms == null || (alias = keyManager.chooseClientAlias(keyType = allowedAlgorithms.toArray(new String[allowedAlgorithms.size()]), this.getAcceptableIssuers(trustedAuthorities), null)) == null) continue;
                X509Certificate[] certificateChain = keyManager.getCertificateChain(alias);
                PrivateKey privateKey = keyManager.getPrivateKey(alias);
                if (certificateChain == null || certificateChain.length == 0) {
                    credentialCallback.setCredential(privateKey);
                    continue block2;
                }
                credentialCallback.setCredential(new X509CertificateChainPrivateCredential(privateKey, certificateChain));
                continue block2;
            }
        }
        super.handleCallbacks(config, callbacks);
    }

    @Override
    void handleCallback(Callback[] callbacks, int index) throws IOException, UnsupportedCallbackException {
        Callback callback = callbacks[index];
        if (callback instanceof TrustedAuthoritiesCallback || callback instanceof CredentialCallback) {
            return;
        }
        super.handleCallback(callbacks, index);
    }

    private Principal[] getAcceptableIssuers(List<TrustedAuthority> trustedAuthorities) {
        if (trustedAuthorities == null) {
            return null;
        }
        ArrayList<X500Principal> issuers = new ArrayList<X500Principal>();
        for (TrustedAuthority trustedAuthority : trustedAuthorities) {
            if (trustedAuthority instanceof TrustedAuthority.CertificateTrustedAuthority) {
                X509Certificate authorityCertificate = ((TrustedAuthority.CertificateTrustedAuthority)trustedAuthority).getIdentifier();
                issuers.add(X509CertificateCredentialDecoder.getInstance().getPrincipalFromCredential(authorityCertificate));
                continue;
            }
            if (!(trustedAuthority instanceof TrustedAuthority.NameTrustedAuthority)) continue;
            String authorityName = ((TrustedAuthority.NameTrustedAuthority)trustedAuthority).getIdentifier();
            issuers.add(new X500Principal(authorityName));
        }
        return issuers.toArray(new Principal[issuers.size()]);
    }
}

