/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.sasl.plain;

import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.sasl.util.SaslWrapper;
import org.wildfly.security.sasl.util.StringPrep;
import org.wildfly.security.util.ByteStringBuilder;

class PlainSaslClient
implements SaslClient,
SaslWrapper {
    private final String authorizationId;
    private final CallbackHandler cbh;
    private boolean complete = false;

    PlainSaslClient(String authorizationId, CallbackHandler cbh) {
        this.authorizationId = authorizationId;
        this.cbh = cbh;
    }

    @Override
    public String getMechanismName() {
        return "PLAIN";
    }

    @Override
    public boolean hasInitialResponse() {
        return true;
    }

    @Override
    public byte[] evaluateChallenge(byte[] challenge) throws SaslException {
        if (this.complete) {
            throw ElytronMessages.log.saslMessageAfterComplete(this.getMechanismName());
        }
        this.complete = true;
        if (challenge.length > 0) {
            throw ElytronMessages.log.saslInvalidMessageReceived(this.getMechanismName());
        }
        NameCallback nameCallback = new NameCallback("Login name");
        PasswordCallback passwordCallback = new PasswordCallback("Password", false);
        try {
            this.cbh.handle(new Callback[]{nameCallback, passwordCallback});
        }
        catch (SaslException e) {
            throw e;
        }
        catch (IOException | UnsupportedCallbackException e) {
            throw ElytronMessages.log.saslCallbackHandlerFailedForUnknownReason(this.getMechanismName(), e);
        }
        String name = nameCallback.getName();
        if (name == null) {
            throw ElytronMessages.log.saslNoLoginNameGiven(this.getMechanismName());
        }
        char[] password = passwordCallback.getPassword();
        if (password == null) {
            throw ElytronMessages.log.saslNoPasswordGiven(this.getMechanismName());
        }
        try {
            ByteStringBuilder b = new ByteStringBuilder();
            if (this.authorizationId != null) {
                StringPrep.encode(this.authorizationId, b, 16383L);
            }
            b.append((byte)0);
            StringPrep.encode(name, b, 16383L);
            b.append((byte)0);
            StringPrep.encode(password, b, 16383L);
            return b.toArray();
        }
        catch (IllegalArgumentException ex) {
            throw ElytronMessages.log.saslMalformedFields(this.getMechanismName(), ex);
        }
    }

    @Override
    public boolean isComplete() {
        return this.complete;
    }

    @Override
    public byte[] unwrap(byte[] incoming, int offset, int len) throws SaslException {
        if (this.complete) {
            throw ElytronMessages.log.saslAuthenticationNotComplete(this.getMechanismName());
        }
        throw ElytronMessages.log.saslNoSecurityLayer(this.getMechanismName());
    }

    @Override
    public byte[] wrap(byte[] outgoing, int offset, int len) throws SaslException {
        if (this.complete) {
            throw ElytronMessages.log.saslAuthenticationNotComplete(this.getMechanismName());
        }
        throw ElytronMessages.log.saslNoSecurityLayer(this.getMechanismName());
    }

    @Override
    public Object getNegotiatedProperty(String propName) {
        return null;
    }

    @Override
    public void dispose() throws SaslException {
    }
}

