/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.server;

import java.util.EnumSet;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.auth.server.SupportLevel;

public enum CredentialSupport {
    UNSUPPORTED(SupportLevel.UNSUPPORTED, SupportLevel.UNSUPPORTED),
    POSSIBLY_VERIFIABLE(SupportLevel.UNSUPPORTED, SupportLevel.POSSIBLY_SUPPORTED),
    POSSIBLY_OBTAINABLE(SupportLevel.POSSIBLY_SUPPORTED, SupportLevel.UNSUPPORTED),
    OBTAINABLE_ONLY(SupportLevel.SUPPORTED, SupportLevel.UNSUPPORTED),
    VERIFIABLE_ONLY(SupportLevel.UNSUPPORTED, SupportLevel.SUPPORTED),
    UNKNOWN(SupportLevel.POSSIBLY_SUPPORTED, SupportLevel.POSSIBLY_SUPPORTED),
    VERIFIABLE_MAYBE_OBTAINABLE(SupportLevel.POSSIBLY_SUPPORTED, SupportLevel.SUPPORTED),
    FULLY_SUPPORTED(SupportLevel.SUPPORTED, SupportLevel.SUPPORTED);

    private final SupportLevel obtainable;
    private final SupportLevel verifiable;
    private static final int fullSize;

    private CredentialSupport(SupportLevel obtainable, SupportLevel verifiable) {
        this.obtainable = obtainable;
        this.verifiable = verifiable;
    }

    public SupportLevel obtainableSupportLevel() {
        return this.obtainable;
    }

    public SupportLevel verificationSupportLevel() {
        return this.verifiable;
    }

    public boolean isDefinitelyObtainable() {
        return this.obtainable.isDefinitelySupported();
    }

    public boolean isDefinitelyVerifiable() {
        return this.verifiable.isDefinitelySupported();
    }

    public boolean mayBeObtainable() {
        return this.obtainable.mayBeSupported();
    }

    public boolean mayBeVerifiable() {
        return this.verifiable.mayBeSupported();
    }

    public boolean isNotObtainable() {
        return this.obtainable.isNotSupported();
    }

    public boolean isNotVerifiable() {
        return this.verifiable.isNotSupported();
    }

    public boolean isNotSupported() {
        return this.isNotObtainable() && this.isNotVerifiable();
    }

    public static CredentialSupport getCredentialSupport(SupportLevel obtainable, SupportLevel verifiable) {
        for (CredentialSupport current : CredentialSupport.values()) {
            if (!current.obtainable.equals((Object)obtainable) || !current.verifiable.equals((Object)verifiable)) continue;
            return current;
        }
        throw ElytronMessages.log.invalidCombinationOfObtainableAndVerifiable();
    }

    public static boolean isFull(EnumSet<CredentialSupport> set) {
        return set != null && set.size() == fullSize;
    }

    public boolean in(CredentialSupport v1) {
        return this == v1;
    }

    public boolean in(CredentialSupport v1, CredentialSupport v2) {
        return this == v1 || this == v2;
    }

    public boolean in(CredentialSupport v1, CredentialSupport v2, CredentialSupport v3) {
        return this == v1 || this == v2 || this == v3;
    }

    public boolean in(CredentialSupport ... values) {
        if (values != null) {
            for (CredentialSupport value : values) {
                if (this != value) continue;
                return true;
            }
        }
        return false;
    }

    static {
        fullSize = CredentialSupport.values().length;
    }
}

