/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.callback;

import java.io.Serializable;
import java.util.Map;
import java.util.Set;
import org.wildfly.security.auth.callback.ExtendedCallback;

public final class CredentialCallback
implements ExtendedCallback,
Serializable {
    private static final long serialVersionUID = 4756568346009259703L;
    private final Map<Class<?>, Set<String>> allowedTypes;
    private Object credential;

    public CredentialCallback(Map<Class<?>, Set<String>> allowedTypes) {
        this.allowedTypes = allowedTypes;
    }

    public CredentialCallback(Object credential, Map<Class<?>, Set<String>> allowedTypes) {
        this(allowedTypes);
        this.credential = credential;
    }

    public Object getCredential() {
        return this.credential;
    }

    public void setCredential(Object credential) {
        this.credential = credential;
    }

    public boolean isCredentialSupported(Class<?> credentialType, String algorithm) {
        Class<?>[] interfaces;
        Set<String> set = this.allowedTypes.get(credentialType);
        if (set != null) {
            return algorithm == null || set.isEmpty() || set.contains(algorithm);
        }
        Class<?> superclass = credentialType.getSuperclass();
        if (superclass != Object.class && superclass != null && this.isCredentialSupported(superclass, algorithm)) {
            return true;
        }
        for (Class<?> clazz : interfaces = credentialType.getInterfaces()) {
            if (!this.isCredentialSupported(clazz, algorithm)) continue;
            return true;
        }
        return false;
    }

    public Set<Class<?>> getAllowedTypes() {
        return this.allowedTypes.keySet();
    }

    public Set<String> getAllowedAlgorithms(Class<?> type) {
        return this.allowedTypes.get(type);
    }

    @Override
    public boolean isOptional() {
        return this.credential != null;
    }

    @Override
    public boolean needsInformation() {
        return true;
    }
}

