/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.sasl.util;

import java.security.InvalidParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.function.Supplier;
import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslClientFactory;
import javax.security.sasl.SaslException;

public final class SecurityProviderSaslClientFactory
implements SaslClientFactory {
    private static final String serviceType = SaslClientFactory.class.getSimpleName();
    private final Supplier<Provider[]> providerSupplier;

    public SecurityProviderSaslClientFactory(Supplier<Provider[]> providerSupplier) {
        this.providerSupplier = providerSupplier;
    }

    @Override
    public SaslClient createSaslClient(String[] mechanisms, String authorizationId, String protocol, String serverName, Map<String, ?> props, CallbackHandler cbh) throws SaslException {
        for (Provider currentProvider : this.providerSupplier.get()) {
            for (Provider.Service service : currentProvider.getServices()) {
                if (!serviceType.equals(service.getType())) continue;
                try {
                    SaslClient saslClient = ((SaslClientFactory)service.newInstance(null)).createSaslClient(mechanisms, authorizationId, protocol, serverName, props, cbh);
                    if (saslClient == null) continue;
                    return saslClient;
                }
                catch (ClassCastException | InvalidParameterException | NoSuchAlgorithmException exception) {
                }
            }
        }
        return null;
    }

    @Override
    public String[] getMechanismNames(Map<String, ?> props) {
        LinkedHashSet names = new LinkedHashSet();
        for (Provider currentProvider : this.providerSupplier.get()) {
            for (Provider.Service service : currentProvider.getServices()) {
                if (!serviceType.equals(service.getType())) continue;
                try {
                    Collections.addAll(names, ((SaslClientFactory)service.newInstance(null)).getMechanismNames(props));
                }
                catch (ClassCastException | InvalidParameterException | NoSuchAlgorithmException exception) {}
            }
        }
        return names.toArray(new String[names.size()]);
    }
}

