/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.sasl.scram;

import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import javax.crypto.Mac;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.SaslException;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.auth.callback.CredentialCallback;
import org.wildfly.security.auth.callback.FastUnsupportedCallbackException;
import org.wildfly.security.auth.callback.ParameterCallback;
import org.wildfly.security.password.Password;
import org.wildfly.security.password.TwoWayPassword;
import org.wildfly.security.password.interfaces.ScramDigestPassword;
import org.wildfly.security.password.spec.HashedPasswordAlgorithmSpec;
import org.wildfly.security.sasl.scram.ScramUtil;
import org.wildfly.security.sasl.util.AbstractSaslServer;
import org.wildfly.security.sasl.util.StringPrep;
import org.wildfly.security.util.ByteIterator;
import org.wildfly.security.util.ByteStringBuilder;

final class ScramSaslServer
extends AbstractSaslServer {
    private static final int S_NO_MESSAGE = 1;
    private static final int S_FIRST_MESSAGE = 2;
    private static final int S_FINAL_MESSAGE = 3;
    private final boolean plus;
    private final MessageDigest messageDigest;
    private final Mac mac;
    private final SecureRandom secureRandom;
    private final int minimumIterationCount;
    private final int maximumIterationCount;
    private final String bindingType;
    private final byte[] bindingData;
    private String userName;
    private String authorizationID;
    private byte[] clientFirstMessage;
    private byte[] serverFirstMessage;
    private byte[] saltedPassword;
    private byte[] salt;
    private HashedPasswordAlgorithmSpec algorithmSpec;
    private int iterationCount;
    private final boolean sendErrors = false;
    private int clientFirstMessageBareStart;
    private int cbindFlag;

    ScramSaslServer(String mechanismName, String protocol, String serverName, CallbackHandler callbackHandler, boolean plus, Map<String, ?> props, MessageDigest messageDigest, Mac mac, SecureRandom secureRandom, String bindingType, byte[] bindingData) {
        super(mechanismName, protocol, serverName, callbackHandler);
        this.messageDigest = messageDigest;
        this.mac = mac;
        this.minimumIterationCount = this.getIntProperty(props, "wildfly.sasl.scram.min-iteration-count", 4096);
        this.maximumIterationCount = this.getIntProperty(props, "wildfly.sasl.scram.max-iteration-count", 32768);
        this.secureRandom = secureRandom;
        this.plus = plus;
        this.bindingType = bindingType;
        this.bindingData = bindingData;
    }

    @Override
    public void init() {
        this.setNegotiationState(1);
    }

    @Override
    public String getAuthorizationID() {
        return this.authorizationID;
    }

    /*
     * Exception decompiling
     */
    @Override
    protected byte[] evaluateMessage(int state, byte[] response) throws SaslException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [12[CASE], 7[SWITCH]], but top level block is 6[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void parseAuthorizationId(ByteIterator bindingIterator) throws SaslException {
        if (bindingIterator.next() != 44) {
            throw ElytronMessages.log.saslInvalidClientMessage(this.getMechanismName());
        }
        switch (bindingIterator.next()) {
            case 44: {
                if (this.authorizationID == null) break;
                throw ElytronMessages.log.saslInvalidClientMessage(this.getMechanismName());
            }
            case 97: {
                if (bindingIterator.next() != 61) {
                    throw ElytronMessages.log.saslInvalidClientMessage(this.getMechanismName());
                }
                if (!bindingIterator.delimitedBy(44).asUtf8String().drainToString().equals(this.authorizationID)) {
                    throw ElytronMessages.log.saslInvalidClientMessage(this.getMechanismName());
                }
                if (bindingIterator.next() == 44) break;
                throw ElytronMessages.log.saslInvalidClientMessage(this.getMechanismName());
            }
            default: {
                throw ElytronMessages.log.saslInvalidClientMessage(this.getMechanismName());
            }
        }
    }

    private void getPredigestedSaltedPassword(NameCallback nameCallback) throws SaslException {
        CredentialCallback credentialCallback = new CredentialCallback(ScramDigestPassword.class);
        try {
            this.tryHandleCallbacks(nameCallback, credentialCallback);
        }
        catch (UnsupportedCallbackException e) {
            Callback callback = e.getCallback();
            if (callback == nameCallback) {
                throw ElytronMessages.log.saslCallbackHandlerDoesNotSupportUserName(this.getMechanismName(), e);
            }
            if (callback == credentialCallback) {
                return;
            }
            throw ElytronMessages.log.saslCallbackHandlerFailedForUnknownReason(this.getMechanismName(), e);
        }
        Password password = (Password)credentialCallback.getCredential();
        if (password != null) {
            this.iterationCount = ((ScramDigestPassword)password).getIterationCount();
            this.salt = ((ScramDigestPassword)password).getSalt();
            if (this.iterationCount < this.minimumIterationCount) {
                throw ElytronMessages.log.saslIterationCountIsTooLow(this.getMechanismName(), this.iterationCount, this.minimumIterationCount);
            }
            if (this.iterationCount > this.maximumIterationCount) {
                throw ElytronMessages.log.saslIterationCountIsTooHigh(this.getMechanismName(), this.iterationCount, this.maximumIterationCount);
            }
            if (this.salt == null) {
                throw ElytronMessages.log.saslSaltMustBeSpecified(this.getMechanismName());
            }
            this.saltedPassword = ((ScramDigestPassword)password).getDigest();
        }
    }

    private void getSaltedPasswordFromTwoWay(NameCallback nameCallback, ByteStringBuilder b) throws SaslException {
        CredentialCallback credentialCallback = new CredentialCallback(TwoWayPassword.class);
        ParameterCallback parameterCallback = new ParameterCallback(HashedPasswordAlgorithmSpec.class);
        try {
            this.tryHandleCallbacks(nameCallback, parameterCallback, credentialCallback);
            this.algorithmSpec = (HashedPasswordAlgorithmSpec)parameterCallback.getParameterSpec();
            if (this.algorithmSpec == null) {
                throw new FastUnsupportedCallbackException(parameterCallback);
            }
        }
        catch (UnsupportedCallbackException e) {
            Callback callback = e.getCallback();
            if (callback == nameCallback) {
                throw ElytronMessages.log.saslCallbackHandlerDoesNotSupportUserName(this.getMechanismName(), e);
            }
            if (callback == credentialCallback) {
                return;
            }
            if (callback == parameterCallback) {
                this.salt = ScramUtil.generateSalt(16, this.getRandom());
                this.algorithmSpec = new HashedPasswordAlgorithmSpec(this.minimumIterationCount, this.salt);
                try {
                    this.tryHandleCallbacks(nameCallback, credentialCallback);
                }
                catch (UnsupportedCallbackException ex) {
                    callback = ex.getCallback();
                    if (callback == nameCallback) {
                        throw ElytronMessages.log.saslCallbackHandlerDoesNotSupportUserName(this.getMechanismName(), ex);
                    }
                    if (callback == credentialCallback) {
                        return;
                    }
                    throw ElytronMessages.log.saslCallbackHandlerFailedForUnknownReason(this.getMechanismName(), ex);
                }
            }
            throw ElytronMessages.log.saslCallbackHandlerDoesNotSupportCredentialAcquisition(this.getMechanismName(), e);
        }
        TwoWayPassword password = (TwoWayPassword)credentialCallback.getCredential();
        char[] passwordChars = ScramUtil.getTwoWayPasswordChars(this.getMechanismName(), password);
        this.getSaltedPasswordFromPasswordChars(passwordChars, b);
    }

    private void getSaltedPasswordFromPasswordCallback(NameCallback nameCallback, ByteStringBuilder b) throws SaslException {
        PasswordCallback passwordCallback = new PasswordCallback("User password", false);
        try {
            this.tryHandleCallbacks(nameCallback, passwordCallback);
        }
        catch (UnsupportedCallbackException e) {
            Callback callback = e.getCallback();
            if (callback == nameCallback) {
                throw ElytronMessages.log.saslCallbackHandlerDoesNotSupportUserName(this.getMechanismName(), e);
            }
            if (callback == passwordCallback) {
                return;
            }
            throw ElytronMessages.log.saslCallbackHandlerFailedForUnknownReason(this.getMechanismName(), e);
        }
        this.salt = ScramUtil.generateSalt(16, this.getRandom());
        this.algorithmSpec = new HashedPasswordAlgorithmSpec(this.minimumIterationCount, this.salt);
        char[] passwordChars = passwordCallback.getPassword();
        passwordCallback.clearPassword();
        this.getSaltedPasswordFromPasswordChars(passwordChars, b);
    }

    private void getSaltedPasswordFromPasswordChars(char[] passwordChars, ByteStringBuilder b) throws SaslException {
        StringPrep.encode(passwordChars, b, 16383L);
        Arrays.fill(passwordChars, '\u0000');
        passwordChars = new String(b.toArray(), StandardCharsets.UTF_8).toCharArray();
        b.setLength(0);
        this.iterationCount = this.algorithmSpec.getIterationCount();
        this.salt = this.algorithmSpec.getSalt();
        if (this.iterationCount < this.minimumIterationCount) {
            throw ElytronMessages.log.saslIterationCountIsTooLow(this.getMechanismName(), this.iterationCount, this.minimumIterationCount);
        }
        if (this.iterationCount > this.maximumIterationCount) {
            throw ElytronMessages.log.saslIterationCountIsTooHigh(this.getMechanismName(), this.iterationCount, this.maximumIterationCount);
        }
        if (this.salt == null) {
            throw ElytronMessages.log.saslSaltMustBeSpecified(this.getMechanismName());
        }
        try {
            this.saltedPassword = ScramUtil.calculateHi(this.mac, passwordChars, this.salt, 0, this.salt.length, this.iterationCount);
            Arrays.fill(passwordChars, '\u0000');
        }
        catch (InvalidKeyException e) {
            throw ElytronMessages.log.saslInvalidMacInitializationKey(this.getMechanismName());
        }
    }

    private Random getRandom() {
        return this.secureRandom != null ? this.secureRandom : ThreadLocalRandom.current();
    }

    @Override
    public void dispose() throws SaslException {
        this.clientFirstMessage = null;
        this.serverFirstMessage = null;
        this.saltedPassword = null;
        this.setNegotiationState(-1);
        this.mac.reset();
        this.messageDigest.reset();
    }
}

