/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.sasl.gs2;

import java.util.Map;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.SaslException;
import org.ietf.jgss.ChannelBinding;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;
import org.wildfly.common.Assert;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.asn1.DERDecoder;
import org.wildfly.security.auth.callback.CredentialCallback;
import org.wildfly.security.sasl.gs2.Gs2;
import org.wildfly.security.sasl.gs2.Gs2Util;
import org.wildfly.security.sasl.util.AbstractSaslClient;
import org.wildfly.security.sasl.util.StringPrep;
import org.wildfly.security.util.ByteIterator;
import org.wildfly.security.util.ByteStringBuilder;

final class Gs2SaslClient
extends AbstractSaslClient {
    private static final int ST_INITIAL_CHALLENGE = 1;
    private static final int ST_CHALLENGE_RESPONSE = 2;
    private final boolean plus;
    private final byte[] bindingData;
    private final String bindingType;
    private final Oid mechanism;
    private final GSSManager gssManager;
    private GSSContext gssContext;
    private ByteStringBuilder gs2HeaderExcludingNonStdFlag;

    Gs2SaslClient(String mechanismName, String protocol, String serverName, CallbackHandler callbackHandler, String authorizationId, Map<String, ?> props, GSSManager gssManager, boolean plus, String bindingType, byte[] bindingData) throws SaslException {
        super(mechanismName, protocol, serverName, callbackHandler, authorizationId, true);
        GSSName acceptorName;
        this.bindingType = bindingType;
        this.plus = plus;
        this.bindingData = bindingData;
        this.gssManager = gssManager;
        try {
            this.mechanism = Gs2.getMechanismForSaslName(mechanismName);
        }
        catch (GSSException e) {
            throw ElytronMessages.log.saslMechanismToOidMappingFailed(this.getMechanismName(), e);
        }
        String acceptorNameStr = protocol + "@" + serverName;
        try {
            acceptorName = gssManager.createName(acceptorNameStr, GSSName.NT_HOSTBASED_SERVICE, this.mechanism);
        }
        catch (GSSException e) {
            throw ElytronMessages.log.saslUnableToCreateNameForAcceptor(this.getMechanismName(), e);
        }
        GSSCredential credential = null;
        CredentialCallback credentialCallback = new CredentialCallback(GSSCredential.class);
        try {
            this.tryHandleCallbacks(credentialCallback);
            credential = (GSSCredential)credentialCallback.getCredential();
        }
        catch (UnsupportedCallbackException unsupportedCallbackException) {
            // empty catch block
        }
        try {
            this.gssContext = gssManager.createContext(acceptorName, this.mechanism, credential, Integer.MAX_VALUE);
        }
        catch (GSSException e) {
            throw ElytronMessages.log.saslUnableToCreateGssContext(this.getMechanismName(), e);
        }
        try {
            boolean delegateCredential;
            boolean bl = delegateCredential = credential != null;
            if (props.containsKey("wildfly.sasl.gs2.client.delegate-credential")) {
                delegateCredential = Boolean.parseBoolean((String)props.get("wildfly.sasl.gs2.client.delegate-credential"));
            }
            this.gssContext.requestCredDeleg(delegateCredential);
            this.gssContext.requestMutualAuth(true);
        }
        catch (GSSException e) {
            throw ElytronMessages.log.saslUnableToSetGssContextRequestFlags(this.getMechanismName(), e);
        }
        this.gs2HeaderExcludingNonStdFlag = this.createGs2HeaderExcludingNonStdFlag();
        try {
            boolean gs2CbFlagPUsed = bindingData != null && plus;
            ChannelBinding channelBinding = Gs2Util.createChannelBinding(this.gs2HeaderExcludingNonStdFlag, gs2CbFlagPUsed, bindingData);
            this.gssContext.setChannelBinding(channelBinding);
        }
        catch (GSSException e) {
            throw ElytronMessages.log.saslUnableToSetChannelBinding(this.getMechanismName(), e);
        }
    }

    @Override
    public void dispose() throws SaslException {
        try {
            this.gssContext.dispose();
        }
        catch (GSSException e) {
            throw ElytronMessages.log.saslUnableToDisposeGssContext(this.getMechanismName(), e);
        }
        finally {
            this.gssContext = null;
        }
    }

    @Override
    public void init() {
        this.setNegotiationState(1);
    }

    @Override
    protected byte[] evaluateMessage(int state, byte[] challenge) throws SaslException {
        switch (state) {
            case 1: {
                assert (!this.gssContext.isEstablished());
                if (challenge != null && challenge.length != 0) {
                    throw ElytronMessages.log.saslInitialChallengeMustBeEmpty(this.getMechanismName());
                }
                try {
                    byte[] response = this.gssContext.initSecContext(NO_BYTES, 0, 0);
                    assert (!this.gssContext.isEstablished());
                    this.setNegotiationState(2);
                    return this.modifyInitialContextToken(response);
                }
                catch (GSSException e) {
                    throw ElytronMessages.log.saslUnableToCreateResponseTokenWithCause(this.getMechanismName(), e);
                }
            }
            case 2: {
                assert (!this.gssContext.isEstablished());
                try {
                    byte[] response = this.gssContext.initSecContext(challenge, 0, challenge.length);
                    if (this.gssContext.isEstablished()) {
                        if (!this.gssContext.getMutualAuthState()) {
                            throw ElytronMessages.log.saslMutualAuthenticationNotEnabled(this.getMechanismName());
                        }
                        this.negotiationComplete();
                    }
                    return response;
                }
                catch (GSSException e) {
                    throw ElytronMessages.log.saslUnableToCreateResponseTokenWithCause(this.getMechanismName(), e);
                }
            }
        }
        throw Assert.impossibleSwitchCase((int)state);
    }

    private ByteStringBuilder createGs2HeaderExcludingNonStdFlag() {
        ByteStringBuilder header = new ByteStringBuilder();
        if (this.bindingData != null) {
            if (this.plus) {
                header.append("p=");
                header.append(this.bindingType);
                header.append(',');
            } else {
                header.append("y,");
            }
        } else {
            header.append("n,");
        }
        String authorizationId = this.getAuthorizationId();
        if (authorizationId != null) {
            header.append("a=");
            StringPrep.encode(authorizationId, header, 2147500031L);
        }
        header.append(",");
        return header;
    }

    private byte[] modifyInitialContextToken(byte[] token) throws GSSException {
        boolean nonStandard = false;
        if (token[0] == 96) {
            ByteIterator bi = ByteIterator.ofBytes(token);
            DERDecoder decoder = new DERDecoder(bi);
            decoder.decodeImplicit(64, 0);
            decoder.startSequence();
            String decodedOid = decoder.decodeObjectIdentifier();
            if (!this.mechanism.equals(new Oid(decodedOid))) {
                throw new GSSException(10);
            }
            token = bi.drain();
        } else {
            nonStandard = true;
        }
        ByteStringBuilder modifiedToken = new ByteStringBuilder();
        if (nonStandard) {
            modifiedToken.append("F,");
        }
        modifiedToken.append(this.gs2HeaderExcludingNonStdFlag);
        modifiedToken.append(token);
        return modifiedToken.toArray();
    }
}

