/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.provider.ldap;

import java.util.EnumSet;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.security.auth.callback.CallbackHandler;

public interface DirContextFactory {
    public DirContext obtainDirContext(ReferralMode var1) throws NamingException;

    public DirContext obtainDirContext(CallbackHandler var1, ReferralMode var2) throws NamingException;

    public void returnContext(DirContext var1);

    public static enum ReferralMode {
        IGNORE("ignore"),
        FOLLOW("follow"),
        THROW("throw");

        private final String value;
        private static final int fullSize;

        private ReferralMode(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public static boolean isFull(EnumSet<ReferralMode> set) {
            return set != null && set.size() == fullSize;
        }

        public boolean in(ReferralMode v1) {
            return this == v1;
        }

        public boolean in(ReferralMode v1, ReferralMode v2) {
            return this == v1 || this == v2;
        }

        public boolean in(ReferralMode v1, ReferralMode v2, ReferralMode v3) {
            return this == v1 || this == v2 || this == v3;
        }

        public boolean in(ReferralMode ... values) {
            if (values != null) {
                for (ReferralMode value : values) {
                    if (this != value) continue;
                    return true;
                }
            }
            return false;
        }

        static {
            fullSize = ReferralMode.values().length;
        }
    }
}

