/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.client;

import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSocket;
import org.wildfly.security.auth.client.AuthenticationConfiguration;
import org.wildfly.security.ssl.CipherSuiteSelector;

class CipherSuiteSelectorAuthenticationConfiguration
extends AuthenticationConfiguration {
    private final CipherSuiteSelector cipherSuiteSelector;

    CipherSuiteSelectorAuthenticationConfiguration(AuthenticationConfiguration parent, CipherSuiteSelector cipherSuiteSelector) {
        super(parent);
        this.cipherSuiteSelector = cipherSuiteSelector;
    }

    @Override
    AuthenticationConfiguration reparent(AuthenticationConfiguration newParent) {
        return new CipherSuiteSelectorAuthenticationConfiguration(newParent, this.cipherSuiteSelector);
    }

    @Override
    CipherSuiteSelector getCipherSuiteSelector() {
        return this.cipherSuiteSelector;
    }

    @Override
    void configureSslEngine(SSLEngine sslEngine) {
        super.configureSslEngine(sslEngine);
        SSLParameters sslParameters = sslEngine.getSSLParameters();
        sslParameters.setUseCipherSuitesOrder(true);
        sslEngine.setSSLParameters(sslParameters);
        sslEngine.setEnabledCipherSuites(this.cipherSuiteSelector.evaluate(sslEngine.getSupportedCipherSuites()));
    }

    @Override
    void configureSslSocket(SSLSocket sslSocket) {
        super.configureSslSocket(sslSocket);
        sslSocket.setEnabledCipherSuites(this.cipherSuiteSelector.evaluate(sslSocket.getSupportedCipherSuites()));
    }
}

