/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.ssl;

import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocketFactory;
import org.wildfly.security.ssl.AbstractDelegatingSSLContextSpi;
import org.wildfly.security.ssl.CipherSuiteSelector;
import org.wildfly.security.ssl.ConfiguredSSLEngine;
import org.wildfly.security.ssl.ConfiguredSSLSocketFactory;
import org.wildfly.security.ssl.ProtocolSelector;

final class ConfiguredSSLContextSpi
extends AbstractDelegatingSSLContextSpi {
    private volatile ProtocolSelector protocolSelector;
    private volatile CipherSuiteSelector cipherSuiteSelector;

    ConfiguredSSLContextSpi(SSLContext delegate, ProtocolSelector protocolSelector, CipherSuiteSelector cipherSuiteSelector) {
        super(delegate);
        if (protocolSelector == null) {
            throw new IllegalArgumentException("protocolSelector is null");
        }
        if (cipherSuiteSelector == null) {
            throw new IllegalArgumentException("cipherSuiteSelector is null");
        }
        this.protocolSelector = protocolSelector;
        this.cipherSuiteSelector = cipherSuiteSelector;
    }

    @Override
    protected SSLSocketFactory engineGetSocketFactory() {
        return new ConfiguredSSLSocketFactory(super.engineGetSocketFactory(), this);
    }

    @Override
    protected SSLServerSocketFactory engineGetServerSocketFactory() {
        return super.engineGetServerSocketFactory();
    }

    @Override
    protected SSLEngine engineCreateSSLEngine() {
        return new ConfiguredSSLEngine(super.engineCreateSSLEngine(), this.protocolSelector, this.cipherSuiteSelector);
    }

    @Override
    protected SSLEngine engineCreateSSLEngine(String host, int port) {
        return new ConfiguredSSLEngine(super.engineCreateSSLEngine(host, port), this.protocolSelector, this.cipherSuiteSelector);
    }

    ProtocolSelector getProtocolSelector() {
        return this.protocolSelector;
    }

    void setProtocolSelector(ProtocolSelector protocolSelector) {
        if (protocolSelector == null) {
            throw new IllegalArgumentException("protocolSelector is null");
        }
        this.protocolSelector = protocolSelector;
    }

    CipherSuiteSelector getCipherSuiteSelector() {
        return this.cipherSuiteSelector;
    }

    void setCipherSuiteSelector(CipherSuiteSelector cipherSuiteSelector) {
        if (cipherSuiteSelector == null) {
            throw new IllegalArgumentException("cipherSuiteSelector is null");
        }
        this.cipherSuiteSelector = cipherSuiteSelector;
    }
}

