/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.sasl.util;

import java.lang.reflect.UndeclaredThrowableException;
import java.security.PrivilegedActionException;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;
import org.wildfly.security.ParametricPrivilegedExceptionAction;
import org.wildfly.security.auth.AuthenticationContext;
import org.wildfly.security.sasl.util.AbstractDelegatingSaslClient;

public final class AuthenticationContextSaslClient
extends AbstractDelegatingSaslClient {
    private AuthenticationContext context;
    private ParametricPrivilegedExceptionAction<byte[], byte[]> challengeAction = new ParametricPrivilegedExceptionAction<byte[], byte[]>(){

        @Override
        public byte[] run(byte[] parameter) throws Exception {
            return AuthenticationContextSaslClient.this.delegate.evaluateChallenge(parameter);
        }
    };

    public AuthenticationContextSaslClient(SaslClient delegate, AuthenticationContext context) {
        super(delegate);
        this.context = context;
    }

    public AuthenticationContextSaslClient(SaslClient delegate) {
        super(delegate);
        this.context = AuthenticationContext.captureCurrent();
    }

    @Override
    public byte[] evaluateChallenge(byte[] challenge) throws SaslException {
        try {
            return this.context.run(challenge, this.challengeAction);
        }
        catch (PrivilegedActionException e) {
            try {
                throw e.getCause();
            }
            catch (Error | RuntimeException | SaslException rethrow) {
                throw rethrow;
            }
            catch (Throwable throwable) {
                throw new UndeclaredThrowableException(throwable);
            }
        }
    }

    @Override
    public void dispose() throws SaslException {
        try {
            super.dispose();
        }
        finally {
            this.context = null;
            this.challengeAction = null;
        }
    }
}

