/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.sasl.scram;

import java.security.InvalidKeyException;
import java.util.Random;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.wildfly.security.sasl.util.StringPrep;
import org.wildfly.security.util.ByteIterator;
import org.wildfly.security.util.ByteStringBuilder;

class ScramUtil {
    private static final byte[] randomCharDictionary;

    ScramUtil() {
    }

    public static byte[] generateNonce(int length, Random random) {
        byte[] chars = new byte[length];
        for (int i = 0; i < length; ++i) {
            chars[i] = randomCharDictionary[random.nextInt(93)];
        }
        return chars;
    }

    public static byte[] generateSalt(int length, Random random) {
        byte[] bytes = new byte[length];
        random.nextBytes(bytes);
        return bytes;
    }

    public static int parsePosInt(ByteIterator i) {
        int a;
        if (!i.hasNext()) {
            throw new NumberFormatException("Empty number");
        }
        int c = i.next();
        if (c >= 49 && c <= 57) {
            a = c - 48;
        } else {
            throw new NumberFormatException("Invalid numeric character");
        }
        while (i.hasNext()) {
            c = i.next();
            if (c >= 48 && c <= 57) {
                if ((a = (a << 3) + (a << 1) + (c - 48)) >= 0) continue;
                throw new NumberFormatException("Too big");
            }
            throw new NumberFormatException("Invalid numeric character");
        }
        return a;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] calculateHi(Mac mac, char[] password, byte[] salt, int saltOffs, int saltLen, int iterationCount) throws InvalidKeyException {
        try {
            byte[] h;
            ByteStringBuilder b = new ByteStringBuilder();
            StringPrep.encode(password, b, 8191L);
            mac.init(new SecretKeySpec(b.toArray(), mac.getAlgorithm()));
            mac.update(salt, saltOffs, saltLen);
            mac.update((byte)0);
            mac.update((byte)0);
            mac.update((byte)0);
            mac.update((byte)1);
            byte[] u = h = mac.doFinal();
            for (int i = 2; i <= iterationCount; ++i) {
                u = mac.doFinal(u);
                ScramUtil.xor(h, u);
            }
            byte[] byArray = h;
            return byArray;
        }
        finally {
            mac.reset();
        }
    }

    static void xor(byte[] hash, byte[] input) {
        assert (hash.length == input.length);
        for (int i = 0; i < hash.length; ++i) {
            int n = i;
            hash[n] = (byte)(hash[n] ^ input[i]);
        }
    }

    static {
        int c;
        byte[] dict = new byte[93];
        int i = 0;
        for (c = 33; c < 44; c = (int)((byte)(c + 1))) {
            dict[i++] = c;
        }
        for (c = 45; c < 127; c = (int)((byte)(c + 1))) {
            dict[i++] = c;
        }
        assert (i == dict.length);
        randomCharDictionary = dict;
    }
}

