/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.sasl.external;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.text.Normalizer;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.sasl.util.AbstractSaslParticipant;
import org.wildfly.security.util._private.Arrays2;

final class ExternalSaslServer
implements SaslServer {
    private final CallbackHandler cbh;
    private boolean complete;
    private String authorizationID;

    ExternalSaslServer(CallbackHandler cbh) {
        this.cbh = cbh;
    }

    @Override
    public String getMechanismName() {
        return "EXTERNAL";
    }

    @Override
    public byte[] evaluateResponse(byte[] response) throws SaslException {
        String authorizationId;
        if (this.complete) {
            throw ElytronMessages.log.saslMessageAfterComplete();
        }
        this.complete = true;
        if (response.length == 0) {
            authorizationId = null;
        } else {
            try {
                authorizationId = Normalizer.normalize(new String(response, "UTF-8"), Normalizer.Form.NFKC);
                if (authorizationId.indexOf(0) != -1) {
                    throw ElytronMessages.log.saslUserNameContainsInvalidCharacter();
                }
            }
            catch (UnsupportedEncodingException e) {
                throw ElytronMessages.log.saslUserNameDecodeFailed("UTF-8");
            }
        }
        AuthorizeCallback authorizeCallback = new AuthorizeCallback(null, authorizationId);
        try {
            this.cbh.handle(Arrays2.of(authorizeCallback));
        }
        catch (SaslException e) {
            throw e;
        }
        catch (IOException e) {
            throw ElytronMessages.log.saslAuthorizationFailed(e);
        }
        catch (UnsupportedCallbackException e) {
            throw ElytronMessages.log.saslAuthorizationFailed(null);
        }
        if (!authorizeCallback.isAuthorized()) {
            throw ElytronMessages.log.saslAuthorizationFailed(null);
        }
        this.authorizationID = authorizeCallback.getAuthorizedID();
        return AbstractSaslParticipant.NO_BYTES;
    }

    @Override
    public boolean isComplete() {
        return this.complete;
    }

    @Override
    public String getAuthorizationID() {
        if (!this.complete) {
            throw ElytronMessages.log.saslAuthenticationNotComplete();
        }
        return this.authorizationID;
    }

    @Override
    public byte[] unwrap(byte[] incoming, int offset, int len) throws SaslException {
        if (this.complete) {
            throw ElytronMessages.log.saslNoSecurityLayer();
        }
        throw ElytronMessages.log.saslAuthenticationNotComplete();
    }

    @Override
    public byte[] wrap(byte[] outgoing, int offset, int len) throws SaslException {
        if (this.complete) {
            throw ElytronMessages.log.saslNoSecurityLayer();
        }
        throw ElytronMessages.log.saslAuthenticationNotComplete();
    }

    @Override
    public Object getNegotiatedProperty(String propName) {
        return null;
    }

    @Override
    public void dispose() throws SaslException {
    }
}

