/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.keystore;

import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableEntryException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.wildfly.security.keystore.DelegatingKeyStoreSpi;
import org.wildfly.security.keystore.PasswordEntry;
import org.wildfly.security.password.Password;
import org.wildfly.security.password.PasswordFactory;
import org.wildfly.security.password.spec.ClearPasswordSpec;

final class WrappingPasswordKeyStoreSpiImpl
extends DelegatingKeyStoreSpi {
    private final KeyStore delegate;

    WrappingPasswordKeyStoreSpiImpl(KeyStore delegate) {
        this.delegate = delegate;
    }

    @Override
    public Key engineGetKey(String alias, char[] password) throws NoSuchAlgorithmException, UnrecoverableKeyException {
        try {
            Key key = this.delegate.getKey(alias, password);
            return key instanceof SecretKey ? WrappingPasswordKeyStoreSpiImpl.decoded((SecretKey)key) : null;
        }
        catch (KeyStoreException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public Certificate[] engineGetCertificateChain(String alias) {
        return null;
    }

    @Override
    public Certificate engineGetCertificate(String alias) {
        return null;
    }

    @Override
    public void engineSetKeyEntry(String alias, Key key, char[] password, Certificate[] chain) throws KeyStoreException {
        if (!(key instanceof Password)) {
            throw new KeyStoreException("Secret keys not supported");
        }
        this.engineSetEntry(alias, new PasswordEntry((Password)key), password == null ? null : new KeyStore.PasswordProtection(password));
    }

    @Override
    public void engineSetKeyEntry(String alias, byte[] key, Certificate[] chain) throws KeyStoreException {
        throw new KeyStoreException("Direct key storage not supported");
    }

    @Override
    public void engineSetCertificateEntry(String alias, Certificate cert) throws KeyStoreException {
        throw new KeyStoreException("Direct key storage not supported");
    }

    @Override
    public KeyStore.Entry engineGetEntry(String alias, KeyStore.ProtectionParameter protParam) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableEntryException {
        KeyStore.Entry entry = super.engineGetEntry(alias, protParam);
        if (entry instanceof KeyStore.SecretKeyEntry) {
            return new PasswordEntry(WrappingPasswordKeyStoreSpiImpl.decoded(((KeyStore.SecretKeyEntry)entry).getSecretKey()));
        }
        return entry;
    }

    @Override
    public void engineSetEntry(String alias, KeyStore.Entry entry, KeyStore.ProtectionParameter protParam) throws KeyStoreException {
        if (!(entry instanceof PasswordEntry)) {
            throw new KeyStoreException("Only password storage is supported");
        }
        try {
            this.delegate.setEntry(alias, new KeyStore.SecretKeyEntry(WrappingPasswordKeyStoreSpiImpl.encoded(((PasswordEntry)entry).getPassword())), protParam);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw new KeyStoreException(e);
        }
    }

    @Override
    public boolean engineEntryInstanceOf(String alias, Class<? extends KeyStore.Entry> entryClass) {
        try {
            return entryClass == PasswordEntry.class && this.delegate.entryInstanceOf(alias, KeyStore.SecretKeyEntry.class);
        }
        catch (KeyStoreException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public boolean engineIsCertificateEntry(String alias) {
        return false;
    }

    @Override
    public String engineGetCertificateAlias(Certificate cert) {
        return null;
    }

    private static Password decoded(SecretKey key) throws NoSuchAlgorithmException, KeyStoreException {
        PasswordFactory passwordFactory = PasswordFactory.getInstance("clear");
        try {
            return passwordFactory.generatePassword(new ClearPasswordSpec(new String(key.getEncoded(), StandardCharsets.UTF_8).toCharArray()));
        }
        catch (InvalidKeySpecException e) {
            throw new KeyStoreException(e);
        }
    }

    private static SecretKey encoded(Password password) throws InvalidKeySpecException, NoSuchAlgorithmException {
        PasswordFactory factory = PasswordFactory.getInstance("clear");
        ClearPasswordSpec spec = factory.getKeySpec(password, ClearPasswordSpec.class);
        char[] encodedPassword = spec.getEncodedPassword();
        return new SecretKeySpec(new String(encodedPassword).getBytes(StandardCharsets.UTF_8), "password");
    }

    @Override
    protected KeyStore getKeyStore() {
        return this.delegate;
    }
}

