/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.Principal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslClientFactory;
import javax.security.sasl.SaslException;
import org.wildfly.security.FixedSecurityFactory;
import org.wildfly.security.auth.FilterSaslMechanismAuthenticationConfiguration;
import org.wildfly.security.auth.RewriteNameAuthenticationConfiguration;
import org.wildfly.security.auth.SetAnonymousAuthenticationConfiguration;
import org.wildfly.security.auth.SetAuthorizationNameAuthenticationConfiguration;
import org.wildfly.security.auth.SetCallbackHandlerAuthenticationConfiguration;
import org.wildfly.security.auth.SetHostAuthenticationConfiguration;
import org.wildfly.security.auth.SetKeyStoreCredentialAuthenticationConfiguration;
import org.wildfly.security.auth.SetNamePrincipalAuthenticationConfiguration;
import org.wildfly.security.auth.SetPasswordAuthenticationConfiguration;
import org.wildfly.security.auth.SetPasswordCallbackHandlerAuthenticationConfiguration;
import org.wildfly.security.auth.SetPortAuthenticationConfiguration;
import org.wildfly.security.auth.callback.CallbackUtil;
import org.wildfly.security.auth.principal.AnonymousPrincipal;
import org.wildfly.security.auth.principal.NamePrincipal;
import org.wildfly.security.auth.util.NameRewriter;
import org.wildfly.security.password.Password;
import org.wildfly.security.password.PasswordFactory;
import org.wildfly.security.password.spec.ClearPasswordSpec;

public abstract class AuthenticationConfiguration {
    public static final AuthenticationConfiguration EMPTY = new AuthenticationConfiguration(){

        @Override
        void handleCallback(Callback[] callbacks, int index) throws UnsupportedCallbackException {
            CallbackUtil.unsupported(callbacks[index]);
        }

        @Override
        void handleCallbacks(AuthenticationConfiguration config, Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            int length = callbacks.length;
            for (int i = 0; i < length; ++i) {
                config.handleCallback(callbacks, i);
            }
        }

        @Override
        void configureSaslProperties(Map<String, Object> properties) {
        }

        @Override
        void filterSaslMechanisms(Collection<String> names) {
        }

        @Override
        String doRewriteUser(String original) {
            return original;
        }

        @Override
        AuthenticationConfiguration reparent(AuthenticationConfiguration newParent) {
            return this;
        }

        @Override
        AuthenticationConfiguration without(Class<? extends AuthenticationConfiguration> clazz) {
            return this;
        }

        @Override
        String getHost(URI uri) {
            return uri.getHost();
        }

        @Override
        int getPort(URI uri) {
            return uri.getPort();
        }

        @Override
        Principal getPrincipal() {
            return AnonymousPrincipal.getInstance();
        }
    }.useAnonymous();
    private final AuthenticationConfiguration parent;
    private final CallbackHandler callbackHandler = new CallbackHandler(){

        @Override
        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            AuthenticationConfiguration.this.handleCallbacks(AuthenticationConfiguration.this, callbacks);
        }
    };

    AuthenticationConfiguration() {
        this.parent = null;
    }

    AuthenticationConfiguration(AuthenticationConfiguration parent) {
        this(parent, false);
    }

    AuthenticationConfiguration(AuthenticationConfiguration parent, boolean allowMultiple) {
        this.parent = allowMultiple ? parent : parent.without(this.getClass());
    }

    Principal getPrincipal() {
        return this.parent.getPrincipal();
    }

    String getHost(URI uri) {
        return this.parent.getHost(uri);
    }

    int getPort(URI uri) {
        return this.parent.getPort(uri);
    }

    void handleCallback(Callback[] callbacks, int index) throws IOException, UnsupportedCallbackException {
        this.parent.handleCallback(callbacks, index);
    }

    void handleCallbacks(AuthenticationConfiguration config, Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        this.parent.handleCallbacks(config, callbacks);
    }

    void configureSaslProperties(Map<String, Object> properties) {
        this.parent.configureSaslProperties(properties);
    }

    void filterSaslMechanisms(Collection<String> names) {
        this.parent.filterSaslMechanisms(names);
    }

    String doRewriteUser(String original) {
        return this.parent.doRewriteUser(original);
    }

    String getAuthorizationName() {
        return null;
    }

    abstract AuthenticationConfiguration reparent(AuthenticationConfiguration var1);

    AuthenticationConfiguration without(Class<? extends AuthenticationConfiguration> clazz) {
        if (clazz.isInstance(this)) {
            return this.parent;
        }
        AuthenticationConfiguration newParent = this.parent.without(clazz);
        if (this.parent == newParent) {
            return this;
        }
        return this.reparent(newParent);
    }

    public AuthenticationConfiguration rewriteUser(NameRewriter rewriter) {
        if (rewriter == null) {
            return this;
        }
        return new RewriteNameAuthenticationConfiguration(this, rewriter);
    }

    public AuthenticationConfiguration useAnonymous() {
        return new SetAnonymousAuthenticationConfiguration(this);
    }

    public AuthenticationConfiguration usePrincipal(NamePrincipal principal) {
        return new SetNamePrincipalAuthenticationConfiguration(this, principal);
    }

    public AuthenticationConfiguration useName(String name) {
        return this.usePrincipal(new NamePrincipal(name));
    }

    public AuthenticationConfiguration useAuthorizationName(String name) {
        return new SetAuthorizationNameAuthenticationConfiguration(this, name);
    }

    public AuthenticationConfiguration usePassword(Password password) {
        return password == null ? this : new SetPasswordAuthenticationConfiguration(this, password);
    }

    public AuthenticationConfiguration usePassword(char[] password) {
        try {
            return password == null ? this : this.usePassword(PasswordFactory.getInstance("clear").generatePassword(new ClearPasswordSpec(password)));
        }
        catch (GeneralSecurityException e) {
            throw new IllegalStateException();
        }
    }

    public AuthenticationConfiguration usePassword(String password) {
        return password == null ? this : this.usePassword(password.toCharArray());
    }

    public AuthenticationConfiguration usePasswordCallback(CallbackHandler callbackHandler) {
        return callbackHandler == null ? this : new SetPasswordCallbackHandlerAuthenticationConfiguration(this, callbackHandler);
    }

    public AuthenticationConfiguration useCallbackHandler(CallbackHandler callbackHandler) {
        return callbackHandler == null ? this : new SetCallbackHandlerAuthenticationConfiguration(this, callbackHandler);
    }

    public AuthenticationConfiguration useKeyStoreCredential(KeyStore.Entry keyStoreEntry) {
        return keyStoreEntry == null ? this : new SetKeyStoreCredentialAuthenticationConfiguration(this, new FixedSecurityFactory<KeyStore.Entry>(keyStoreEntry));
    }

    public AuthenticationConfiguration useKeyStoreCredential(KeyStore keyStore, String alias) {
        return keyStore == null || alias == null ? this : new SetKeyStoreCredentialAuthenticationConfiguration(this, keyStore, alias, null);
    }

    public AuthenticationConfiguration useKeyStoreCredential(KeyStore keyStore, String alias, KeyStore.ProtectionParameter protectionParameter) {
        return keyStore == null || alias == null ? this : new SetKeyStoreCredentialAuthenticationConfiguration(this, keyStore, alias, protectionParameter);
    }

    public AuthenticationConfiguration useHost(String hostName) {
        if (hostName != null && hostName.isEmpty()) {
            hostName = null;
        }
        return new SetHostAuthenticationConfiguration(this, hostName);
    }

    public AuthenticationConfiguration usePort(int port) {
        if (port < 1 || port > 65535) {
            throw new IllegalArgumentException("Invalid port " + port);
        }
        return new SetPortAuthenticationConfiguration(this, port);
    }

    public AuthenticationConfiguration allowSaslMechanisms(String ... names) {
        return names == null || names.length == 0 ? new FilterSaslMechanismAuthenticationConfiguration(this, true, Collections.emptySet()) : new FilterSaslMechanismAuthenticationConfiguration(this, true, new HashSet<String>(Arrays.asList(names)));
    }

    public AuthenticationConfiguration forbidSaslMechanisms(String ... names) {
        return names == null || names.length == 0 ? this : new FilterSaslMechanismAuthenticationConfiguration(this, false, new HashSet<String>(Arrays.asList(names)));
    }

    CallbackHandler getCallbackHandler() {
        return this.callbackHandler;
    }

    SaslClient createSaslClient(URI uri, SaslClientFactory clientFactory, Collection<String> serverMechanisms) throws SaslException {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        this.configureSaslProperties(properties);
        HashSet<String> mechs = new HashSet<String>(serverMechanisms);
        this.filterSaslMechanisms(mechs);
        String authorizationName = this.getAuthorizationName();
        CallbackHandler callbackHandler = this.getCallbackHandler();
        return clientFactory.createSaslClient(mechs.toArray(new String[mechs.size()]), authorizationName, uri.getScheme(), this.getHost(uri), properties, callbackHandler);
    }

    InetSocketAddress getDestinationInetAddress(URI uri, int defaultPort) {
        String host = this.getHost(uri);
        int port = this.getPort(uri);
        if (port == -1) {
            port = defaultPort;
        }
        return new InetSocketAddress(host, port);
    }
}

