/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.credential.store._private;

import java.io.IOException;
import java.io.Serializable;
import java.security.KeyStore;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.credential.store.CredentialStore;
import org.wildfly.security.credential.store.CredentialStoreException;
import org.wildfly.security.credential.store.UnsupportedCredentialTypeException;
import org.wildfly.security.credential.store._private.ElytronMessages;

public class ElytronMessages_$logger
extends DelegatingBasicLogger
implements ElytronMessages,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = ElytronMessages_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;
    private static final String unableToCreateKeyStore = "ELY02009: Unable to create a new KeyStore instance";
    private static final String wrongTypeOfExternalStorageKey = "ELY09500: External storage key under alias \"%s\" has to be a SecretKey";
    private static final String cannotAcquireCredentialFromStore = "ELY09504: Cannot acquire a credential from the credential store";
    private static final String nonModifiableCredentialStore = "ELY09505: Cannot perform operation '%s': Credential store is set non modifiable";
    private static final String invalidProtectionParameter = "ELY09507: Invalid protection parameter given: %s";
    private static final String cannotWriteCredentialToStore = "ELY09508: Cannot write credential to store";
    private static final String unsupportedCredentialType = "ELY09509: Unsupported credential type %s";
    private static final String invalidCredentialStoreEntryType = "ELY09510: Invalid credential store keystore entry %s: expected %s";
    private static final String unableToReadCredentialTypeFromStore = "ELY09511: Unable to read credential %s from store";
    private static final String cannotRemoveCredentialFromStore = "ELY09512: Unable to remove credential from store";
    private static final String cannotFlushCredentialStore = "ELY09513: Unable to flush credential store to storage";
    private static final String cannotInitializeCredentialStore = "ELY09514: Unable to initialize credential store";
    private static final String logIgnoredUnrecognizedKeyStoreEntry = "ELY09515: Ignored unrecognized key store entry \"%s\"";
    private static final String logFailedToReadKeyFromKeyStore = "ELY09516: Failed to read a credential entry from the key store";
    private static final String protectionParameterRequired = "ELY09517: This credential store type requires a store-wide protection parameter";
    private static final String automaticStorageCreationDisabled = "ELY09518: Automatic storage creation for the Credential Store is disabled \"%s\"";
    private static final String unexpectedFileVersion = "ELY09519: Unexpected credential store external storage file version \"%s\"";
    private static final String unrecognizedEntryType = "ELY09520: Unrecognized entry type \"%s\"";
    private static final String internalEncryptionProblem = "ELY09521: Internal encryption problem while reading \"%s\"";
    private static final String algorithmNotBlockBased = "ELY09522: \"%s\" is not a block based algorithm";
    private static final String algorithmNotIV = "ELY09523: Algorithm \"%s\" does not use an initialization vector (IV)";
    private static final String readBytesMismatch = "ELY09524: The actual number of bytes read %d is different from the expected number of bytes %d to be read";
    private static final String locationAndExternalPathAreIdentical = "ELY09525: location and externalPath initial attributes are the same. [location=%s, externalPath=%s]";
    private static final String unsupportedAttribute = "ELY09526: Unable to initialize credential store as attribute %s is unsupported in %s";
    private static final String externalPathMissing = "ELY09528: The externalPath attribute for key store type %s is missing.";
    private static final String externalStorageKeyDoesNotExist = "ELY11006: External storage key under alias \"%s\" does not exist";

    public ElytronMessages_$logger(Logger log) {
        super(log);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    protected String unableToCreateKeyStore$str() {
        return unableToCreateKeyStore;
    }

    @Override
    public final IOException unableToCreateKeyStore(Exception cause) {
        IOException result = new IOException(String.format(this.getLoggingLocale(), this.unableToCreateKeyStore$str(), new Object[0]), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String wrongTypeOfExternalStorageKey$str() {
        return wrongTypeOfExternalStorageKey;
    }

    @Override
    public final CredentialStoreException wrongTypeOfExternalStorageKey(String keyAlias) {
        CredentialStoreException result = new CredentialStoreException(String.format(this.getLoggingLocale(), this.wrongTypeOfExternalStorageKey$str(), keyAlias));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotAcquireCredentialFromStore$str() {
        return cannotAcquireCredentialFromStore;
    }

    @Override
    public final CredentialStoreException cannotAcquireCredentialFromStore(Throwable cause) {
        CredentialStoreException result = new CredentialStoreException(String.format(this.getLoggingLocale(), this.cannotAcquireCredentialFromStore$str(), new Object[0]), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String nonModifiableCredentialStore$str() {
        return nonModifiableCredentialStore;
    }

    @Override
    public final CredentialStoreException nonModifiableCredentialStore(String operation) {
        CredentialStoreException result = new CredentialStoreException(String.format(this.getLoggingLocale(), this.nonModifiableCredentialStore$str(), operation));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidProtectionParameter$str() {
        return invalidProtectionParameter;
    }

    @Override
    public final CredentialStoreException invalidProtectionParameter(CredentialStore.ProtectionParameter protectionParameter) {
        CredentialStoreException result = new CredentialStoreException(String.format(this.getLoggingLocale(), this.invalidProtectionParameter$str(), protectionParameter));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotWriteCredentialToStore$str() {
        return cannotWriteCredentialToStore;
    }

    @Override
    public final CredentialStoreException cannotWriteCredentialToStore(Throwable cause) {
        CredentialStoreException result = new CredentialStoreException(String.format(this.getLoggingLocale(), this.cannotWriteCredentialToStore$str(), new Object[0]), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unsupportedCredentialType$str() {
        return unsupportedCredentialType;
    }

    @Override
    public final UnsupportedCredentialTypeException unsupportedCredentialType(Class<?> type) {
        UnsupportedCredentialTypeException result = new UnsupportedCredentialTypeException(String.format(this.getLoggingLocale(), this.unsupportedCredentialType$str(), type));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidCredentialStoreEntryType$str() {
        return invalidCredentialStoreEntryType;
    }

    @Override
    public final CredentialStoreException invalidCredentialStoreEntryType(Class<? extends KeyStore.Entry> entryType, Class<? extends KeyStore.Entry> expectedType) {
        CredentialStoreException result = new CredentialStoreException(String.format(this.getLoggingLocale(), this.invalidCredentialStoreEntryType$str(), entryType, expectedType));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToReadCredentialTypeFromStore$str() {
        return unableToReadCredentialTypeFromStore;
    }

    @Override
    public final CredentialStoreException unableToReadCredentialTypeFromStore(Class<? extends Credential> credentialType) {
        CredentialStoreException result = new CredentialStoreException(String.format(this.getLoggingLocale(), this.unableToReadCredentialTypeFromStore$str(), credentialType));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotRemoveCredentialFromStore$str() {
        return cannotRemoveCredentialFromStore;
    }

    @Override
    public final CredentialStoreException cannotRemoveCredentialFromStore(Throwable cause) {
        CredentialStoreException result = new CredentialStoreException(String.format(this.getLoggingLocale(), this.cannotRemoveCredentialFromStore$str(), new Object[0]), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotFlushCredentialStore$str() {
        return cannotFlushCredentialStore;
    }

    @Override
    public final CredentialStoreException cannotFlushCredentialStore(Throwable cause) {
        CredentialStoreException result = new CredentialStoreException(String.format(this.getLoggingLocale(), this.cannotFlushCredentialStore$str(), new Object[0]), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotInitializeCredentialStore$str() {
        return cannotInitializeCredentialStore;
    }

    @Override
    public final CredentialStoreException cannotInitializeCredentialStore(Throwable cause) {
        CredentialStoreException result = new CredentialStoreException(String.format(this.getLoggingLocale(), this.cannotInitializeCredentialStore$str(), new Object[0]), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    @Override
    public final void logIgnoredUnrecognizedKeyStoreEntry(String alias) {
        this.log.logf(FQCN, Logger.Level.DEBUG, (Throwable)null, this.logIgnoredUnrecognizedKeyStoreEntry$str(), (Object)alias);
    }

    protected String logIgnoredUnrecognizedKeyStoreEntry$str() {
        return logIgnoredUnrecognizedKeyStoreEntry;
    }

    @Override
    public final void logFailedToReadKeyFromKeyStore(Throwable cause) {
        this.log.logf(FQCN, Logger.Level.WARN, cause, this.logFailedToReadKeyFromKeyStore$str(), new Object[0]);
    }

    protected String logFailedToReadKeyFromKeyStore$str() {
        return logFailedToReadKeyFromKeyStore;
    }

    protected String protectionParameterRequired$str() {
        return protectionParameterRequired;
    }

    @Override
    public final CredentialStoreException protectionParameterRequired() {
        CredentialStoreException result = new CredentialStoreException(String.format(this.getLoggingLocale(), this.protectionParameterRequired$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String automaticStorageCreationDisabled$str() {
        return automaticStorageCreationDisabled;
    }

    @Override
    public final CredentialStoreException automaticStorageCreationDisabled(String location) {
        CredentialStoreException result = new CredentialStoreException(String.format(this.getLoggingLocale(), this.automaticStorageCreationDisabled$str(), location));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unexpectedFileVersion$str() {
        return unexpectedFileVersion;
    }

    @Override
    public final IOException unexpectedFileVersion(String version) {
        IOException result = new IOException(String.format(this.getLoggingLocale(), this.unexpectedFileVersion$str(), version));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unrecognizedEntryType$str() {
        return unrecognizedEntryType;
    }

    @Override
    public final IOException unrecognizedEntryType(String entryType) {
        IOException result = new IOException(String.format(this.getLoggingLocale(), this.unrecognizedEntryType$str(), entryType));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String internalEncryptionProblem$str() {
        return internalEncryptionProblem;
    }

    @Override
    public final IOException internalEncryptionProblem(Exception e, String location) {
        IOException result = new IOException(String.format(this.getLoggingLocale(), this.internalEncryptionProblem$str(), location), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String algorithmNotBlockBased$str() {
        return algorithmNotBlockBased;
    }

    @Override
    public final CredentialStoreException algorithmNotBlockBased(String algorithm) {
        CredentialStoreException result = new CredentialStoreException(String.format(this.getLoggingLocale(), this.algorithmNotBlockBased$str(), algorithm));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String algorithmNotIV$str() {
        return algorithmNotIV;
    }

    @Override
    public final CredentialStoreException algorithmNotIV(String algorithm) {
        CredentialStoreException result = new CredentialStoreException(String.format(this.getLoggingLocale(), this.algorithmNotIV$str(), algorithm));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String readBytesMismatch$str() {
        return readBytesMismatch;
    }

    @Override
    public final IOException readBytesMismatch(int actual, int expected) {
        IOException result = new IOException(String.format(this.getLoggingLocale(), this.readBytesMismatch$str(), actual, expected));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String locationAndExternalPathAreIdentical$str() {
        return locationAndExternalPathAreIdentical;
    }

    @Override
    public final CredentialStoreException locationAndExternalPathAreIdentical(String location, String externalPath) {
        CredentialStoreException result = new CredentialStoreException(String.format(this.getLoggingLocale(), this.locationAndExternalPathAreIdentical$str(), location, externalPath));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unsupportedAttribute$str() {
        return unsupportedAttribute;
    }

    @Override
    public final CredentialStoreException unsupportedAttribute(String attribute, List<String> validAttribute) {
        CredentialStoreException result = new CredentialStoreException(String.format(this.getLoggingLocale(), this.unsupportedAttribute$str(), attribute, validAttribute));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String externalPathMissing$str() {
        return externalPathMissing;
    }

    @Override
    public final CredentialStoreException externalPathMissing(String keyStoreType) {
        CredentialStoreException result = new CredentialStoreException(String.format(this.getLoggingLocale(), this.externalPathMissing$str(), keyStoreType));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String externalStorageKeyDoesNotExist$str() {
        return externalStorageKeyDoesNotExist;
    }

    @Override
    public final CredentialStoreException externalStorageKeyDoesNotExist(String keyAlias) {
        CredentialStoreException result = new CredentialStoreException(String.format(this.getLoggingLocale(), this.externalStorageKeyDoesNotExist$str(), keyAlias));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
}

