/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.credential._private;

import java.io.EOFException;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.InvalidParameterSpecException;
import javax.security.sasl.SaslException;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;

@MessageLogger(projectCode="ELY", length=5)
public interface ElytronMessages
extends BasicLogger {
    public static final ElytronMessages log = Logger.getMessageLogger(ElytronMessages.class, "org.wildfly.security");
    public static final ElytronMessages tls = Logger.getMessageLogger(ElytronMessages.class, "org.wildfly.security.tls");

    @Message(id=2, value="Parameter %s is empty")
    public IllegalArgumentException emptyParameter(String var1);

    @Message(id=4, value="Unrecognized algorithm \"%s\"")
    public IllegalArgumentException unrecognizedAlgorithm(String var1);

    @Message(id=1037, value="Certificate chain is empty")
    public IllegalArgumentException certificateChainIsEmpty();

    @Message(id=1059, value="Public and private key algorithm names are mismatched")
    public IllegalArgumentException mismatchedPublicPrivateKeyAlgorithms();

    @Message(id=1061, value="Public key is null")
    public IllegalArgumentException publicKeyIsNull();

    @Message(id=1063, value="Private key is null")
    public IllegalArgumentException privateKeyIsNull();

    @Message(id=2001, value="Invalid key store entry password for alias \"%s\"")
    public UnrecoverableKeyException invalidKeyStoreEntryPassword(String var1);

    @Message(id=2002, value="Invalid key store entry type for alias \"%s\" (expected %s, got %s)")
    public KeyStoreException invalidKeyStoreEntryType(String var1, Class<?> var2, Class<?> var3);

    @Message(id=2003, value="Key store key for alias \"%s\" cannot be protected")
    public KeyStoreException keyCannotBeProtected(String var1);

    @Message(id=2004, value="Key store failed to translate password for alias \"%s\"")
    public IOException keyStoreFailedToTranslate(String var1, @Cause Throwable var2);

    @Message(id=2005, value="Key store failed to identify a suitable algorithm for alias \"%s\"")
    public NoSuchAlgorithmException noAlgorithmForPassword(String var1);

    @Message(id=2006, value="Unexpected whitespace in password file")
    public IOException unexpectedWhitespaceInPasswordFile();

    @Message(id=2007, value="Unexpected end of file")
    public EOFException unexpectedEof();

    @Message(id=2008, value="A reversible load is not possible until the KeyStore has first been initialized")
    public IllegalStateException reversibleLoadNotPossible();

    @Message(id=2009, value="Unable to create a new KeyStore instance")
    public IOException unableToCreateKeyStore(@Cause Exception var1);

    @Message(id=2012, value="An empty alias filter was supplied")
    public IllegalArgumentException emptyFilter();

    @Message(id=2013, value="Filter is missing '+' or '-' at offset %d")
    public IllegalArgumentException missingPlusMinusAt(long var1);

    @Message(id=2014, value="Invalid first word '%s', must be one of ALL/NONE")
    public IllegalArgumentException invalidFirstWord(String var1);

    @Message(id=2015, value="Failed to obtain DirContext")
    public IllegalStateException failedToObtainDirContext(@Cause Throwable var1);

    @Message(id=2016, value="Failed to return DirContext")
    public IllegalStateException failedToReturnDirContext(@Cause Throwable var1);

    @Message(id=2017, value="LdapKeyStore failed to obtain alias [%s]")
    public IllegalStateException ldapKeyStoreFailedToObtainAlias(String var1, @Cause Throwable var2);

    @Message(id=2018, value="LdapKeyStore failed to obtain certificate [%s]")
    public IllegalStateException ldapKeyStoreFailedToObtainCertificate(String var1, @Cause Throwable var2);

    @Message(id=2019, value="LdapKeyStore failed to obtain certificate chain [%s]")
    public IllegalStateException ldapKeyStoreFailedToObtainCertificateChain(String var1, @Cause Throwable var2);

    @Message(id=2020, value="LdapKeyStore failed to recover key of alias [%s]")
    public IllegalStateException ldapKeyStoreFailedToObtainKey(String var1, @Cause Throwable var2);

    @Message(id=2021, value="LdapKeyStore failed to obtain alias by certificate")
    public IllegalStateException ldapKeyStoreFailedToObtainAliasByCertificate(@Cause Throwable var1);

    @Message(id=2022, value="LdapKeyStore failed to recover key of alias [%s]")
    public UnrecoverableKeyException ldapKeyStoreFailedToRecoverKey(String var1, @Cause Throwable var2);

    @Message(id=2023, value="LdapKeyStore failed to obtain creation date of alias [%s]")
    public IllegalStateException ldapKeyStoreFailedToObtainCreationDate(String var1, @Cause Throwable var2);

    @Message(id=2024, value="Alias [%s] does not exist in LdapKeyStore and not configured for creation")
    public KeyStoreException creationNotConfigured(String var1);

    @Message(id=2025, value="LdapKeyStore failed store alias [%s]")
    public KeyStoreException ldapKeyStoreFailedToStore(String var1, @Cause Throwable var2);

    @Message(id=2026, value="LdapKeyStore failed to serialize certificate of alias [%s]")
    public KeyStoreException ldapKeyStoreFailedToSerializeCertificate(String var1, @Cause Throwable var2);

    @Message(id=2027, value="LdapKeyStore failed to protect (pack into keystore) key of alias [%s]")
    public KeyStoreException ldapKeyStoreFailedToSerializeKey(String var1, @Cause Throwable var2);

    @Message(id=2028, value="LdapKeyStore failed to delete alias [%s]")
    public KeyStoreException ldapKeyStoreFailedToDelete(String var1, @Cause Throwable var2);

    @Message(id=2029, value="LdapKeyStore failed to delete alias [%s] - alias not found")
    public KeyStoreException ldapKeyStoreFailedToDeleteNonExisting(String var1);

    @Message(id=2030, value="LdapKeyStore failed to test alias [%s] existence")
    public IllegalStateException ldapKeyStoreFailedToTestAliasExistence(String var1, @Cause Throwable var2);

    @Message(id=2031, value="LdapKeyStore failed to iterate aliases")
    public IllegalStateException ldapKeyStoreFailedToIterateAliases(@Cause Throwable var1);

    @Message(id=2032, value="keySpec must be SecretKeySpect, given: [%s]")
    public InvalidKeySpecException keySpecMustBeSecretKeySpec(String var1);

    @Message(id=2033, value="key must implement SecretKeySpec and keySpec must be SecretKeySpec, given key, keySpec: [%s]")
    public InvalidKeySpecException keyMustImplementSecretKeySpecAndKeySpecMustBeSecretKeySpec(String var1);

    @Message(id=2035, value="KeyStore type could not be detected")
    public KeyStoreException keyStoreTypeNotDetected();

    @Message(id=5151, value="Invalid OTP algorithm \"%s\"")
    public SaslException mechInvalidOTPAlgorithm(String var1);

    @Message(id=8001, value="Unrecognized key spec algorithm")
    public InvalidKeySpecException invalidKeySpecUnrecognizedKeySpecAlgorithm();

    @Message(id=8002, value="Password spec cannot be rendered as a string")
    public InvalidKeySpecException invalidKeySpecPasswordSpecCannotBeRenderedAsString();

    @Message(id=8003, value="Unknown crypt string algorithm")
    public InvalidKeySpecException invalidKeySpecUnknownCryptStringAlgorithm();

    @Message(id=8004, value="Invalid character encountered")
    public InvalidKeySpecException invalidKeySpecInvalidCharacterEncountered();

    @Message(id=8005, value="No iteration count terminator given")
    public InvalidKeySpecException invalidKeySpecNoIterationCountTerminatorGiven();

    @Message(id=8006, value="Unexpected end of input string")
    public InvalidKeySpecException invalidKeySpecUnexpectedEndOfInputString();

    @Message(id=8007, value="No salt terminator given")
    public InvalidKeySpecException invalidKeySpecNoSaltTerminatorGiven();

    @Message(id=8008, value="Invalid hash length")
    public IllegalArgumentException invalidHashLength();

    @Message(id=8009, value="Unexpected end of password string")
    public InvalidKeySpecException invalidKeySpecUnexpectedEndOfPasswordString();

    @Message(id=8010, value="Unexpected end of password string")
    public InvalidKeySpecException invalidKeySpecUnexpectedEndOfPasswordStringWithCause(@Cause Throwable var1);

    @Message(id=8011, value="Invalid minor version")
    public InvalidKeySpecException invalidKeySpecInvalidMinorVersion();

    @Message(id=8012, value="Invalid cost: must be a two digit integer")
    public InvalidKeySpecException invalidKeySpecCostMustBeTwoDigitInteger();

    @Message(id=8013, value="No such MessageDigest algorithm for \"%s\"")
    public InvalidKeySpecException invalidKeySpecNoSuchMessageDigestAlgorithm(String var1);

    @Message(id=8014, value="No such MessageDigest algorithm for \"%s\"")
    public InvalidKeyException invalidKeyNoSuchMessageDigestAlgorithm(String var1);

    @Message(id=8015, value="Cannot verify password")
    public InvalidKeyException invalidKeyCannotVerifyPassword(@Cause Throwable var1);

    @Message(id=8017, value="DES crypt password hash must be %d bytes")
    public InvalidKeyException invalidKeyDesCryptPasswordHashMustBeBytes(int var1);

    @Message(id=8018, value="Salt must be %d bytes (%d bits)")
    public InvalidParameterSpecException invalidParameterSpecSaltMustBeBytesBits(int var1, int var2);

    @Message(id=8020, value="Invalid number of rounds. Must be an integer between %d and %d, inclusive")
    public IllegalArgumentException invalidNumberOfRoundsMustBeIntBetween(int var1, int var2);

    @Message(id=8021, value="Invalid salt: must be %d bytes long")
    public IllegalArgumentException invalidSaltMustBeBytesLong(int var1);

    @Message(id=8022, value="BSD DES crypt password hash must be %d bytes")
    public InvalidKeySpecException invalidKeySpecBsdDesCryptPasswordHashMustBeBytes(int var1);

    @Message(id=8023, value="Salt must be %d bytes")
    public InvalidParameterSpecException invalidParameterSpecSaltMustBeBytes(int var1);

    @Message(id=8024, value="BSD DES crypt password hash must be %d bytes")
    public InvalidKeyException invalidKeyBsdDesCryptPasswordHashMustBeBytes(int var1);

    @Message(id=8025, value="Expected to get a \"%s\" as spec, got \"%s\"")
    public InvalidKeySpecException invalidKeySpecExpectedSpecGotSpec(String var1, String var2);

    @Message(id=8026, value="Unknown algorithm or incompatible PasswordSpec")
    public InvalidKeySpecException invalidKeySpecUnknownAlgorithmOrIncompatiblePasswordSpec();

    @Message(id=8027, value="Unknown password type or algorithm")
    public InvalidKeyException invalidKeyUnknownUnknownPasswordTypeOrAlgorithm();

    @Message(id=8028, value="Invalid algorithm \"%s\"")
    public NoSuchAlgorithmException noSuchAlgorithmInvalidAlgorithm(String var1);

    @Message(id=8029, value="Could not obtain key spec encoding identifier.")
    public IllegalArgumentException couldNotObtainKeySpecEncodingIdentifier();

    @Message(id=9000, value="Public and private key parameters are mismatched")
    public IllegalArgumentException mismatchedPublicPrivateKeyParameters();
}

