/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.realm;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.Provider;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.wildfly.common.Assert;
import org.wildfly.common.codec.DecodeException;
import org.wildfly.common.iteration.ByteIterator;
import org.wildfly.common.iteration.CodePointIterator;
import org.wildfly.security.auth.SupportLevel;
import org.wildfly.security.auth.principal.NamePrincipal;
import org.wildfly.security.auth.realm.ElytronMessages;
import org.wildfly.security.auth.server.RealmIdentity;
import org.wildfly.security.auth.server.RealmUnavailableException;
import org.wildfly.security.auth.server.SecurityRealm;
import org.wildfly.security.authz.AuthorizationIdentity;
import org.wildfly.security.authz.MapAttributes;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.credential.PasswordCredential;
import org.wildfly.security.evidence.Evidence;
import org.wildfly.security.evidence.PasswordGuessEvidence;
import org.wildfly.security.password.Password;
import org.wildfly.security.password.PasswordFactory;
import org.wildfly.security.password.spec.ClearPasswordSpec;
import org.wildfly.security.password.spec.DigestPasswordAlgorithmSpec;
import org.wildfly.security.password.spec.DigestPasswordSpec;
import org.wildfly.security.password.spec.EncryptablePasswordSpec;
import org.wildfly.security.password.spec.PasswordSpec;
import org.wildfly.security.util.ProviderUtil;

public class LegacyPropertiesSecurityRealm
implements SecurityRealm {
    private static final String COMMENT_PREFIX1 = "#";
    private static final String COMMENT_PREFIX2 = "!";
    private static final String REALM_COMMENT_PREFIX = "$REALM_NAME=";
    private static final String REALM_COMMENT_SUFFIX = "$";
    private final Supplier<Provider[]> providers;
    private final String defaultRealm;
    private final boolean plainText;
    private final String groupsAttribute;
    private final AtomicReference<LoadedState> loadedState = new AtomicReference();

    private LegacyPropertiesSecurityRealm(Builder builder) throws IOException {
        this.plainText = builder.plainText;
        this.groupsAttribute = builder.groupsAttribute;
        this.providers = builder.providers;
        this.defaultRealm = builder.defaultRealm;
    }

    @Override
    public RealmIdentity getRealmIdentity(final Principal principal) throws RealmUnavailableException {
        if (!(principal instanceof NamePrincipal)) {
            ElytronMessages.log.tracef("PropertiesRealm: unsupported principal type: [%s]", (Object)principal);
            return RealmIdentity.NON_EXISTENT;
        }
        final LoadedState loadedState = this.loadedState.get();
        final AccountEntry accountEntry = loadedState.getAccounts().get(principal.getName());
        if (accountEntry == null) {
            ElytronMessages.log.tracef("PropertiesRealm: identity [%s] does not exist", (Object)principal);
            return RealmIdentity.NON_EXISTENT;
        }
        return new RealmIdentity(){

            @Override
            public Principal getRealmIdentityPrincipal() {
                return principal;
            }

            @Override
            public SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec) throws RealmUnavailableException {
                return LegacyPropertiesSecurityRealm.this.getCredentialAcquireSupport(credentialType, algorithmName, parameterSpec);
            }

            @Override
            public SupportLevel getEvidenceVerifySupport(Class<? extends Evidence> evidenceType, String algorithmName) throws RealmUnavailableException {
                return LegacyPropertiesSecurityRealm.this.getEvidenceVerifySupport(evidenceType, algorithmName);
            }

            @Override
            public <C extends Credential> C getCredential(Class<C> credentialType) throws RealmUnavailableException {
                return this.getCredential(credentialType, null, null);
            }

            @Override
            public <C extends Credential> C getCredential(Class<C> credentialType, String algorithmName) throws RealmUnavailableException {
                return this.getCredential(credentialType, algorithmName, null);
            }

            @Override
            public <C extends Credential> C getCredential(Class<C> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec) throws RealmUnavailableException {
                PasswordSpec passwordSpec;
                PasswordFactory passwordFactory;
                boolean clear;
                if (accountEntry.getPasswordRepresentation() == null || LegacyPropertiesSecurityRealm.this.getCredentialAcquireSupport(credentialType, algorithmName, parameterSpec) == SupportLevel.UNSUPPORTED) {
                    ElytronMessages.log.tracef("PropertiesRealm: Unable to obtain credential for identity [%s]", (Object)principal);
                    return null;
                }
                if (algorithmName == null) {
                    clear = LegacyPropertiesSecurityRealm.this.plainText;
                } else if ("clear".equals(algorithmName)) {
                    clear = true;
                } else if ("digest-md5".equals(algorithmName)) {
                    clear = false;
                } else {
                    ElytronMessages.log.tracef("PropertiesRealm: Unable to obtain credential for identity [%s]: unsupported algorithm [%s]", (Object)principal, (Object)algorithmName);
                    return null;
                }
                if (clear) {
                    passwordFactory = LegacyPropertiesSecurityRealm.this.getPasswordFactory("clear");
                    passwordSpec = new ClearPasswordSpec(accountEntry.getPasswordRepresentation().toCharArray());
                } else {
                    AlgorithmParameterSpec spec;
                    passwordFactory = LegacyPropertiesSecurityRealm.this.getPasswordFactory("digest-md5");
                    if (LegacyPropertiesSecurityRealm.this.plainText) {
                        spec = parameterSpec != null ? parameterSpec : new DigestPasswordAlgorithmSpec(accountEntry.getName(), loadedState.getRealmName());
                        passwordSpec = new EncryptablePasswordSpec(accountEntry.getPasswordRepresentation().toCharArray(), spec);
                    } else {
                        if (parameterSpec != null) {
                            spec = (DigestPasswordAlgorithmSpec)parameterSpec;
                            if (!loadedState.getRealmName().equals(((DigestPasswordAlgorithmSpec)spec).getRealm()) || !accountEntry.getName().equals(((DigestPasswordAlgorithmSpec)spec).getUsername())) {
                                if (ElytronMessages.log.isTraceEnabled()) {
                                    ElytronMessages.log.tracef("PropertiesRealm: Unable to obtain credential for username [%s] (available [%s]) and realm [%s] (available [%s])", ((DigestPasswordAlgorithmSpec)spec).getUsername(), accountEntry.getName(), ((DigestPasswordAlgorithmSpec)spec).getRealm(), loadedState.getRealmName());
                                }
                                return null;
                            }
                        }
                        byte[] hashed = ByteIterator.ofBytes(accountEntry.getPasswordRepresentation().getBytes(StandardCharsets.UTF_8)).asUtf8String().hexDecode().drain();
                        passwordSpec = new DigestPasswordSpec(accountEntry.getName(), loadedState.getRealmName(), hashed);
                    }
                }
                try {
                    return (C)((Credential)credentialType.cast(new PasswordCredential(passwordFactory.generatePassword(passwordSpec))));
                }
                catch (InvalidKeySpecException e) {
                    throw new IllegalStateException(e);
                }
            }

            @Override
            public boolean verifyEvidence(Evidence evidence) throws RealmUnavailableException {
                PasswordSpec passwordSpec;
                PasswordFactory passwordFactory;
                if (accountEntry.getPasswordRepresentation() == null || !(evidence instanceof PasswordGuessEvidence)) {
                    ElytronMessages.log.tracef("Unable to verify evidence for identity [%s]", (Object)principal);
                    return false;
                }
                char[] guess = ((PasswordGuessEvidence)evidence).getGuess();
                if (LegacyPropertiesSecurityRealm.this.plainText) {
                    passwordFactory = LegacyPropertiesSecurityRealm.this.getPasswordFactory("clear");
                    passwordSpec = new ClearPasswordSpec(accountEntry.getPasswordRepresentation().toCharArray());
                } else {
                    passwordFactory = LegacyPropertiesSecurityRealm.this.getPasswordFactory("digest-md5");
                    try {
                        byte[] hashed = ByteIterator.ofBytes(accountEntry.getPasswordRepresentation().getBytes(StandardCharsets.UTF_8)).asUtf8String().hexDecode().drain();
                        passwordSpec = new DigestPasswordSpec(accountEntry.getName(), loadedState.getRealmName(), hashed);
                    }
                    catch (DecodeException e) {
                        throw ElytronMessages.log.decodingHashedPasswordFromPropertiesRealmFailed(e);
                    }
                }
                try {
                    ElytronMessages.log.tracef("Attempting to authenticate account %s using LegacyPropertiesSecurityRealm.", (Object)accountEntry.getName());
                    Password actualPassword = passwordFactory.generatePassword(passwordSpec);
                    return passwordFactory.verify(actualPassword, guess);
                }
                catch (IllegalStateException | InvalidKeyException | InvalidKeySpecException e) {
                    throw new IllegalStateException(e);
                }
            }

            @Override
            public boolean exists() throws RealmUnavailableException {
                return true;
            }

            @Override
            public AuthorizationIdentity getAuthorizationIdentity() throws RealmUnavailableException {
                return AuthorizationIdentity.basicIdentity(new MapAttributes(Collections.singletonMap(LegacyPropertiesSecurityRealm.this.groupsAttribute, accountEntry.getGroups())));
            }
        };
    }

    private PasswordFactory getPasswordFactory(String algorithm) {
        try {
            return PasswordFactory.getInstance(algorithm, this.providers);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec) throws RealmUnavailableException {
        Assert.checkNotNullParam("credentialType", credentialType);
        return PasswordCredential.class.isAssignableFrom(credentialType) && (algorithmName == null || algorithmName.equals("clear") && this.plainText || algorithmName.equals("digest-md5")) && (parameterSpec == null || parameterSpec instanceof DigestPasswordAlgorithmSpec) ? SupportLevel.SUPPORTED : SupportLevel.UNSUPPORTED;
    }

    @Override
    public SupportLevel getEvidenceVerifySupport(Class<? extends Evidence> evidenceType, String algorithmName) throws RealmUnavailableException {
        return PasswordGuessEvidence.class.isAssignableFrom(evidenceType) ? SupportLevel.SUPPORTED : SupportLevel.UNSUPPORTED;
    }

    public void load(InputStream usersStream, InputStream groupsStream) throws IOException {
        HashMap<String, AccountEntry> accounts = new HashMap<String, AccountEntry>();
        Properties groups = new Properties();
        if (groupsStream != null) {
            Object object = null;
            try (InputStreamReader is = new InputStreamReader(groupsStream, StandardCharsets.UTF_8);){
                groups.load(is);
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
        }
        String realmName = null;
        if (usersStream != null) {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(usersStream, StandardCharsets.UTF_8));){
                String currentLine;
                while ((currentLine = reader.readLine()) != null) {
                    String trimmed = currentLine.trim();
                    if (trimmed.startsWith(COMMENT_PREFIX1) && trimmed.contains(REALM_COMMENT_PREFIX)) {
                        int start = trimmed.indexOf(REALM_COMMENT_PREFIX) + REALM_COMMENT_PREFIX.length();
                        int end = trimmed.indexOf(REALM_COMMENT_SUFFIX, start);
                        if (end <= -1) continue;
                        realmName = trimmed.substring(start, end);
                        continue;
                    }
                    if (trimmed.startsWith(COMMENT_PREFIX1) || trimmed.startsWith(COMMENT_PREFIX2)) continue;
                    String username = null;
                    StringBuilder builder = new StringBuilder();
                    CodePointIterator it = CodePointIterator.ofString(trimmed);
                    while (it.hasNext()) {
                        int cp = it.next();
                        if (cp == 92 && it.hasNext()) {
                            int marker = it.next();
                            if (marker != 117) {
                                builder.appendCodePoint(marker);
                                continue;
                            }
                            StringBuilder hex = new StringBuilder();
                            try {
                                hex.appendCodePoint(it.next());
                                hex.appendCodePoint(it.next());
                                hex.appendCodePoint(it.next());
                                hex.appendCodePoint(it.next());
                                builder.appendCodePoint((char)Integer.parseInt(hex.toString(), 16));
                                continue;
                            }
                            catch (NoSuchElementException nsee) {
                                throw ElytronMessages.log.invalidUnicodeSequence(hex.toString(), nsee);
                            }
                        }
                        if (username == null && (cp == 61 || cp == 58)) {
                            username = builder.toString().trim();
                            builder = new StringBuilder();
                            continue;
                        }
                        builder.appendCodePoint(cp);
                    }
                    if (username == null) continue;
                    String password = builder.toString().trim();
                    accounts.put(username, new AccountEntry(username, password, groups.getProperty(username)));
                }
            }
            if (realmName == null) {
                if (this.defaultRealm != null || this.plainText) {
                    realmName = this.defaultRealm;
                } else {
                    throw ElytronMessages.log.noRealmFoundInProperties();
                }
            }
        }
        for (String userName : groups.stringPropertyNames()) {
            if (accounts.containsKey(userName)) continue;
            accounts.put(userName, new AccountEntry(userName, null, groups.getProperty(userName)));
        }
        this.loadedState.set(new LoadedState(accounts, realmName, System.currentTimeMillis()));
    }

    public long getLoadTime() {
        return this.loadedState.get().getLoadTime();
    }

    public static Builder builder() {
        return new Builder();
    }

    private class AccountEntry {
        private final String name;
        private final String passwordRepresentation;
        private final Set<String> groups;

        private AccountEntry(String name, String passwordRepresentation, String groups) {
            this.name = name;
            this.passwordRepresentation = passwordRepresentation;
            this.groups = this.convertGroups(groups);
        }

        private Set<String> convertGroups(String groups) {
            if (groups == null) {
                return Collections.emptySet();
            }
            String[] groupArray = groups.split(",");
            HashSet<String> groupsSet = new HashSet<String>(groupArray.length);
            for (String current : groupArray) {
                String value = current.trim();
                if (value.length() <= 0) continue;
                groupsSet.add(value);
            }
            return Collections.unmodifiableSet(groupsSet);
        }

        public String getName() {
            return this.name;
        }

        public String getPasswordRepresentation() {
            return this.passwordRepresentation;
        }

        public Set<String> getGroups() {
            return this.groups;
        }
    }

    private static class LoadedState {
        private final Map<String, AccountEntry> accounts;
        private final String realmName;
        private final long loadTime;

        private LoadedState(Map<String, AccountEntry> accounts, String realmName, long loadTime) {
            this.accounts = accounts;
            this.realmName = realmName;
            this.loadTime = loadTime;
        }

        public Map<String, AccountEntry> getAccounts() {
            return this.accounts;
        }

        public String getRealmName() {
            return this.realmName;
        }

        public long getLoadTime() {
            return this.loadTime;
        }
    }

    public static class Builder {
        private Supplier<Provider[]> providers = ProviderUtil.INSTALLED_PROVIDERS;
        private InputStream usersStream;
        private InputStream groupsStream;
        private String defaultRealm = null;
        private boolean plainText;
        private String groupsAttribute = "groups";

        Builder() {
        }

        public Builder setProviders(Supplier<Provider[]> providers) {
            this.providers = providers;
            return this;
        }

        public Builder setUsersStream(InputStream usersStream) {
            this.usersStream = usersStream;
            return this;
        }

        public Builder setGroupsStream(InputStream groupsStream) {
            this.groupsStream = groupsStream;
            return this;
        }

        public Builder setGroupsAttribute(String groupsAttribute) {
            this.groupsAttribute = groupsAttribute;
            return this;
        }

        public Builder setDefaultRealm(String defaultRealm) {
            this.defaultRealm = defaultRealm;
            return this;
        }

        public Builder setPlainText(boolean plainText) {
            this.plainText = plainText;
            return this;
        }

        public LegacyPropertiesSecurityRealm build() throws IOException {
            LegacyPropertiesSecurityRealm realm = new LegacyPropertiesSecurityRealm(this);
            realm.load(this.usersStream, this.groupsStream);
            return realm;
        }
    }
}

