/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.common;

import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.AlwaysInline;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import org.wildfly.common.Branch;

final class Substitutions {
    Substitutions() {
    }

    @TargetClass(className="org.graalvm.compiler.api.directives.GraalDirectives")
    static final class Target_GraalDirectives {
        @Alias
        public static final double LIKELY_PROBABILITY = 0.75;
        @Alias
        public static final double UNLIKELY_PROBABILITY = 0.25;
        @Alias
        public static final double SLOWPATH_PROBABILITY = 1.0E-4;
        @Alias
        public static final double FASTPATH_PROBABILITY = 0.9999;

        Target_GraalDirectives() {
        }

        @Alias
        public static boolean injectBranchProbability(double probability, boolean condition) {
            assert (probability >= 0.0 && probability <= 1.0);
            return condition;
        }
    }

    @TargetClass(value=Branch.class)
    static final class Target_Branch {
        Target_Branch() {
        }

        @AlwaysInline(value="Straight call to GraalVM")
        @Substitute
        public static boolean veryLikely(boolean expr) {
            return Target_GraalDirectives.injectBranchProbability(0.9999, expr);
        }

        @AlwaysInline(value="Straight call to GraalVM")
        @Substitute
        public static boolean veryUnlikely(boolean expr) {
            return Target_GraalDirectives.injectBranchProbability(1.0E-4, expr);
        }

        @AlwaysInline(value="Straight call to GraalVM")
        @Substitute
        public static boolean likely(boolean expr) {
            return Target_GraalDirectives.injectBranchProbability(0.75, expr);
        }

        @AlwaysInline(value="Straight call to GraalVM")
        @Substitute
        public static boolean unlikely(boolean expr) {
            return Target_GraalDirectives.injectBranchProbability(0.25, expr);
        }

        @AlwaysInline(value="Straight call to GraalVM")
        @Substitute
        public static boolean probability(float prob, boolean expr) {
            return Target_GraalDirectives.injectBranchProbability(prob, expr);
        }
    }
}

