/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.sasl.otp;

import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import javax.security.auth.callback.ChoiceCallback;
import org.wildfly.security.auth.callback.ExtendedChoiceCallback;
import org.wildfly.security.password.spec.OneTimePasswordAlgorithmSpec;

public final class OTP {
    public static final String OTP_PREFIX = "otp-";
    public static final String EXT = "ext";
    public static final String MD5 = "md5";
    public static final String SHA1 = "sha1";
    public static final String HEX_RESPONSE = "hex";
    public static final String WORD_RESPONSE = "word";
    public static final String INIT_HEX_RESPONSE = "init-hex";
    public static final String INIT_WORD_RESPONSE = "init-word";
    public static final String PASS_PHRASE = "pass-phrase";
    public static final String DIRECT_OTP = "direct-otp";
    public static final int MAX_AUTHORIZATION_ID_LENGTH = 255;
    public static final int MAX_AUTHENTICATION_ID_LENGTH = 255;
    public static final int MIN_SEED_LENGTH = 1;
    public static final int MAX_SEED_LENGTH = 16;
    public static final int DEFAULT_SEED_LENGTH = 10;
    public static final int MIN_PASS_PHRASE_LENGTH = 10;
    public static final int MAX_PASS_PHRASE_LENGTH = 63;
    public static final int MIN_SEQUENCE_NUMBER = 10;
    public static final int DEFAULT_SEQUENCE_NUMBER = 499;
    public static final char DICTIONARY_DELIMITER = ' ';
    public static final int DICTIONARY_SIZE = 2048;
    public static final String RESPONSE_TYPE_PROMPT = "One-time password response type";
    public static final String PASSWORD_FORMAT_TYPE_PROMPT = "One-time password format type";
    public static final String NEW_PASSWORD_FORMAT_TYPE_PROMPT = "New one-time password format type";
    public static final String PASSWORD_PROMPT = "Pass phrase or one-time password";
    public static final String NEW_PASSWORD_PROMPT = "New pass phrase or one-time password";
    public static final BiPredicate<Class<? extends ChoiceCallback>, String> MATCH_RESPONSE_CHOICE = (choiceCallbackType, prompt) -> ExtendedChoiceCallback.class.isAssignableFrom((Class<?>)choiceCallbackType) && RESPONSE_TYPE_PROMPT.equals(prompt);
    public static final BiPredicate<Class<? extends ChoiceCallback>, String> MATCH_PASSWORD_FORMAT_CHOICE = (choiceCallbackType, prompt) -> ExtendedChoiceCallback.class.isAssignableFrom((Class<?>)choiceCallbackType) && PASSWORD_FORMAT_TYPE_PROMPT.equals(prompt);
    public static final BiPredicate<Class<? extends ChoiceCallback>, String> MATCH_NEW_PASSWORD_FORMAT_CHOICE = (choiceCallbackType, prompt) -> ExtendedChoiceCallback.class.isAssignableFrom((Class<?>)choiceCallbackType) && NEW_PASSWORD_FORMAT_TYPE_PROMPT.equals(prompt);
    public static final Predicate<String> MATCH_PASSWORD = prompt -> PASSWORD_PROMPT.equals(prompt);
    public static final Predicate<String> MATCH_NEW_PASSWORD = prompt -> NEW_PASSWORD_PROMPT.equals(prompt);

    public static OneTimePasswordAlgorithmSpec getOTPParameterSpec(String algorithm, String seed, int sequenceNumber) {
        return new OneTimePasswordAlgorithmSpec(algorithm, seed.getBytes(StandardCharsets.US_ASCII), sequenceNumber);
    }

    static boolean isMatched(Map<String, ?> props, boolean query) {
        if (props == null) {
            return true;
        }
        if ("true".equals(props.get("wildfly.sasl.mechanism-query-all")) && query) {
            return true;
        }
        if ("true".equals(props.get("javax.security.sasl.policy.noactive"))) {
            return false;
        }
        if ("true".equals(props.get("javax.security.sasl.policy.credentials"))) {
            return false;
        }
        return !"true".equals(props.get("javax.security.sasl.policy.nodictionary"));
    }
}

