/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.server;

import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.cert.X509Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.RealmCallback;
import org.wildfly.common.Assert;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.auth.SupportLevel;
import org.wildfly.security.auth.callback.AnonymousAuthorizationCallback;
import org.wildfly.security.auth.callback.AuthenticationCompleteCallback;
import org.wildfly.security.auth.callback.AvailableRealmsCallback;
import org.wildfly.security.auth.callback.CachedIdentityAuthorizeCallback;
import org.wildfly.security.auth.callback.CallbackUtil;
import org.wildfly.security.auth.callback.ChannelBindingCallback;
import org.wildfly.security.auth.callback.CredentialCallback;
import org.wildfly.security.auth.callback.CredentialUpdateCallback;
import org.wildfly.security.auth.callback.EvidenceVerifyCallback;
import org.wildfly.security.auth.callback.ExclusiveNameCallback;
import org.wildfly.security.auth.callback.FastUnsupportedCallbackException;
import org.wildfly.security.auth.callback.IdentityCredentialCallback;
import org.wildfly.security.auth.callback.MechanismInformationCallback;
import org.wildfly.security.auth.callback.PeerPrincipalCallback;
import org.wildfly.security.auth.callback.SSLCallback;
import org.wildfly.security.auth.callback.SecurityIdentityCallback;
import org.wildfly.security.auth.callback.ServerCredentialCallback;
import org.wildfly.security.auth.callback.SocketAddressCallback;
import org.wildfly.security.auth.permission.LoginPermission;
import org.wildfly.security.auth.permission.RunAsPrincipalPermission;
import org.wildfly.security.auth.principal.AnonymousPrincipal;
import org.wildfly.security.auth.principal.NamePrincipal;
import org.wildfly.security.auth.server.IdentityCredentials;
import org.wildfly.security.auth.server.MechanismConfiguration;
import org.wildfly.security.auth.server.MechanismConfigurationSelector;
import org.wildfly.security.auth.server.MechanismInformation;
import org.wildfly.security.auth.server.MechanismRealmConfiguration;
import org.wildfly.security.auth.server.ModifiableSecurityRealm;
import org.wildfly.security.auth.server.RealmIdentity;
import org.wildfly.security.auth.server.RealmInfo;
import org.wildfly.security.auth.server.RealmMapper;
import org.wildfly.security.auth.server.RealmUnavailableException;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.auth.server.SecurityIdentity;
import org.wildfly.security.auth.server.SecurityRealm;
import org.wildfly.security.auth.server.event.RealmFailedAuthenticationEvent;
import org.wildfly.security.auth.server.event.RealmIdentityFailedAuthorizationEvent;
import org.wildfly.security.auth.server.event.RealmIdentitySuccessfulAuthorizationEvent;
import org.wildfly.security.auth.server.event.RealmSuccessfulAuthenticationEvent;
import org.wildfly.security.auth.server.event.SecurityAuthenticationFailedEvent;
import org.wildfly.security.auth.server.event.SecurityAuthenticationSuccessfulEvent;
import org.wildfly.security.authz.AuthorizationIdentity;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.credential.PasswordCredential;
import org.wildfly.security.credential.source.CredentialSource;
import org.wildfly.security.evidence.AlgorithmEvidence;
import org.wildfly.security.evidence.Evidence;
import org.wildfly.security.evidence.X509PeerCertificateChainEvidence;
import org.wildfly.security.password.Password;
import org.wildfly.security.password.PasswordFactory;
import org.wildfly.security.password.TwoWayPassword;
import org.wildfly.security.password.interfaces.DigestPassword;
import org.wildfly.security.password.spec.ClearPasswordSpec;
import org.wildfly.security.ssl.TLSServerEndPointChannelBinding;
import org.wildfly.security.x500.X500;

public final class ServerAuthenticationContext
implements AutoCloseable {
    private final AtomicReference<State> stateRef;
    private static final State FAILED = new State(){

        @Override
        void fail(boolean requireInProgress) {
        }

        @Override
        boolean isDone() {
            return true;
        }
    };

    ServerAuthenticationContext(SecurityDomain domain, MechanismConfigurationSelector mechanismConfigurationSelector) {
        this(domain.getCurrentSecurityIdentity(), mechanismConfigurationSelector);
    }

    ServerAuthenticationContext(SecurityIdentity capturedIdentity, MechanismConfigurationSelector mechanismConfigurationSelector) {
        this.stateRef = new AtomicReference<InactiveState>(new InactiveState(capturedIdentity, mechanismConfigurationSelector, IdentityCredentials.NONE, IdentityCredentials.NONE));
    }

    public void setMechanismInformation(MechanismInformation mechanismInformation) throws IllegalStateException {
        this.stateRef.get().setMechanismInformation(mechanismInformation);
    }

    public SecurityIdentity getAuthorizedIdentity() throws IllegalStateException {
        return this.stateRef.get().getAuthorizedIdentity();
    }

    public boolean authorizeAnonymous() throws IllegalStateException {
        return this.authorizeAnonymous(true);
    }

    public boolean authorizeAnonymous(boolean requireLoginPermission) throws IllegalStateException {
        return this.stateRef.get().authorizeAnonymous(requireLoginPermission);
    }

    public void setAuthenticationName(String name) throws IllegalArgumentException, RealmUnavailableException, IllegalStateException {
        this.setAuthenticationName(name, false);
    }

    public void setAuthenticationName(String name, boolean exclusive) throws IllegalArgumentException, RealmUnavailableException, IllegalStateException {
        Assert.checkNotNullParam("name", name);
        this.setAuthenticationPrincipal(new NamePrincipal(name), exclusive);
    }

    public void setAuthenticationPrincipal(Principal principal) throws IllegalArgumentException, RealmUnavailableException, IllegalStateException {
        this.setAuthenticationPrincipal(principal, false);
    }

    public void setAuthenticationPrincipal(Principal principal, boolean exclusive) throws IllegalArgumentException, RealmUnavailableException, IllegalStateException {
        Assert.checkNotNullParam("principal", principal);
        this.stateRef.get().setPrincipal(principal, exclusive);
    }

    public boolean isSameName(String name) throws IllegalArgumentException, RealmUnavailableException, IllegalStateException {
        Assert.checkNotNullParam("name", name);
        return this.isSamePrincipal(new NamePrincipal(name));
    }

    public boolean isSamePrincipal(Principal principal) throws IllegalArgumentException, RealmUnavailableException, IllegalStateException {
        Assert.checkNotNullParam("principal", principal);
        return this.stateRef.get().isSamePrincipal(principal);
    }

    public boolean exists() throws RealmUnavailableException, IllegalStateException {
        return this.stateRef.get().getRealmIdentity().exists();
    }

    public void fail() throws IllegalStateException {
        this.stateRef.get().fail(true);
    }

    public boolean authorize() throws RealmUnavailableException, IllegalStateException {
        return this.authorize(true);
    }

    boolean authorize(boolean requireLoginPermission) throws RealmUnavailableException, IllegalStateException {
        return this.stateRef.get().authorize(requireLoginPermission);
    }

    public boolean authorize(String name) throws IllegalArgumentException, RealmUnavailableException, IllegalStateException {
        Assert.checkNotNullParam("name", name);
        return this.authorize(new NamePrincipal(name), true);
    }

    public boolean authorize(Principal principal) throws IllegalArgumentException, RealmUnavailableException, IllegalStateException {
        return this.authorize(principal, true);
    }

    boolean authorize(Principal principal, boolean authorizeRunAs) throws IllegalArgumentException, RealmUnavailableException, IllegalStateException {
        Assert.checkNotNullParam("principal", principal);
        return this.stateRef.get().authorize(principal, authorizeRunAs);
    }

    public void succeed() throws IllegalStateException, RealmUnavailableException {
        this.stateRef.get().succeed();
    }

    public boolean isDone() {
        return this.stateRef.get().isDone();
    }

    public Principal getAuthenticationPrincipal() {
        return this.stateRef.get().getAuthenticationPrincipal();
    }

    public SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec) throws RealmUnavailableException {
        Assert.checkNotNullParam("credentialType", credentialType);
        return this.stateRef.get().getCredentialAcquireSupport(credentialType, algorithmName, parameterSpec);
    }

    public SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String algorithmName) throws RealmUnavailableException {
        return this.getCredentialAcquireSupport(credentialType, algorithmName, null);
    }

    public SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType) throws RealmUnavailableException {
        Assert.checkNotNullParam("credentialType", credentialType);
        return this.getCredentialAcquireSupport(credentialType, null);
    }

    public SupportLevel getEvidenceVerifySupport(Class<? extends Evidence> evidenceType, String algorithmName) throws RealmUnavailableException {
        Assert.checkNotNullParam("evidenceType", evidenceType);
        return this.stateRef.get().getEvidenceVerifySupport(evidenceType, algorithmName);
    }

    public SupportLevel getEvidenceVerifySupport(Class<? extends Evidence> evidenceType) throws RealmUnavailableException {
        Assert.checkNotNullParam("evidenceType", evidenceType);
        return this.getEvidenceVerifySupport(evidenceType, null);
    }

    public <C extends Credential> C getCredential(Class<C> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec) throws RealmUnavailableException {
        Assert.checkNotNullParam("credentialType", credentialType);
        return this.stateRef.get().getCredential(credentialType, algorithmName, parameterSpec);
    }

    public <C extends Credential> C getCredential(Class<C> credentialType, String algorithmName) throws RealmUnavailableException {
        Assert.checkNotNullParam("credentialType", credentialType);
        return this.stateRef.get().getCredential(credentialType, algorithmName, null);
    }

    public <C extends Credential> C getCredential(Class<C> credentialType) throws RealmUnavailableException {
        Assert.checkNotNullParam("credentialType", credentialType);
        return this.stateRef.get().getCredential(credentialType, null, null);
    }

    public <C extends Credential, R> R applyToCredential(Class<C> credentialType, Function<C, R> function) throws RealmUnavailableException {
        C credential = this.getCredential(credentialType);
        return credential == null ? null : (R)credential.castAndApply(credentialType, function);
    }

    public <C extends Credential, R> R applyToCredential(Class<C> credentialType, String algorithmName, Function<C, R> function) throws RealmUnavailableException {
        C credential = this.getCredential(credentialType, algorithmName);
        return credential == null ? null : (R)credential.castAndApply(credentialType, algorithmName, function);
    }

    public <C extends Credential, R> R applyToCredential(Class<C> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec, Function<C, R> function) throws RealmUnavailableException {
        C credential = this.getCredential(credentialType, algorithmName, parameterSpec);
        return credential == null ? null : (R)credential.castAndApply(credentialType, algorithmName, parameterSpec, function);
    }

    public boolean verifyEvidence(Evidence evidence) throws RealmUnavailableException {
        Assert.checkNotNullParam("evidence", evidence);
        return this.stateRef.get().verifyEvidence(evidence);
    }

    public void addPublicCredential(Credential credential) {
        Assert.checkNotNullParam("credential", credential);
        this.stateRef.get().addPublicCredential(credential);
    }

    public void addPrivateCredential(Credential credential) {
        Assert.checkNotNullParam("credential", credential);
        this.stateRef.get().addPrivateCredential(credential);
    }

    public boolean importIdentity(SecurityIdentity identity) throws RealmUnavailableException {
        Assert.checkNotNullParam("identity", identity);
        return this.stateRef.get().importIdentity(identity);
    }

    public void setMechanismRealmName(String realmName) throws IllegalStateException, IllegalArgumentException {
        Assert.checkNotNullParam("realmName", realmName);
        this.stateRef.get().setMechanismRealmName(realmName);
    }

    public void updateCredential(Credential credential) throws RealmUnavailableException {
        Assert.checkNotNullParam("credential", credential);
        this.stateRef.get().updateCredential(credential);
    }

    @Override
    public void close() {
        this.stateRef.get().fail(false);
    }

    AtomicReference<State> getStateRef() {
        return this.stateRef;
    }

    CallbackHandler createCallbackHandler() {
        return new CallbackHandler(){
            private X509Certificate[] certs;

            @Override
            public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                this.handleOne(callbacks, 0);
            }

            private void handleOne(Callback[] callbacks, int idx) throws IOException, UnsupportedCallbackException {
                if (idx == callbacks.length) {
                    return;
                }
                AtomicReference<State> stateRef = ServerAuthenticationContext.this.getStateRef();
                Callback callback = callbacks[idx];
                if (callback instanceof AnonymousAuthorizationCallback) {
                    boolean authorized = ServerAuthenticationContext.this.authorizeAnonymous();
                    ElytronMessages.log.tracef("Handling AnonymousAuthorizationCallback: authorized = %b", (Object)authorized);
                    ((AnonymousAuthorizationCallback)callback).setAuthorized(authorized);
                    this.handleOne(callbacks, idx + 1);
                } else if (callback instanceof AuthorizeCallback) {
                    String authorizationID;
                    AuthorizeCallback authorizeCallback = (AuthorizeCallback)callback;
                    String authenticationID = authorizeCallback.getAuthenticationID();
                    if (authenticationID != null) {
                        ServerAuthenticationContext.this.setAuthenticationName(authenticationID);
                    }
                    boolean authorized = (authorizationID = authorizeCallback.getAuthorizationID()) != null ? ServerAuthenticationContext.this.authorize(authorizationID) : ServerAuthenticationContext.this.authorize();
                    ElytronMessages.log.tracef("Handling AuthorizeCallback: authenticationID = %s  authorizationID = %s  authorized = %b", (Object)authenticationID, (Object)authorizationID, (Object)authorized);
                    authorizeCallback.setAuthorized(authorized);
                    this.handleOne(callbacks, idx + 1);
                } else if (callback instanceof ExclusiveNameCallback) {
                    ExclusiveNameCallback exclusiveNameCallback = (ExclusiveNameCallback)callback;
                    String name = exclusiveNameCallback.getDefaultName();
                    try {
                        boolean exclusive = exclusiveNameCallback.needsExclusiveAccess();
                        ElytronMessages.log.tracef("Handling ExclusiveNameCallback: authenticationName = %s  needsExclusiveAccess = %b", (Object)name, (Object)exclusive);
                        if (exclusive) {
                            ServerAuthenticationContext.this.setAuthenticationName(name, true);
                            exclusiveNameCallback.setExclusiveAccess(true);
                        } else {
                            ServerAuthenticationContext.this.setAuthenticationName(name);
                        }
                    }
                    catch (Exception e) {
                        throw new IOException(e);
                    }
                    this.handleOne(callbacks, idx + 1);
                } else if (callback instanceof NameCallback) {
                    String name = ((NameCallback)callback).getDefaultName();
                    try {
                        ElytronMessages.log.tracef("Handling NameCallback: authenticationName = %s", (Object)name);
                        ServerAuthenticationContext.this.setAuthenticationName(name);
                    }
                    catch (Exception e) {
                        throw new IOException(e);
                    }
                    this.handleOne(callbacks, idx + 1);
                } else if (callback instanceof PeerPrincipalCallback) {
                    Principal principal = ((PeerPrincipalCallback)callback).getPrincipal();
                    try {
                        ElytronMessages.log.tracef("Handling PeerPrincipalCallback: principal = %s", (Object)principal);
                        ServerAuthenticationContext.this.setAuthenticationPrincipal(principal);
                    }
                    catch (Exception e) {
                        throw new IOException(e);
                    }
                    this.handleOne(callbacks, idx + 1);
                } else {
                    if (callback instanceof PasswordCallback) {
                        PasswordCallback passwordCallback = (PasswordCallback)callback;
                        if (ServerAuthenticationContext.this.getCredentialAcquireSupport(PasswordCredential.class).mayBeSupported()) {
                            TwoWayPassword password = ServerAuthenticationContext.this.applyToCredential(PasswordCredential.class, c -> c.getPassword(TwoWayPassword.class));
                            if (password != null) {
                                ClearPasswordSpec clearPasswordSpec;
                                try {
                                    PasswordFactory passwordFactory = PasswordFactory.getInstance(password.getAlgorithm());
                                    clearPasswordSpec = passwordFactory.getKeySpec(password, ClearPasswordSpec.class);
                                }
                                catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
                                    ElytronMessages.log.trace("Unable to get key spec", e);
                                    throw new FastUnsupportedCallbackException(callback);
                                }
                                ElytronMessages.log.tracef("Handling PasswordCallback: obtained successfully", new Object[0]);
                                passwordCallback.setPassword(clearPasswordSpec.getEncodedPassword());
                                this.handleOne(callbacks, idx + 1);
                                return;
                            }
                            ElytronMessages.log.tracef("Handling PasswordCallback: failed to obtain PasswordCredential", new Object[0]);
                            throw new FastUnsupportedCallbackException(callback);
                        }
                        ElytronMessages.log.tracef("Handling PasswordCallback: PasswordCredential may not be supported", new Object[0]);
                        throw new FastUnsupportedCallbackException(callback);
                    }
                    if (callback instanceof CredentialCallback) {
                        CredentialCallback credentialCallback = (CredentialCallback)callback;
                        String requestedRealm = stateRef.get().getMechanismRealmConfiguration().getRealmName();
                        Credential credential = ServerAuthenticationContext.this.getCredential(credentialCallback.getCredentialType(), credentialCallback.getAlgorithm(), credentialCallback.getParameterSpec());
                        if (credential != null) {
                            Password password;
                            if (credential instanceof PasswordCredential && (password = ((PasswordCredential)credential).getPassword()) != null && password instanceof DigestPassword) {
                                String providedRealm = ((DigestPassword)password).getRealm();
                                if (!providedRealm.equals(requestedRealm)) {
                                    ElytronMessages.log.tracef("Handling CredentialCallback: credential for realm \"%s\" is not available (\"%s\" provided)", (Object)requestedRealm, (Object)providedRealm);
                                    throw new FastUnsupportedCallbackException(callback);
                                }
                                ElytronMessages.log.tracef("Handling CredentialCallback: obtained credential for correct realm \"%s\"", (Object)providedRealm);
                            }
                            ElytronMessages.log.tracef("Handling CredentialCallback: obtained credential: %s", (Object)credential);
                            credentialCallback.setCredential(credential);
                            this.handleOne(callbacks, idx + 1);
                            return;
                        }
                        ElytronMessages.log.tracef("Handling CredentialCallback: failed to obtain credential", new Object[0]);
                        throw new FastUnsupportedCallbackException(callback);
                    }
                    if (callback instanceof ServerCredentialCallback) {
                        Credential credential;
                        AlgorithmParameterSpec parameterSpec;
                        String algorithm;
                        Class<? extends Credential> credentialType;
                        ServerCredentialCallback serverCredentialCallback = (ServerCredentialCallback)callback;
                        CredentialSource serverCredentialSource = stateRef.get().getMechanismConfiguration().getServerCredentialSource();
                        if (serverCredentialSource.getCredentialAcquireSupport(credentialType = serverCredentialCallback.getCredentialType(), algorithm = serverCredentialCallback.getAlgorithm(), parameterSpec = serverCredentialCallback.getParameterSpec()).mayBeSupported() && (credential = serverCredentialSource.getCredential(credentialType, algorithm, parameterSpec)) != null) {
                            ElytronMessages.log.tracef("Handling ServerCredentialCallback: successfully obtained credential type type=%s, algorithm=%s, params=%s", (Object)credentialType, (Object)algorithm, (Object)parameterSpec);
                            serverCredentialCallback.setCredential(credential);
                            this.handleOne(callbacks, idx + 1);
                            return;
                        }
                        ElytronMessages.log.tracef("Handling ServerCredentialCallback: skipping credential type type=%s, algorithm=%s, params=%s", (Object)credentialType, (Object)algorithm, (Object)parameterSpec);
                        this.handleOne(callbacks, idx + 1);
                    } else if (callback instanceof EvidenceVerifyCallback) {
                        EvidenceVerifyCallback evidenceVerifyCallback = (EvidenceVerifyCallback)callback;
                        evidenceVerifyCallback.setVerified(ServerAuthenticationContext.this.verifyEvidence(evidenceVerifyCallback.getEvidence()));
                        this.handleOne(callbacks, idx + 1);
                    } else if (callback instanceof SSLCallback) {
                        SSLCallback sslCallback = (SSLCallback)callback;
                        try {
                            X509Certificate[] x509Certificates = X500.asX509CertificateArray(sslCallback.getSslSession().getPeerCertificates());
                            ServerAuthenticationContext.this.verifyEvidence(new X509PeerCertificateChainEvidence(x509Certificates));
                            this.certs = x509Certificates;
                        }
                        catch (SSLPeerUnverifiedException e) {
                            ElytronMessages.log.trace("Peer unverified", e);
                        }
                        this.handleOne(callbacks, idx + 1);
                    } else if (callback instanceof ChannelBindingCallback) {
                        TLSServerEndPointChannelBinding.handleChannelBindingCallback((ChannelBindingCallback)callback, this.certs);
                        this.handleOne(callbacks, idx + 1);
                    } else if (callback instanceof AuthenticationCompleteCallback) {
                        if (!ServerAuthenticationContext.this.isDone()) {
                            if (((AuthenticationCompleteCallback)callback).succeeded()) {
                                ElytronMessages.log.tracef("Handling AuthenticationCompleteCallback: succeed", new Object[0]);
                                ServerAuthenticationContext.this.succeed();
                            } else {
                                ElytronMessages.log.tracef("Handling AuthenticationCompleteCallback: fail", new Object[0]);
                                ServerAuthenticationContext.this.fail();
                            }
                        }
                        this.handleOne(callbacks, idx + 1);
                    } else if (callback instanceof SocketAddressCallback) {
                        SocketAddressCallback socketAddressCallback = (SocketAddressCallback)callback;
                        ElytronMessages.log.tracef("Handling SocketAddressCallback", new Object[0]);
                        if (socketAddressCallback.getKind() == SocketAddressCallback.Kind.PEER) {
                            // empty if block
                        }
                        this.handleOne(callbacks, idx + 1);
                    } else if (callback instanceof SecurityIdentityCallback) {
                        SecurityIdentity identity = ServerAuthenticationContext.this.getAuthorizedIdentity();
                        ElytronMessages.log.tracef("Handling SecurityIdentityCallback: identity = %s", (Object)identity);
                        ((SecurityIdentityCallback)callback).setSecurityIdentity(identity);
                        this.handleOne(callbacks, idx + 1);
                    } else if (callback instanceof AvailableRealmsCallback) {
                        Collection<String> names = stateRef.get().getMechanismConfiguration().getMechanismRealmNames();
                        if (ElytronMessages.log.isTraceEnabled()) {
                            ElytronMessages.log.tracef("Handling AvailableRealmsCallback: realms = [%s]", (Object)String.join((CharSequence)", ", names));
                        }
                        if (!names.isEmpty()) {
                            ((AvailableRealmsCallback)callback).setRealmNames(names.toArray(new String[names.size()]));
                        }
                        this.handleOne(callbacks, idx + 1);
                    } else if (callback instanceof RealmCallback) {
                        RealmCallback rcb = (RealmCallback)callback;
                        String mechanismRealm = rcb.getText();
                        if (mechanismRealm == null) {
                            mechanismRealm = rcb.getDefaultText();
                        }
                        ElytronMessages.log.tracef("Handling RealmCallback: selected = [%s]", (Object)mechanismRealm);
                        ServerAuthenticationContext.this.setMechanismRealmName(mechanismRealm);
                        this.handleOne(callbacks, idx + 1);
                    } else if (callback instanceof MechanismInformationCallback) {
                        MechanismInformationCallback mic = (MechanismInformationCallback)callback;
                        try {
                            MechanismInformation mi = mic.getMechanismInformation();
                            if (ElytronMessages.log.isTraceEnabled()) {
                                ElytronMessages.log.tracef("Handling MechanismInformationCallback type='%s' name='%s' host-name='%s' protocol='%s'", mi.getMechanismType(), mi.getMechanismName(), mi.getHostName(), mi.getProtocol());
                            }
                            ServerAuthenticationContext.this.setMechanismInformation(mi);
                            this.handleOne(callbacks, idx + 1);
                        }
                        catch (Exception e) {
                            throw new IOException(e);
                        }
                    } else if (callback instanceof CredentialUpdateCallback) {
                        CredentialUpdateCallback credentialUpdateCallback = (CredentialUpdateCallback)callback;
                        ElytronMessages.log.tracef("Handling CredentialUpdateCallback", new Object[0]);
                        ServerAuthenticationContext.this.updateCredential(credentialUpdateCallback.getCredential());
                        this.handleOne(callbacks, idx + 1);
                    } else if (callback instanceof CachedIdentityAuthorizeCallback) {
                        CachedIdentityAuthorizeCallback authorizeCallback = (CachedIdentityAuthorizeCallback)callback;
                        authorizeCallback.setSecurityDomain(stateRef.get().getSecurityDomain());
                        SecurityIdentity authorizedIdentity = null;
                        Principal principal = null;
                        SecurityIdentity identity = authorizeCallback.getIdentity();
                        if (identity != null && ServerAuthenticationContext.this.importIdentity(identity)) {
                            authorizedIdentity = ServerAuthenticationContext.this.getAuthorizedIdentity();
                        } else {
                            principal = authorizeCallback.getPrincipal();
                            if (principal == null) {
                                principal = authorizeCallback.getAuthorizationPrincipal();
                            }
                            if (principal != null) {
                                ServerAuthenticationContext.this.setAuthenticationPrincipal(principal);
                                ServerAuthenticationContext.this.authorize();
                                authorizedIdentity = ServerAuthenticationContext.this.getAuthorizedIdentity();
                            }
                        }
                        ElytronMessages.log.tracef("Handling CachedIdentityAuthorizeCallback: principal = %s  authorizedIdentity = %s", (Object)principal, (Object)authorizedIdentity);
                        authorizeCallback.setAuthorized(authorizedIdentity);
                        this.handleOne(callbacks, idx + 1);
                    } else if (callback instanceof IdentityCredentialCallback) {
                        IdentityCredentialCallback icc = (IdentityCredentialCallback)callback;
                        Credential credential = icc.getCredential();
                        if (icc.isPrivate()) {
                            ServerAuthenticationContext.this.addPrivateCredential(credential);
                        } else {
                            ServerAuthenticationContext.this.addPublicCredential(credential);
                        }
                        this.handleOne(callbacks, idx + 1);
                    } else {
                        CallbackUtil.unsupported(callback);
                    }
                }
            }
        };
    }

    private static Principal rewriteAll(Principal principal, Function<Principal, Principal> r1, Function<Principal, Principal> r2, Function<Principal, Principal> r3) {
        if ((principal = r1.apply(principal)) == null) {
            return null;
        }
        if ((principal = r2.apply(principal)) == null) {
            return null;
        }
        principal = r3.apply(principal);
        return principal;
    }

    static String mapAll(Principal principal, RealmMapper r1, RealmMapper r2, RealmMapper r3, String defaultRealmName) {
        if (r1 != null) {
            return ServerAuthenticationContext.mapRealmName(principal, r1, defaultRealmName);
        }
        if (r2 != null) {
            return ServerAuthenticationContext.mapRealmName(principal, r2, defaultRealmName);
        }
        if (r3 != null) {
            return ServerAuthenticationContext.mapRealmName(principal, r3, defaultRealmName);
        }
        return defaultRealmName;
    }

    private static String mapRealmName(Principal principal, RealmMapper realmMapper, String defaultRealmName) {
        String realmName = realmMapper.getRealmMapping(principal, null);
        return realmName != null ? realmName : defaultRealmName;
    }

    State assignName(SecurityIdentity capturedIdentity, MechanismConfiguration mechanismConfiguration, MechanismRealmConfiguration mechanismRealmConfiguration, Principal originalPrincipal, Evidence evidence, IdentityCredentials privateCredentials, IdentityCredentials publicCredentials) throws RealmUnavailableException {
        return this.assignName(capturedIdentity, mechanismConfiguration, mechanismRealmConfiguration, originalPrincipal, evidence, privateCredentials, publicCredentials, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    State assignName(SecurityIdentity capturedIdentity, MechanismConfiguration mechanismConfiguration, MechanismRealmConfiguration mechanismRealmConfiguration, Principal originalPrincipal, Evidence evidence, IdentityCredentials privateCredentials, IdentityCredentials publicCredentials, boolean exclusive) throws RealmUnavailableException {
        RealmIdentity realmIdentity;
        SecurityDomain domain = capturedIdentity.getSecurityDomain();
        Principal preRealmPrincipal = ServerAuthenticationContext.rewriteAll(originalPrincipal, mechanismRealmConfiguration.getPreRealmRewriter(), mechanismConfiguration.getPreRealmRewriter(), domain.getPreRealmRewriter());
        if (preRealmPrincipal == null) {
            ElytronMessages.log.tracef("Unable to rewrite principal [%s] by pre-realm rewritters", (Object)originalPrincipal);
            return new InvalidNameState(capturedIdentity, mechanismConfiguration, mechanismRealmConfiguration, privateCredentials, publicCredentials);
        }
        String realmName = ServerAuthenticationContext.mapAll(preRealmPrincipal, mechanismRealmConfiguration.getRealmMapper(), mechanismConfiguration.getRealmMapper(), domain.getRealmMapper(), domain.getDefaultRealmName());
        RealmInfo realmInfo = domain.getRealmInfo(realmName);
        Principal postRealmPrincipal = ServerAuthenticationContext.rewriteAll(preRealmPrincipal, mechanismRealmConfiguration.getPostRealmRewriter(), mechanismConfiguration.getPostRealmRewriter(), domain.getPostRealmRewriter());
        if (postRealmPrincipal == null) {
            ElytronMessages.log.tracef("Unable to rewrite principal [%s] by post-realm rewritters", (Object)preRealmPrincipal);
            return new InvalidNameState(capturedIdentity, mechanismConfiguration, mechanismRealmConfiguration, privateCredentials, publicCredentials);
        }
        Principal finalPrincipal = ServerAuthenticationContext.rewriteAll(postRealmPrincipal, mechanismRealmConfiguration.getFinalRewriter(), mechanismConfiguration.getFinalRewriter(), realmInfo.getPrincipalRewriter());
        if (finalPrincipal == null) {
            ElytronMessages.log.tracef("Unable to rewrite principal [%s] by final rewritters", (Object)postRealmPrincipal);
            return new InvalidNameState(capturedIdentity, mechanismConfiguration, mechanismRealmConfiguration, privateCredentials, publicCredentials);
        }
        ElytronMessages.log.tracef("Principal assigning: [%s], pre-realm rewritten: [%s], realm name: [%s], post-realm rewritten: [%s], realm rewritten: [%s]", originalPrincipal, preRealmPrincipal, realmName, postRealmPrincipal, finalPrincipal);
        SecurityRealm securityRealm = realmInfo.getSecurityRealm();
        if (exclusive) {
            if (!(securityRealm instanceof ModifiableSecurityRealm)) throw ElytronMessages.log.unableToObtainExclusiveAccess();
            realmIdentity = ((ModifiableSecurityRealm)securityRealm).getRealmIdentityForUpdate(finalPrincipal);
            return new NameAssignedState(capturedIdentity, realmInfo, realmIdentity, preRealmPrincipal, mechanismConfiguration, mechanismRealmConfiguration, privateCredentials, publicCredentials);
        } else {
            realmIdentity = securityRealm.getRealmIdentity(finalPrincipal);
        }
        return new NameAssignedState(capturedIdentity, realmInfo, realmIdentity, preRealmPrincipal, mechanismConfiguration, mechanismRealmConfiguration, privateCredentials, publicCredentials);
    }

    static final class CompleteState
    extends State {
        private final SecurityIdentity identity;

        public CompleteState(SecurityIdentity identity) {
            this.identity = identity;
        }

        @Override
        SecurityIdentity getAuthorizedIdentity() {
            return this.identity;
        }

        @Override
        boolean isDone() {
            return true;
        }

        @Override
        void succeed() {
        }
    }

    final class AuthorizedAuthenticationState
    extends AuthorizedState {
        private final RealmIdentity realmIdentity;

        AuthorizedAuthenticationState(SecurityIdentity authorizedIdentity, Principal authenticationPrincipal, RealmInfo realmInfo, RealmIdentity realmIdentity, MechanismRealmConfiguration mechanismRealmConfiguration, MechanismConfiguration mechanismConfiguration) {
            super(authorizedIdentity, authenticationPrincipal, realmInfo, mechanismConfiguration, mechanismRealmConfiguration);
            this.realmIdentity = realmIdentity;
        }

        @Override
        SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec) throws RealmUnavailableException {
            return this.realmIdentity.getCredentialAcquireSupport(credentialType, algorithmName, parameterSpec);
        }

        @Override
        SupportLevel getEvidenceVerifySupport(Class<? extends Evidence> evidenceType, String algorithmName) throws RealmUnavailableException {
            return this.realmIdentity.getEvidenceVerifySupport(evidenceType, algorithmName);
        }

        @Override
        <C extends Credential> C getCredential(Class<C> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec) throws RealmUnavailableException {
            return this.realmIdentity.getCredential(credentialType, algorithmName, parameterSpec);
        }

        @Override
        boolean verifyEvidence(Evidence evidence) throws RealmUnavailableException {
            return this.realmIdentity.verifyEvidence(evidence);
        }

        @Override
        RealmIdentity getRealmIdentity() {
            return this.realmIdentity;
        }

        @Override
        void updateCredential(Credential credential) throws RealmUnavailableException {
            this.realmIdentity.updateCredential(credential);
        }

        @Override
        void succeed() {
            SecurityIdentity authorizedIdentity = this.getSourceIdentity();
            AtomicReference<State> stateRef = ServerAuthenticationContext.this.getStateRef();
            if (!stateRef.compareAndSet(this, new CompleteState(authorizedIdentity))) {
                stateRef.get().succeed();
                return;
            }
            SecurityRealm.safeHandleRealmEvent(this.getRealmInfo().getSecurityRealm(), new RealmSuccessfulAuthenticationEvent(this.realmIdentity, authorizedIdentity.getAuthorizationIdentity(), null, null));
            SecurityDomain.safeHandleSecurityEvent(authorizedIdentity.getSecurityDomain(), new SecurityAuthenticationSuccessfulEvent(authorizedIdentity));
            this.realmIdentity.dispose();
        }

        @Override
        void fail(boolean requireInProgress) {
            SecurityIdentity authorizedIdentity = this.getSourceIdentity();
            AtomicReference<State> stateRef = ServerAuthenticationContext.this.getStateRef();
            if (!stateRef.compareAndSet(this, FAILED)) {
                stateRef.get().fail(requireInProgress);
                return;
            }
            SecurityRealm.safeHandleRealmEvent(this.getRealmInfo().getSecurityRealm(), new RealmFailedAuthenticationEvent(this.realmIdentity, null, null));
            SecurityDomain.safeHandleSecurityEvent(authorizedIdentity.getSecurityDomain(), new SecurityAuthenticationFailedEvent(authorizedIdentity, this.realmIdentity.getRealmIdentityPrincipal()));
            this.realmIdentity.dispose();
        }

        @Override
        void addPublicCredential(Credential credential) {
            SecurityIdentity sourceIdentity = this.getSourceIdentity();
            AuthorizedAuthenticationState newState = new AuthorizedAuthenticationState(sourceIdentity.withPublicCredential(credential), this.getAuthenticationPrincipal(), this.getRealmInfo(), this.getRealmIdentity(), this.getMechanismRealmConfiguration(), this.getMechanismConfiguration());
            if (!ServerAuthenticationContext.this.stateRef.compareAndSet(this, newState)) {
                ((State)ServerAuthenticationContext.this.stateRef.get()).addPublicCredential(credential);
            }
        }

        @Override
        void addPrivateCredential(Credential credential) {
            SecurityIdentity sourceIdentity = this.getSourceIdentity();
            AuthorizedAuthenticationState newState = new AuthorizedAuthenticationState(sourceIdentity.withPrivateCredential(credential), this.getAuthenticationPrincipal(), this.getRealmInfo(), this.getRealmIdentity(), this.getMechanismRealmConfiguration(), this.getMechanismConfiguration());
            if (!ServerAuthenticationContext.this.stateRef.compareAndSet(this, newState)) {
                ((State)ServerAuthenticationContext.this.stateRef.get()).addPrivateCredential(credential);
            }
        }
    }

    class AuthorizedState
    extends ActiveState {
        private final SecurityIdentity authorizedIdentity;
        private final Principal authenticationPrincipal;
        private final RealmInfo realmInfo;
        private final MechanismConfiguration mechanismConfiguration;
        private final MechanismRealmConfiguration mechanismRealmConfiguration;

        AuthorizedState(SecurityIdentity authorizedIdentity, Principal authenticationPrincipal, RealmInfo realmInfo, MechanismConfiguration mechanismConfiguration, MechanismRealmConfiguration mechanismRealmConfiguration) {
            this.authorizedIdentity = authorizedIdentity;
            this.authenticationPrincipal = authenticationPrincipal;
            this.realmInfo = realmInfo;
            this.mechanismConfiguration = mechanismConfiguration;
            this.mechanismRealmConfiguration = mechanismRealmConfiguration;
        }

        @Override
        MechanismRealmConfiguration getMechanismRealmConfiguration() {
            return this.mechanismRealmConfiguration;
        }

        @Override
        MechanismConfiguration getMechanismConfiguration() {
            return this.mechanismConfiguration;
        }

        @Override
        SecurityIdentity getAuthorizedIdentity() {
            return this.authorizedIdentity;
        }

        @Override
        Principal getAuthenticationPrincipal() {
            return this.authenticationPrincipal;
        }

        @Override
        SecurityDomain getSecurityDomain() {
            return this.authorizedIdentity.getSecurityDomain();
        }

        @Override
        SecurityIdentity getSourceIdentity() {
            return this.authorizedIdentity;
        }

        @Override
        boolean isSamePrincipal(Principal principal) {
            SecurityDomain domain = this.authorizedIdentity.getSecurityDomain();
            principal = ServerAuthenticationContext.rewriteAll(principal, this.mechanismRealmConfiguration.getPreRealmRewriter(), this.mechanismConfiguration.getPreRealmRewriter(), domain.getPreRealmRewriter());
            return this.authenticationPrincipal.equals(principal);
        }

        RealmInfo getRealmInfo() {
            return this.realmInfo;
        }

        @Override
        boolean authorize(boolean requireLoginPermission) throws RealmUnavailableException {
            return !requireLoginPermission || this.authorizedIdentity.implies(LoginPermission.getInstance());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        AuthorizedState authorizeRunAs(Principal authorizationId, boolean authorizeRunAs) throws RealmUnavailableException {
            if (this.isSamePrincipal(authorizationId)) {
                ElytronMessages.log.trace("RunAs authorization succeed - the same identity");
                return this;
            }
            State state = ServerAuthenticationContext.this.assignName(this.authorizedIdentity, this.getMechanismConfiguration(), this.getMechanismRealmConfiguration(), authorizationId, null, IdentityCredentials.NONE, IdentityCredentials.NONE);
            if (!(state instanceof NameAssignedState)) {
                ElytronMessages.log.tracef("RunAs authorization failed - unable to assign identity name", new Object[0]);
                return null;
            }
            NameAssignedState nameAssignedState = (NameAssignedState)state;
            RealmIdentity realmIdentity = nameAssignedState.getRealmIdentity();
            boolean ok = false;
            try {
                String targetName = nameAssignedState.getAuthenticationPrincipal().getName();
                if (authorizeRunAs && !this.authorizedIdentity.implies(new RunAsPrincipalPermission(targetName))) {
                    ElytronMessages.log.tracef("RunAs authorization failed - identity does not have required RunAsPrincipalPermission(%s)", (Object)targetName);
                    AuthorizedState authorizedState = null;
                    return authorizedState;
                }
                AuthorizedAuthenticationState newState = nameAssignedState.doAuthorization(false);
                if (newState == null) {
                    ElytronMessages.log.trace("RunAs authorization failed");
                    AuthorizedState authorizedState = null;
                    return authorizedState;
                }
                ok = true;
                ElytronMessages.log.trace("RunAs authorization succeed");
                AuthorizedAuthenticationState authorizedAuthenticationState = newState;
                return authorizedAuthenticationState;
            }
            finally {
                if (!ok) {
                    realmIdentity.dispose();
                }
            }
        }

        @Override
        void succeed() {
            if (this.authorizedIdentity != null) {
                return;
            }
            super.succeed();
        }

        @Override
        void addPublicCredential(Credential credential) {
            SecurityIdentity sourceIdentity = this.getSourceIdentity();
            AuthorizedState newState = new AuthorizedState(sourceIdentity.withPublicCredential(credential), this.getAuthenticationPrincipal(), this.getRealmInfo(), this.getMechanismConfiguration(), this.getMechanismRealmConfiguration());
            if (!ServerAuthenticationContext.this.stateRef.compareAndSet(this, newState)) {
                ((State)ServerAuthenticationContext.this.stateRef.get()).addPublicCredential(credential);
            }
        }

        @Override
        void addPrivateCredential(Credential credential) {
            SecurityIdentity sourceIdentity = this.getSourceIdentity();
            AuthorizedState newState = new AuthorizedState(sourceIdentity.withPrivateCredential(credential), this.getAuthenticationPrincipal(), this.getRealmInfo(), this.getMechanismConfiguration(), this.getMechanismRealmConfiguration());
            if (!ServerAuthenticationContext.this.stateRef.compareAndSet(this, newState)) {
                ((State)ServerAuthenticationContext.this.stateRef.get()).addPrivateCredential(credential);
            }
        }
    }

    final class AnonymousAuthorizedState
    extends ActiveState {
        private final SecurityIdentity anonymousIdentity;

        AnonymousAuthorizedState(SecurityIdentity anonymousIdentity) {
            this.anonymousIdentity = anonymousIdentity;
        }

        @Override
        MechanismConfiguration getMechanismConfiguration() {
            return MechanismConfiguration.EMPTY;
        }

        @Override
        MechanismRealmConfiguration getMechanismRealmConfiguration() {
            return MechanismRealmConfiguration.NO_REALM;
        }

        @Override
        SecurityIdentity getAuthorizedIdentity() {
            return this.anonymousIdentity;
        }

        @Override
        Principal getAuthenticationPrincipal() {
            return AnonymousPrincipal.getInstance();
        }

        @Override
        boolean isSamePrincipal(Principal principal) {
            return principal instanceof AnonymousPrincipal;
        }

        @Override
        SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec) throws RealmUnavailableException {
            return SupportLevel.UNSUPPORTED;
        }

        @Override
        SupportLevel getEvidenceVerifySupport(Class<? extends Evidence> evidenceType, String algorithmName) throws RealmUnavailableException {
            return SupportLevel.UNSUPPORTED;
        }

        @Override
        <C extends Credential> C getCredential(Class<C> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec) throws RealmUnavailableException {
            return null;
        }

        @Override
        boolean verifyEvidence(Evidence evidence) throws RealmUnavailableException {
            return false;
        }

        @Override
        RealmIdentity getRealmIdentity() {
            return RealmIdentity.ANONYMOUS;
        }

        @Override
        SecurityDomain getSecurityDomain() {
            return this.anonymousIdentity.getSecurityDomain();
        }

        @Override
        boolean authorizeAnonymous(boolean requireLoginPermission) {
            return true;
        }

        @Override
        void setPrincipal(Principal principal, boolean exclusive) throws RealmUnavailableException {
            if (!(principal instanceof AnonymousPrincipal)) {
                super.setPrincipal(principal, exclusive);
            }
        }

        @Override
        boolean authorize(boolean requireLoginPermission) throws RealmUnavailableException {
            return !requireLoginPermission || this.anonymousIdentity.implies(LoginPermission.getInstance());
        }

        @Override
        void updateCredential(Credential credential) throws RealmUnavailableException {
        }

        @Override
        void succeed() {
            AtomicReference<State> stateRef = ServerAuthenticationContext.this.getStateRef();
            if (!stateRef.compareAndSet(this, new CompleteState(this.anonymousIdentity))) {
                stateRef.get().succeed();
            }
        }

        @Override
        void fail(boolean requireInProgress) {
            AtomicReference<State> stateRef = ServerAuthenticationContext.this.getStateRef();
            if (!stateRef.compareAndSet(this, FAILED)) {
                stateRef.get().fail(requireInProgress);
            }
        }

        @Override
        SecurityIdentity getSourceIdentity() {
            return this.anonymousIdentity;
        }
    }

    final class NameAssignedState
    extends ActiveState {
        private final SecurityIdentity capturedIdentity;
        private final RealmInfo realmInfo;
        private final RealmIdentity realmIdentity;
        private final Principal authenticationPrincipal;
        private final MechanismConfiguration mechanismConfiguration;
        private final MechanismRealmConfiguration mechanismRealmConfiguration;
        private final IdentityCredentials privateCredentials;
        private final IdentityCredentials publicCredentials;

        NameAssignedState(SecurityIdentity capturedIdentity, RealmInfo realmInfo, RealmIdentity realmIdentity, Principal authenticationPrincipal, MechanismConfiguration mechanismConfiguration, MechanismRealmConfiguration mechanismRealmConfiguration, IdentityCredentials privateCredentials, IdentityCredentials publicCredentials) {
            this.capturedIdentity = capturedIdentity;
            this.realmInfo = realmInfo;
            this.realmIdentity = realmIdentity;
            this.authenticationPrincipal = authenticationPrincipal;
            this.mechanismConfiguration = mechanismConfiguration;
            this.mechanismRealmConfiguration = mechanismRealmConfiguration;
            this.privateCredentials = privateCredentials;
            this.publicCredentials = publicCredentials;
        }

        @Override
        MechanismConfiguration getMechanismConfiguration() {
            return this.mechanismConfiguration;
        }

        @Override
        MechanismRealmConfiguration getMechanismRealmConfiguration() {
            return this.mechanismRealmConfiguration;
        }

        @Override
        Principal getAuthenticationPrincipal() {
            return this.authenticationPrincipal;
        }

        @Override
        RealmIdentity getRealmIdentity() {
            return this.realmIdentity;
        }

        @Override
        SecurityDomain getSecurityDomain() {
            return this.capturedIdentity.getSecurityDomain();
        }

        @Override
        SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec) throws RealmUnavailableException {
            return this.realmIdentity.getCredentialAcquireSupport(credentialType, algorithmName, parameterSpec);
        }

        @Override
        SupportLevel getEvidenceVerifySupport(Class<? extends Evidence> evidenceType, String algorithmName) throws RealmUnavailableException {
            return this.realmIdentity.getEvidenceVerifySupport(evidenceType, algorithmName);
        }

        @Override
        <C extends Credential> C getCredential(Class<C> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec) throws RealmUnavailableException {
            return this.realmIdentity.getCredential(credentialType, algorithmName, parameterSpec);
        }

        @Override
        boolean authorize(boolean requireLoginPermission) throws RealmUnavailableException {
            AuthorizedAuthenticationState newState = this.doAuthorization(requireLoginPermission);
            if (newState == null) {
                return false;
            }
            AtomicReference<State> stateRef = ServerAuthenticationContext.this.getStateRef();
            return stateRef.compareAndSet(this, newState) || stateRef.get().authorize(requireLoginPermission);
        }

        AuthorizedAuthenticationState doAuthorization(boolean requireLoginPermission) throws RealmUnavailableException {
            RealmIdentity realmIdentity = this.realmIdentity;
            if (!realmIdentity.exists()) {
                ElytronMessages.log.trace("Authorization failed - realm identity does not exists");
                return null;
            }
            RealmInfo realmInfo = this.realmInfo;
            Principal authenticationPrincipal = this.authenticationPrincipal;
            AuthorizationIdentity authorizationIdentity = realmIdentity.getAuthorizationIdentity();
            SecurityDomain domain = this.capturedIdentity.getSecurityDomain();
            SecurityIdentity authorizedIdentity = Assert.assertNotNull(domain.transform(new SecurityIdentity(domain, authenticationPrincipal, realmInfo, authorizationIdentity, domain.getCategoryRoleMappers(), this.capturedIdentity.getPublicCredentials(), this.capturedIdentity.getPrivateCredentialsPrivate())));
            authorizedIdentity = authorizedIdentity.withPublicCredentials(this.publicCredentials).withPrivateCredentials(this.privateCredentials);
            if (ElytronMessages.log.isTraceEnabled()) {
                ElytronMessages.log.tracef("Authorizing principal %s.", (Object)authenticationPrincipal.getName());
                if (authorizationIdentity != null) {
                    ElytronMessages.log.tracef("Authorizing against the following attributes: %s => %s", (Object)authorizationIdentity.getAttributes().keySet(), (Object)authorizationIdentity.getAttributes().values());
                } else {
                    ElytronMessages.log.tracef("Authorizing against the following attributes: Cannot obtain the attributes. Authorization Identity is null.", new Object[0]);
                }
            }
            if (requireLoginPermission) {
                if (!authorizedIdentity.implies(LoginPermission.getInstance())) {
                    SecurityRealm.safeHandleRealmEvent(realmInfo.getSecurityRealm(), new RealmIdentityFailedAuthorizationEvent(authorizedIdentity.getAuthorizationIdentity(), authorizedIdentity.getPrincipal(), authenticationPrincipal));
                    ElytronMessages.log.trace("Authorization failed - identity does not have required LoginPermission");
                    return null;
                }
                SecurityRealm.safeHandleRealmEvent(realmInfo.getSecurityRealm(), new RealmIdentitySuccessfulAuthorizationEvent(authorizedIdentity.getAuthorizationIdentity(), authorizedIdentity.getPrincipal(), authenticationPrincipal));
            }
            ElytronMessages.log.trace("Authorization succeed");
            return new AuthorizedAuthenticationState(authorizedIdentity, authenticationPrincipal, realmInfo, realmIdentity, this.mechanismRealmConfiguration, this.mechanismConfiguration);
        }

        @Override
        boolean authorize(Principal authorizationId, boolean authorizeRunAs) throws RealmUnavailableException {
            AuthorizedAuthenticationState authzState = this.doAuthorization(true);
            if (authzState == null) {
                return false;
            }
            AuthorizedState newState = authzState.authorizeRunAs(authorizationId, authorizeRunAs);
            if (newState == null) {
                return false;
            }
            AtomicReference<State> stateRef = ServerAuthenticationContext.this.getStateRef();
            if (!stateRef.compareAndSet(this, newState)) {
                return stateRef.get().authorize(authorizationId, authorizeRunAs);
            }
            if (newState != authzState) {
                this.getRealmIdentity().dispose();
            }
            return true;
        }

        @Override
        SecurityIdentity getSourceIdentity() {
            return this.capturedIdentity;
        }

        @Override
        boolean verifyEvidence(Evidence evidence) throws RealmUnavailableException {
            Principal evidencePrincipal = evidence.getPrincipal();
            return (evidencePrincipal == null || this.isSamePrincipal(evidencePrincipal)) && this.getRealmIdentity().verifyEvidence(evidence);
        }

        @Override
        void updateCredential(Credential credential) throws RealmUnavailableException {
            this.realmIdentity.updateCredential(credential);
        }

        @Override
        void succeed() {
            throw ElytronMessages.log.cannotSucceedNotAuthorized();
        }

        @Override
        void fail(boolean requireInProgress) {
            SecurityIdentity capturedIdentity = this.getSourceIdentity();
            AtomicReference<State> stateRef = ServerAuthenticationContext.this.getStateRef();
            if (!stateRef.compareAndSet(this, FAILED)) {
                stateRef.get().fail(requireInProgress);
                return;
            }
            SecurityRealm.safeHandleRealmEvent(this.getRealmInfo().getSecurityRealm(), new RealmFailedAuthenticationEvent(this.realmIdentity, null, null));
            SecurityDomain.safeHandleSecurityEvent(capturedIdentity.getSecurityDomain(), new SecurityAuthenticationFailedEvent(capturedIdentity, this.realmIdentity.getRealmIdentityPrincipal()));
            this.realmIdentity.dispose();
        }

        @Override
        void setPrincipal(Principal principal, boolean exclusive) {
            if (this.isSamePrincipal(principal)) {
                return;
            }
            throw ElytronMessages.log.nameAlreadySet();
        }

        @Override
        boolean isSamePrincipal(Principal principal) {
            SecurityDomain domain = this.capturedIdentity.getSecurityDomain();
            principal = ServerAuthenticationContext.rewriteAll(principal, this.mechanismRealmConfiguration.getPreRealmRewriter(), this.mechanismConfiguration.getPreRealmRewriter(), domain.getPreRealmRewriter());
            return this.authenticationPrincipal.equals(principal);
        }

        @Override
        void addPublicCredential(Credential credential) {
            NameAssignedState newState = new NameAssignedState(this.getSourceIdentity(), this.getRealmInfo(), this.getRealmIdentity(), this.getAuthenticationPrincipal(), this.getMechanismConfiguration(), this.getMechanismRealmConfiguration(), this.privateCredentials, this.publicCredentials.withCredential(credential));
            if (!ServerAuthenticationContext.this.stateRef.compareAndSet(this, newState)) {
                ((State)ServerAuthenticationContext.this.stateRef.get()).addPublicCredential(credential);
            }
        }

        @Override
        void addPrivateCredential(Credential credential) {
            NameAssignedState newState = new NameAssignedState(this.getSourceIdentity(), this.getRealmInfo(), this.getRealmIdentity(), this.getAuthenticationPrincipal(), this.getMechanismConfiguration(), this.getMechanismRealmConfiguration(), this.privateCredentials.withCredential(credential), this.publicCredentials);
            if (!ServerAuthenticationContext.this.stateRef.compareAndSet(this, newState)) {
                ((State)ServerAuthenticationContext.this.stateRef.get()).addPublicCredential(credential);
            }
        }

        RealmInfo getRealmInfo() {
            return this.realmInfo;
        }
    }

    final class InvalidNameState
    extends UnassignedState {
        final MechanismRealmConfiguration mechanismRealmConfiguration;

        InvalidNameState(SecurityIdentity capturedIdentity, MechanismConfiguration mechanismConfiguration, MechanismRealmConfiguration mechanismRealmConfiguration, IdentityCredentials privateCredentials, IdentityCredentials publicCredentials) {
            super(capturedIdentity, mechanismConfiguration, privateCredentials, publicCredentials);
            this.mechanismRealmConfiguration = mechanismRealmConfiguration;
        }

        @Override
        MechanismRealmConfiguration getMechanismRealmConfiguration() {
            return this.mechanismRealmConfiguration;
        }

        @Override
        RealmIdentity getRealmIdentity() {
            return RealmIdentity.NON_EXISTENT;
        }

        @Override
        void fail(boolean requireInProgress) {
            AtomicReference<State> stateRef = ServerAuthenticationContext.this.getStateRef();
            if (!stateRef.compareAndSet(this, FAILED)) {
                stateRef.get().fail(requireInProgress);
            }
        }

        @Override
        boolean isDone() {
            return true;
        }
    }

    final class RealmAssignedState
    extends UnassignedState {
        final MechanismRealmConfiguration mechanismRealmConfiguration;

        RealmAssignedState(SecurityIdentity capturedIdentity, MechanismConfiguration mechanismConfiguration, MechanismRealmConfiguration mechanismRealmConfiguration, IdentityCredentials privateCredentials, IdentityCredentials publicCredentials) {
            super(capturedIdentity, mechanismConfiguration, privateCredentials, publicCredentials);
            this.mechanismRealmConfiguration = mechanismRealmConfiguration;
        }

        @Override
        MechanismRealmConfiguration getMechanismRealmConfiguration() {
            return this.mechanismRealmConfiguration;
        }

        @Override
        void addPublicCredential(Credential credential) {
            RealmAssignedState newState = new RealmAssignedState(this.getSourceIdentity(), this.getMechanismConfiguration(), this.getMechanismRealmConfiguration(), this.getPrivateCredentials(), this.getPublicCredentials().withCredential(credential));
            if (!ServerAuthenticationContext.this.stateRef.compareAndSet(this, newState)) {
                ((State)ServerAuthenticationContext.this.stateRef.get()).addPublicCredential(credential);
            }
        }

        @Override
        void addPrivateCredential(Credential credential) {
            RealmAssignedState newState = new RealmAssignedState(this.getSourceIdentity(), this.getMechanismConfiguration(), this.getMechanismRealmConfiguration(), this.getPrivateCredentials().withCredential(credential), this.getPublicCredentials());
            if (!ServerAuthenticationContext.this.stateRef.compareAndSet(this, newState)) {
                ((State)ServerAuthenticationContext.this.stateRef.get()).addPublicCredential(credential);
            }
        }
    }

    final class InitialState
    extends UnassignedState {
        private final MechanismConfigurationSelector mechanismConfigurationSelector;

        InitialState(SecurityIdentity capturedIdentity, MechanismConfiguration mechanismConfiguration, MechanismConfigurationSelector mechanismConfigurationSelector, IdentityCredentials privateCredentials, IdentityCredentials publicCredentials) {
            super(capturedIdentity, mechanismConfiguration, privateCredentials, publicCredentials);
            this.mechanismConfigurationSelector = mechanismConfigurationSelector;
        }

        @Override
        void setMechanismRealmName(String realmName) {
            MechanismConfiguration mechanismConfiguration = this.getMechanismConfiguration();
            if (mechanismConfiguration.getMechanismRealmNames().isEmpty()) {
                throw ElytronMessages.log.invalidMechRealmSelection(realmName);
            }
            MechanismRealmConfiguration configuration = mechanismConfiguration.getMechanismRealmConfiguration(realmName);
            if (configuration == null) {
                throw ElytronMessages.log.invalidMechRealmSelection(realmName);
            }
            AtomicReference<State> stateRef = ServerAuthenticationContext.this.getStateRef();
            if (!stateRef.compareAndSet(this, new RealmAssignedState(this.capturedIdentity, mechanismConfiguration, configuration, this.privateCredentials, this.publicCredentials))) {
                stateRef.get().setMechanismRealmName(realmName);
            }
        }

        @Override
        MechanismRealmConfiguration getMechanismRealmConfiguration() {
            Collection<String> mechanismRealmNames = this.mechanismConfiguration.getMechanismRealmNames();
            Iterator<String> iterator = mechanismRealmNames.iterator();
            if (iterator.hasNext()) {
                return this.mechanismConfiguration.getMechanismRealmConfiguration(iterator.next());
            }
            return MechanismRealmConfiguration.NO_REALM;
        }

        @Override
        void setMechanismInformation(MechanismInformation mechanismInformation) {
            InactiveState inactiveState = new InactiveState(this.capturedIdentity, this.mechanismConfigurationSelector, mechanismInformation, this.privateCredentials, this.publicCredentials);
            InitialState newState = inactiveState.selectMechanismConfiguration();
            if (!ServerAuthenticationContext.this.stateRef.compareAndSet(this, newState)) {
                ((State)ServerAuthenticationContext.this.stateRef.get()).setMechanismInformation(mechanismInformation);
            }
        }

        @Override
        void addPublicCredential(Credential credential) {
            InitialState newState = new InitialState(this.getSourceIdentity(), this.getMechanismConfiguration(), this.mechanismConfigurationSelector, this.getPrivateCredentials(), this.getPublicCredentials().withCredential(credential));
            if (!ServerAuthenticationContext.this.stateRef.compareAndSet(this, newState)) {
                ((State)ServerAuthenticationContext.this.stateRef.get()).addPublicCredential(credential);
            }
        }

        @Override
        void addPrivateCredential(Credential credential) {
            InitialState newState = new InitialState(this.getSourceIdentity(), this.getMechanismConfiguration(), this.mechanismConfigurationSelector, this.getPrivateCredentials().withCredential(credential), this.getPublicCredentials());
            if (!ServerAuthenticationContext.this.stateRef.compareAndSet(this, newState)) {
                ((State)ServerAuthenticationContext.this.stateRef.get()).addPublicCredential(credential);
            }
        }
    }

    abstract class UnassignedState
    extends ActiveState {
        final SecurityIdentity capturedIdentity;
        final MechanismConfiguration mechanismConfiguration;
        final IdentityCredentials privateCredentials;
        final IdentityCredentials publicCredentials;

        UnassignedState(SecurityIdentity capturedIdentity, MechanismConfiguration mechanismConfiguration, IdentityCredentials privateCredentials, IdentityCredentials publicCredentials) {
            this.capturedIdentity = capturedIdentity;
            this.mechanismConfiguration = mechanismConfiguration;
            this.privateCredentials = privateCredentials;
            this.publicCredentials = publicCredentials;
        }

        @Override
        SecurityIdentity getSourceIdentity() {
            return this.capturedIdentity;
        }

        @Override
        SecurityDomain getSecurityDomain() {
            return this.capturedIdentity.getSecurityDomain();
        }

        @Override
        void fail(boolean requireInProgress) {
            AtomicReference<State> stateRef = ServerAuthenticationContext.this.getStateRef();
            if (!stateRef.compareAndSet(this, FAILED)) {
                stateRef.get().fail(requireInProgress);
            }
        }

        @Override
        boolean authorizeAnonymous(boolean requireLoginPermission) {
            AtomicReference<State> stateRef = ServerAuthenticationContext.this.getStateRef();
            SecurityIdentity anonymousIdentity = this.getSecurityDomain().getAnonymousSecurityIdentity();
            return !(requireLoginPermission && !anonymousIdentity.implies(LoginPermission.getInstance()) || !stateRef.compareAndSet(this, new AnonymousAuthorizedState(anonymousIdentity)) && !stateRef.get().authorizeAnonymous(requireLoginPermission));
        }

        @Override
        boolean authorize(boolean requireLoginPermission) throws RealmUnavailableException {
            SecurityIdentity capturedIdentity = this.capturedIdentity;
            if (capturedIdentity.isAnonymous()) {
                return this.authorizeAnonymous(requireLoginPermission);
            }
            AtomicReference<State> stateRef = ServerAuthenticationContext.this.getStateRef();
            return !(requireLoginPermission && !capturedIdentity.implies(LoginPermission.getInstance()) || !stateRef.compareAndSet(this, new AuthorizedState(capturedIdentity, capturedIdentity.getPrincipal(), capturedIdentity.getRealmInfo(), this.mechanismConfiguration, this.getMechanismRealmConfiguration())) && !stateRef.get().authorize(requireLoginPermission));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        boolean importIdentity(SecurityIdentity importedIdentity) throws RealmUnavailableException {
            State state;
            RealmInfo evidenceRealmInfo = importedIdentity.getRealmInfo();
            SecurityRealm evidenceSecurityRealm = evidenceRealmInfo.getSecurityRealm();
            SecurityDomain evidenceSecurityDomain = importedIdentity.getSecurityDomain();
            AtomicReference<State> stateRef = ServerAuthenticationContext.this.getStateRef();
            SecurityIdentity sourceIdentity = this.getSourceIdentity();
            SecurityDomain domain = sourceIdentity.getSecurityDomain();
            if (importedIdentity.isAnonymous()) {
                AnonymousAuthorizedState newState = new AnonymousAuthorizedState(domain.getAnonymousSecurityIdentity());
                return stateRef.compareAndSet(this, newState) || stateRef.get().importIdentity(importedIdentity);
            }
            Principal importedPrincipal = importedIdentity.getPrincipal();
            if (domain == importedIdentity.getSecurityDomain()) {
                AuthorizedState newState = new AuthorizedState(importedIdentity, importedPrincipal, importedIdentity.getRealmInfo(), this.mechanismConfiguration, this.getMechanismRealmConfiguration());
                return stateRef.compareAndSet(this, newState) || stateRef.get().importIdentity(importedIdentity);
            }
            boolean trusted = false;
            if (domain.trustsDomain(evidenceSecurityDomain)) {
                trusted = true;
            }
            if (!((state = ServerAuthenticationContext.this.assignName(sourceIdentity, this.mechanismConfiguration, this.getMechanismRealmConfiguration(), importedPrincipal, null, this.privateCredentials, this.publicCredentials)) instanceof NameAssignedState)) {
                return false;
            }
            NameAssignedState nameState = (NameAssignedState)state;
            RealmIdentity realmIdentity = nameState.getRealmIdentity();
            boolean ok = false;
            try {
                if (!trusted && nameState.getRealmInfo().getSecurityRealm() != evidenceSecurityRealm) {
                    boolean bl = false;
                    return bl;
                }
                AuthorizedAuthenticationState authzState = nameState.doAuthorization(false);
                if (authzState == null) {
                    boolean bl = false;
                    return bl;
                }
                if (!stateRef.compareAndSet(this, authzState)) {
                    boolean bl = stateRef.get().importIdentity(importedIdentity);
                    return bl;
                }
                ok = true;
                boolean bl = true;
                return bl;
            }
            finally {
                if (!ok) {
                    realmIdentity.dispose();
                }
            }
        }

        @Override
        SupportLevel getEvidenceVerifySupport(Class<? extends Evidence> evidenceType, String algorithmName) throws RealmUnavailableException {
            return this.getSecurityDomain().getEvidenceVerifySupport(evidenceType, algorithmName);
        }

        @Override
        boolean verifyEvidence(Evidence evidence) throws RealmUnavailableException {
            AtomicReference<State> stateRef = ServerAuthenticationContext.this.getStateRef();
            Principal evidencePrincipal = evidence.getPrincipal();
            ElytronMessages.log.tracef("Evidence verification: evidence = %s  evidencePrincipal = %s", (Object)evidence, (Object)evidencePrincipal);
            MechanismRealmConfiguration mechanismRealmConfiguration = this.getMechanismRealmConfiguration();
            if (evidencePrincipal != null) {
                State newState = ServerAuthenticationContext.this.assignName(this.getSourceIdentity(), this.mechanismConfiguration, mechanismRealmConfiguration, evidencePrincipal, evidence, this.privateCredentials, this.publicCredentials);
                if (!newState.verifyEvidence(evidence)) {
                    if (newState instanceof NameAssignedState) {
                        ((NameAssignedState)newState).realmIdentity.dispose();
                    }
                    return false;
                }
                if (!stateRef.compareAndSet(this, newState)) {
                    if (newState instanceof NameAssignedState) {
                        ((NameAssignedState)newState).realmIdentity.dispose();
                    }
                    return stateRef.get().verifyEvidence(evidence);
                }
                return true;
            }
            Class<?> evidenceType = evidence.getClass();
            String algorithm = evidence instanceof AlgorithmEvidence ? ((AlgorithmEvidence)evidence).getAlgorithm() : null;
            SecurityDomain domain = this.getSecurityDomain();
            Collection<RealmInfo> realmInfos = domain.getRealmInfos();
            RealmIdentity realmIdentity = null;
            RealmInfo realmInfo = null;
            for (RealmInfo info : realmInfos) {
                realmIdentity = info.getSecurityRealm().getRealmIdentity(evidence);
                if (realmIdentity.getEvidenceVerifySupport(evidenceType, algorithm).mayBeSupported()) {
                    realmInfo = info;
                    break;
                }
                realmIdentity.dispose();
            }
            if (realmInfo == null) {
                return false;
            }
            Principal resolvedPrincipal = realmIdentity.getRealmIdentityPrincipal();
            if (resolvedPrincipal == null) {
                realmIdentity.dispose();
                return false;
            }
            if (!realmIdentity.verifyEvidence(evidence)) {
                realmIdentity.dispose();
                return false;
            }
            NameAssignedState newState = new NameAssignedState(this.getSourceIdentity(), realmInfo, realmIdentity, resolvedPrincipal, this.mechanismConfiguration, mechanismRealmConfiguration, this.privateCredentials, this.publicCredentials);
            if (!stateRef.compareAndSet(this, newState)) {
                realmIdentity.dispose();
                return stateRef.get().verifyEvidence(evidence);
            }
            return true;
        }

        @Override
        void setPrincipal(Principal principal, boolean exclusive) throws RealmUnavailableException {
            Assert.checkNotNullParam("principal", principal);
            AtomicReference<State> stateRef = ServerAuthenticationContext.this.getStateRef();
            State newState = ServerAuthenticationContext.this.assignName(this.capturedIdentity, this.mechanismConfiguration, this.getMechanismRealmConfiguration(), principal, null, this.privateCredentials, this.publicCredentials, exclusive);
            if (!stateRef.compareAndSet(this, newState)) {
                if (newState instanceof NameAssignedState) {
                    ((NameAssignedState)newState).realmIdentity.dispose();
                }
                stateRef.get().setPrincipal(principal, exclusive);
            }
        }

        @Override
        MechanismConfiguration getMechanismConfiguration() {
            return this.mechanismConfiguration;
        }

        IdentityCredentials getPrivateCredentials() {
            return this.privateCredentials;
        }

        IdentityCredentials getPublicCredentials() {
            return this.publicCredentials;
        }
    }

    abstract class ActiveState
    extends State {
        ActiveState() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        boolean authorize(Principal authorizationId, boolean authorizeRunAs) throws RealmUnavailableException {
            AtomicReference<State> stateRef = ServerAuthenticationContext.this.getStateRef();
            SecurityIdentity sourceIdentity = this.getSourceIdentity();
            State state = ServerAuthenticationContext.this.assignName(sourceIdentity, this.getMechanismConfiguration(), this.getMechanismRealmConfiguration(), authorizationId, null, IdentityCredentials.NONE, IdentityCredentials.NONE);
            if (!(state instanceof NameAssignedState)) {
                ElytronMessages.log.tracef("Authorization failed - unable to assign identity name", new Object[0]);
                return false;
            }
            NameAssignedState nameAssignedState = (NameAssignedState)state;
            RealmIdentity realmIdentity = nameAssignedState.getRealmIdentity();
            boolean ok = false;
            try {
                if (!realmIdentity.exists()) {
                    ElytronMessages.log.tracef("Authorization failed - identity does not exists", new Object[0]);
                    boolean bl = false;
                    return bl;
                }
                if (authorizeRunAs && !sourceIdentity.implies(new RunAsPrincipalPermission(nameAssignedState.getAuthenticationPrincipal().getName()))) {
                    ElytronMessages.log.tracef("Authorization failed - source identity does not have RunAsPrincipalPermission", new Object[0]);
                    boolean bl = false;
                    return bl;
                }
                AuthorizedAuthenticationState newState = nameAssignedState.doAuthorization(false);
                if (newState == null) {
                    boolean bl = false;
                    return bl;
                }
                if (!stateRef.compareAndSet(this, newState)) {
                    boolean bl = stateRef.get().authorize(authorizationId, authorizeRunAs);
                    return bl;
                }
                ok = true;
                boolean bl = true;
                return bl;
            }
            finally {
                if (!ok) {
                    realmIdentity.dispose();
                }
            }
        }

        @Override
        void setMechanismRealmName(String realmName) {
            MechanismRealmConfiguration currentConfiguration = this.getMechanismRealmConfiguration();
            MechanismConfiguration mechanismConfiguration = this.getMechanismConfiguration();
            if (mechanismConfiguration.getMechanismRealmNames().isEmpty()) {
                throw ElytronMessages.log.invalidMechRealmSelection(realmName);
            }
            MechanismRealmConfiguration configuration = mechanismConfiguration.getMechanismRealmConfiguration(realmName);
            if (configuration == null) {
                throw ElytronMessages.log.invalidMechRealmSelection(realmName);
            }
            if (currentConfiguration != configuration) {
                throw ElytronMessages.log.mechRealmAlreadySelected();
            }
        }

        @Override
        void setMechanismInformation(MechanismInformation mechanismInformation) {
            throw ElytronMessages.log.tooLateToSetMechanismInformation();
        }

        abstract SecurityIdentity getSourceIdentity();
    }

    final class InactiveState
    extends State {
        private final SecurityIdentity capturedIdentity;
        private final MechanismConfigurationSelector mechanismConfigurationSelector;
        private final MechanismInformation mechanismInformation;
        private final IdentityCredentials privateCredentials;
        private final IdentityCredentials publicCredentials;

        public InactiveState(SecurityIdentity capturedIdentity, MechanismConfigurationSelector mechanismConfigurationSelector, IdentityCredentials privateCredentials, IdentityCredentials publicCredentials) {
            this(capturedIdentity, mechanismConfigurationSelector, MechanismInformation.DEFAULT, privateCredentials, publicCredentials);
        }

        public InactiveState(SecurityIdentity capturedIdentity, MechanismConfigurationSelector mechanismConfigurationSelector, MechanismInformation mechanismInformation, IdentityCredentials privateCredentials, IdentityCredentials publicCredentials) {
            this.capturedIdentity = capturedIdentity;
            this.mechanismConfigurationSelector = mechanismConfigurationSelector;
            this.mechanismInformation = Assert.checkNotNullParam("mechanismInformation", mechanismInformation);
            this.privateCredentials = privateCredentials;
            this.publicCredentials = publicCredentials;
        }

        @Override
        void setMechanismInformation(MechanismInformation mechanismInformation) {
            InactiveState inactiveState = new InactiveState(this.capturedIdentity, this.mechanismConfigurationSelector, mechanismInformation, this.privateCredentials, this.publicCredentials);
            InitialState nextState = inactiveState.selectMechanismConfiguration();
            if (!ServerAuthenticationContext.this.stateRef.compareAndSet(this, nextState)) {
                ((State)ServerAuthenticationContext.this.stateRef.get()).setMechanismInformation(mechanismInformation);
            }
        }

        @Override
        SecurityDomain getSecurityDomain() {
            return this.capturedIdentity.getSecurityDomain();
        }

        @Override
        boolean authorize(Principal authorizationId, boolean authorizeRunAs) throws RealmUnavailableException {
            this.transition();
            return ((State)ServerAuthenticationContext.this.stateRef.get()).authorize(authorizationId, authorizeRunAs);
        }

        @Override
        void setMechanismRealmName(String name) {
            this.transition();
            ((State)ServerAuthenticationContext.this.stateRef.get()).setMechanismRealmName(name);
        }

        @Override
        MechanismRealmConfiguration getMechanismRealmConfiguration() {
            this.transition();
            return ((State)ServerAuthenticationContext.this.stateRef.get()).getMechanismRealmConfiguration();
        }

        @Override
        void fail(boolean requireInProgress) {
            this.transition();
            ((State)ServerAuthenticationContext.this.stateRef.get()).fail(requireInProgress);
        }

        @Override
        boolean authorizeAnonymous(boolean requireLoginPermission) {
            this.transition();
            return ((State)ServerAuthenticationContext.this.stateRef.get()).authorizeAnonymous(requireLoginPermission);
        }

        @Override
        boolean authorize(boolean requireLoginPermission) throws RealmUnavailableException {
            this.transition();
            return ((State)ServerAuthenticationContext.this.stateRef.get()).authorize(requireLoginPermission);
        }

        @Override
        boolean importIdentity(SecurityIdentity identity) throws RealmUnavailableException {
            this.transition();
            return ((State)ServerAuthenticationContext.this.stateRef.get()).importIdentity(identity);
        }

        @Override
        SupportLevel getEvidenceVerifySupport(Class<? extends Evidence> evidenceType, String algorithmName) throws RealmUnavailableException {
            return this.getSecurityDomain().getEvidenceVerifySupport(evidenceType, algorithmName);
        }

        @Override
        boolean verifyEvidence(Evidence evidence) throws RealmUnavailableException {
            this.transition();
            return ((State)ServerAuthenticationContext.this.stateRef.get()).verifyEvidence(evidence);
        }

        @Override
        void setPrincipal(Principal principal, boolean exclusive) throws RealmUnavailableException {
            this.transition();
            ((State)ServerAuthenticationContext.this.stateRef.get()).setPrincipal(principal, exclusive);
        }

        @Override
        MechanismConfiguration getMechanismConfiguration() {
            this.transition();
            return ((State)ServerAuthenticationContext.this.stateRef.get()).getMechanismConfiguration();
        }

        @Override
        void addPublicCredential(Credential credential) {
            InactiveState newState = new InactiveState(this.capturedIdentity, this.mechanismConfigurationSelector, this.mechanismInformation, this.privateCredentials, this.publicCredentials.withCredential(credential));
            if (!ServerAuthenticationContext.this.stateRef.compareAndSet(this, newState)) {
                ((State)ServerAuthenticationContext.this.stateRef.get()).addPublicCredential(credential);
            }
        }

        @Override
        void addPrivateCredential(Credential credential) {
            InactiveState newState = new InactiveState(this.capturedIdentity, this.mechanismConfigurationSelector, this.mechanismInformation, this.privateCredentials.withCredential(credential), this.publicCredentials);
            if (!ServerAuthenticationContext.this.stateRef.compareAndSet(this, newState)) {
                ((State)ServerAuthenticationContext.this.stateRef.get()).addPrivateCredential(credential);
            }
        }

        private void transition() {
            InitialState initialState = this.selectMechanismConfiguration();
            ServerAuthenticationContext.this.stateRef.compareAndSet(this, initialState);
        }

        private InitialState selectMechanismConfiguration() {
            MechanismConfiguration mechanismConfiguration = this.mechanismConfigurationSelector.selectConfiguration(this.mechanismInformation);
            if (mechanismConfiguration == null) {
                throw ElytronMessages.log.unableToSelectMechanismConfiguration(this.mechanismInformation.getMechanismType(), this.mechanismInformation.getMechanismName(), this.mechanismInformation.getHostName(), this.mechanismInformation.getProtocol());
            }
            return new InitialState(this.capturedIdentity, mechanismConfiguration, this.mechanismConfigurationSelector, this.privateCredentials, this.publicCredentials);
        }
    }

    static abstract class State {
        State() {
        }

        MechanismConfiguration getMechanismConfiguration() {
            throw ElytronMessages.log.noAuthenticationInProgress();
        }

        MechanismRealmConfiguration getMechanismRealmConfiguration() {
            throw ElytronMessages.log.noAuthenticationInProgress();
        }

        SecurityIdentity getAuthorizedIdentity() {
            throw ElytronMessages.log.noAuthenticationInProgress();
        }

        Principal getAuthenticationPrincipal() {
            throw ElytronMessages.log.noAuthenticationInProgress();
        }

        boolean isSamePrincipal(Principal principal) {
            return false;
        }

        SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec) throws RealmUnavailableException {
            throw ElytronMessages.log.noAuthenticationInProgress();
        }

        SupportLevel getEvidenceVerifySupport(Class<? extends Evidence> evidenceType, String algorithmName) throws RealmUnavailableException {
            throw ElytronMessages.log.noAuthenticationInProgress();
        }

        <C extends Credential> C getCredential(Class<C> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec) throws RealmUnavailableException {
            throw ElytronMessages.log.noAuthenticationInProgress();
        }

        boolean verifyEvidence(Evidence evidence) throws RealmUnavailableException {
            throw ElytronMessages.log.noAuthenticationInProgress();
        }

        boolean importIdentity(SecurityIdentity identity) throws RealmUnavailableException {
            throw ElytronMessages.log.noAuthenticationInProgress();
        }

        RealmIdentity getRealmIdentity() {
            throw ElytronMessages.log.noAuthenticationInProgress();
        }

        SecurityDomain getSecurityDomain() {
            throw ElytronMessages.log.noAuthenticationInProgress();
        }

        boolean authorizeAnonymous(boolean requireLoginPermission) {
            throw ElytronMessages.log.noAuthenticationInProgress();
        }

        void setMechanismInformation(MechanismInformation mechanismInformation) {
            throw ElytronMessages.log.noAuthenticationInProgress();
        }

        void setPrincipal(Principal principal, boolean exclusive) throws RealmUnavailableException {
            throw ElytronMessages.log.noAuthenticationInProgress();
        }

        boolean authorize(boolean requireLoginPermission) throws RealmUnavailableException {
            throw ElytronMessages.log.noAuthenticationInProgress();
        }

        boolean authorize(Principal authorizationId, boolean authorizeRunAs) throws RealmUnavailableException {
            throw ElytronMessages.log.noAuthenticationInProgress();
        }

        void setMechanismRealmName(String name) {
            throw ElytronMessages.log.noAuthenticationInProgress();
        }

        void updateCredential(Credential credential) throws RealmUnavailableException {
            throw ElytronMessages.log.noAuthenticationInProgress();
        }

        void succeed() {
            throw ElytronMessages.log.noAuthenticationInProgress();
        }

        void fail(boolean requireInProgress) {
            if (requireInProgress) {
                throw ElytronMessages.log.noAuthenticationInProgress();
            }
        }

        boolean isDone() {
            return false;
        }

        void addPublicCredential(Credential credential) {
            throw ElytronMessages.log.noAuthenticationInProgress();
        }

        void addPrivateCredential(Credential credential) {
            throw ElytronMessages.log.noAuthenticationInProgress();
        }
    }
}

