/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.realm;

import java.security.Principal;
import org.wildfly.common.Assert;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.auth.SupportLevel;
import org.wildfly.security.auth.realm.CacheableSecurityRealm;
import org.wildfly.security.auth.server.IdentityCredentials;
import org.wildfly.security.auth.server.RealmIdentity;
import org.wildfly.security.auth.server.RealmUnavailableException;
import org.wildfly.security.auth.server.SecurityRealm;
import org.wildfly.security.auth.server.event.RealmEvent;
import org.wildfly.security.authz.Attributes;
import org.wildfly.security.authz.AuthorizationIdentity;
import org.wildfly.security.cache.RealmIdentityCache;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.credential.PasswordCredential;
import org.wildfly.security.evidence.Evidence;
import org.wildfly.security.evidence.PasswordGuessEvidence;
import org.wildfly.security.password.interfaces.ClearPassword;

public class CachingSecurityRealm
implements SecurityRealm {
    private final CacheableSecurityRealm realm;
    private final RealmIdentityCache cache;

    public CachingSecurityRealm(CacheableSecurityRealm realm, RealmIdentityCache cache) {
        this.realm = Assert.checkNotNullParam("realm", realm);
        this.cache = Assert.checkNotNullParam("cache", cache);
        if (!(realm instanceof CacheableSecurityRealm)) {
            throw ElytronMessages.log.realmCacheUnexpectedType(realm, CacheableSecurityRealm.class);
        }
        CacheableSecurityRealm cacheable = (CacheableSecurityRealm)CacheableSecurityRealm.class.cast(realm);
        cacheable.registerIdentityChangeListener(this::removeFromCache);
    }

    @Override
    public RealmIdentity getRealmIdentity(Principal principal) throws RealmUnavailableException {
        RealmIdentity cached = this.cache.get(principal);
        if (cached != null) {
            return cached;
        }
        final RealmIdentity realmIdentity = this.getCacheableRealm().getRealmIdentity(principal);
        if (!realmIdentity.exists()) {
            return realmIdentity;
        }
        RealmIdentity cachedIdentity = new RealmIdentity(){
            final RealmIdentity identity;
            AuthorizationIdentity authorizationIdentity;
            Attributes attributes;
            IdentityCredentials credentials;
            {
                this.identity = realmIdentity;
                this.authorizationIdentity = null;
                this.attributes = null;
                this.credentials = IdentityCredentials.NONE;
            }

            @Override
            public Principal getRealmIdentityPrincipal() {
                return this.identity.getRealmIdentityPrincipal();
            }

            @Override
            public SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String algorithmName) throws RealmUnavailableException {
                if (this.credentials.contains(credentialType, algorithmName)) {
                    return this.credentials.getCredentialAcquireSupport(credentialType, algorithmName);
                }
                Credential credential = this.identity.getCredential(credentialType, algorithmName);
                if (credential != null) {
                    this.credentials = this.credentials.withCredential(credential);
                }
                return this.credentials.getCredentialAcquireSupport(credentialType, algorithmName);
            }

            @Override
            public <C extends Credential> C getCredential(Class<C> credentialType) throws RealmUnavailableException {
                if (this.credentials.contains(credentialType)) {
                    return this.credentials.getCredential(credentialType);
                }
                C credential = this.identity.getCredential(credentialType);
                if (credential != null) {
                    this.credentials = this.credentials.withCredential((Credential)credential);
                }
                return this.credentials.getCredential(credentialType);
            }

            @Override
            public <C extends Credential> C getCredential(Class<C> credentialType, String algorithmName) throws RealmUnavailableException {
                if (this.credentials.contains(credentialType, algorithmName)) {
                    return this.credentials.getCredential(credentialType, algorithmName);
                }
                C credential = this.identity.getCredential(credentialType, algorithmName);
                if (credential != null) {
                    this.credentials = this.credentials.withCredential((Credential)credential);
                }
                return this.credentials.getCredential(credentialType, algorithmName);
            }

            @Override
            public void updateCredential(Credential credential) throws RealmUnavailableException {
                try {
                    this.identity.updateCredential(credential);
                }
                finally {
                    CachingSecurityRealm.this.removeFromCache(this.identity.getRealmIdentityPrincipal());
                }
            }

            @Override
            public SupportLevel getEvidenceVerifySupport(Class<? extends Evidence> evidenceType, String algorithmName) throws RealmUnavailableException {
                if (PasswordGuessEvidence.class.isAssignableFrom(evidenceType)) {
                    if (this.credentials.canVerify(evidenceType, algorithmName)) {
                        return SupportLevel.SUPPORTED;
                    }
                    PasswordCredential credential = this.identity.getCredential(PasswordCredential.class);
                    if (credential != null) {
                        this.credentials = this.credentials.withCredential(credential);
                        if (credential.canVerify(evidenceType, algorithmName)) {
                            return SupportLevel.SUPPORTED;
                        }
                    }
                }
                return this.identity.getEvidenceVerifySupport(evidenceType, algorithmName);
            }

            @Override
            public boolean verifyEvidence(Evidence evidence) throws RealmUnavailableException {
                if (evidence instanceof PasswordGuessEvidence) {
                    if (this.credentials.canVerify(evidence)) {
                        return this.credentials.verify(evidence);
                    }
                    PasswordCredential credential = this.identity.getCredential(PasswordCredential.class);
                    if (credential != null) {
                        this.credentials = this.credentials.withCredential(credential);
                        if (credential.canVerify(evidence)) {
                            return credential.verify(evidence);
                        }
                    }
                    char[] guess = ((PasswordGuessEvidence)evidence).getGuess();
                    ClearPassword password = ClearPassword.createRaw("clear", guess);
                    if (this.identity.verifyEvidence(evidence)) {
                        this.credentials = this.credentials.withCredential(new PasswordCredential(password));
                        return true;
                    }
                    return false;
                }
                return this.identity.verifyEvidence(evidence);
            }

            @Override
            public boolean exists() throws RealmUnavailableException {
                return true;
            }

            @Override
            public AuthorizationIdentity getAuthorizationIdentity() throws RealmUnavailableException {
                if (this.authorizationIdentity == null) {
                    this.authorizationIdentity = this.identity.getAuthorizationIdentity();
                }
                return this.authorizationIdentity;
            }

            @Override
            public Attributes getAttributes() throws RealmUnavailableException {
                if (this.attributes == null) {
                    this.attributes = this.identity.getAttributes();
                }
                return this.attributes;
            }

            @Override
            public void dispose() {
                this.identity.dispose();
            }
        };
        this.cache.put(principal, cachedIdentity);
        return cachedIdentity;
    }

    @Override
    public SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String algorithmName) throws RealmUnavailableException {
        return this.getCacheableRealm().getCredentialAcquireSupport(credentialType, algorithmName);
    }

    @Override
    public SupportLevel getEvidenceVerifySupport(Class<? extends Evidence> evidenceType, String algorithmName) throws RealmUnavailableException {
        return this.getCacheableRealm().getEvidenceVerifySupport(evidenceType, algorithmName);
    }

    @Override
    public void handleRealmEvent(RealmEvent event) {
        this.getCacheableRealm().handleRealmEvent(event);
    }

    public void removeFromCache(Principal principal) {
        this.cache.remove(principal);
    }

    public void removeAllFromCache() {
        this.cache.clear();
    }

    protected CacheableSecurityRealm getCacheableRealm() {
        return this.realm;
    }
}

