/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.sasl.oauth2;

import java.util.Map;
import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslClientFactory;
import javax.security.sasl.SaslException;
import org.wildfly.security.mechanism.oauth2.OAuth2Client;
import org.wildfly.security.sasl.oauth2.OAuth2SaslClient;

public final class OAuth2SaslClientFactory
implements SaslClientFactory {
    @Override
    public SaslClient createSaslClient(String[] mechanisms, String authorizationId, String protocol, String serverName, Map<String, ?> props, CallbackHandler cbh) throws SaslException {
        for (String mechanism : mechanisms) {
            if (!"OAUTHBEARER".equals(mechanism)) continue;
            return new OAuth2SaslClient(mechanism, protocol, serverName, cbh, authorizationId, new OAuth2Client(mechanism, authorizationId, cbh));
        }
        return null;
    }

    @Override
    public String[] getMechanismNames(Map<String, ?> props) {
        if (props == null) {
            return new String[]{"OAUTHBEARER"};
        }
        if ("true".equals(props.get("wildfly.sasl.mechanism-query-all"))) {
            return new String[]{"OAUTHBEARER"};
        }
        if ("true".equals(props.get("javax.security.sasl.policy.noplaintext")) || "true".equals(props.get("javax.security.sasl.policy.noactive")) || "true".equals(props.get("javax.security.sasl.policy.nodictionary"))) {
            return new String[0];
        }
        return new String[]{"OAUTHBEARER"};
    }
}

