/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.client;

import org.wildfly.common.math.HashMath;
import org.wildfly.security.auth.client.AuthenticationConfiguration;

class SetPortAuthenticationConfiguration
extends AuthenticationConfiguration {
    private final int port;

    SetPortAuthenticationConfiguration(AuthenticationConfiguration parent, int port) {
        super(parent);
        this.port = port;
    }

    @Override
    AuthenticationConfiguration reparent(AuthenticationConfiguration newParent) {
        return new SetPortAuthenticationConfiguration(newParent, this.port);
    }

    @Override
    int getPort() {
        return this.port;
    }

    @Override
    boolean halfEqual(AuthenticationConfiguration other) {
        return this.port == other.getPort() && this.parentHalfEqual(other);
    }

    @Override
    int calcHashCode() {
        return HashMath.multiHashUnordered(this.parentHashCode(), 13597, this.port);
    }

    @Override
    StringBuilder asString(StringBuilder sb) {
        return this.parentAsString(sb).append("port=").append(this.port).append(',');
    }
}

