/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.client;

import java.util.function.Function;
import org.wildfly.common.math.HashMath;
import org.wildfly.security.auth.client.AuthenticationConfiguration;

class RewriteNameAuthenticationConfiguration
extends AuthenticationConfiguration {
    private final Function<String, String> rewriter;

    RewriteNameAuthenticationConfiguration(AuthenticationConfiguration parent, Function<String, String> rewriter) {
        super(parent);
        this.rewriter = rewriter;
    }

    @Override
    String doRewriteUser(String original) {
        return this.rewriter.apply(super.doRewriteUser(original));
    }

    @Override
    AuthenticationConfiguration reparent(AuthenticationConfiguration newParent) {
        return new RewriteNameAuthenticationConfiguration(newParent, this.rewriter);
    }

    @Override
    StringBuilder asString(StringBuilder sb) {
        return this.parentAsString(sb).append("RewriteName,");
    }

    @Override
    boolean halfEqual(AuthenticationConfiguration other) {
        return this.rewriter.equals(other.getNameRewriter()) && this.parentHalfEqual(other);
    }

    @Override
    int calcHashCode() {
        return HashMath.multiHashUnordered(this.parentHashCode(), 47287, this.rewriter.hashCode());
    }

    @Override
    Function<String, String> getNameRewriter() {
        return this.rewriter;
    }
}

