/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.audit;

import java.security.Permission;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.function.Supplier;
import javax.json.Json;
import javax.json.JsonObjectBuilder;
import org.wildfly.common.Assert;
import org.wildfly.security.auth.server.SecurityIdentity;
import org.wildfly.security.auth.server.event.SecurityDefiniteOutcomeEvent;
import org.wildfly.security.auth.server.event.SecurityEvent;
import org.wildfly.security.auth.server.event.SecurityEventVisitor;
import org.wildfly.security.auth.server.event.SecurityPermissionCheckEvent;

public class JsonSecurityEventFormatter
extends SecurityEventVisitor<Void, String> {
    private final Supplier<DateFormat> dateFormatSupplier;

    JsonSecurityEventFormatter(Builder builder) {
        this.dateFormatSupplier = builder.dateFormatSupplier;
    }

    @Override
    public String handleUnknownEvent(SecurityEvent event, Void param) {
        Assert.checkNotNullParam("event", event);
        JsonObjectBuilder objectBuilder = Json.createObjectBuilder();
        this.handleUnknownEvent(event, objectBuilder);
        return objectBuilder.build().toString();
    }

    @Override
    private void handleUnknownEvent(SecurityEvent event, JsonObjectBuilder objectBuilder) {
        DateFormat dateFormat = this.dateFormatSupplier.get();
        objectBuilder.add("event", event.getClass().getSimpleName());
        objectBuilder.add("event-time", dateFormat.format(Date.from(event.getInstant())));
        JsonObjectBuilder securityIdentityBuilder = Json.createObjectBuilder();
        SecurityIdentity securityIdentity = event.getSecurityIdentity();
        securityIdentityBuilder.add("name", securityIdentity.getPrincipal().getName());
        securityIdentityBuilder.add("creation-time", dateFormat.format(Date.from(securityIdentity.getCreationTime())));
        objectBuilder.add("security-identity", securityIdentityBuilder);
    }

    @Override
    public String handleDefiniteOutcomeEvent(SecurityDefiniteOutcomeEvent event, Void param) {
        Assert.checkNotNullParam("event", event);
        JsonObjectBuilder objectBuilder = Json.createObjectBuilder();
        this.handleDefiniteOutcomeEvent(event, objectBuilder);
        return objectBuilder.build().toString();
    }

    @Override
    private void handleDefiniteOutcomeEvent(SecurityDefiniteOutcomeEvent event, JsonObjectBuilder objectBuilder) {
        this.handleUnknownEvent((SecurityEvent)event, objectBuilder);
        objectBuilder.add("success", event.isSuccessful());
    }

    @Override
    public String handlePermissionCheckEvent(SecurityPermissionCheckEvent event, Void param) {
        Assert.checkNotNullParam("event", event);
        JsonObjectBuilder objectBuilder = Json.createObjectBuilder();
        this.handlePermissionCheckEvent(event, objectBuilder);
        return objectBuilder.build().toString();
    }

    @Override
    private void handlePermissionCheckEvent(SecurityPermissionCheckEvent event, JsonObjectBuilder objectBuilder) {
        this.handleDefiniteOutcomeEvent((SecurityDefiniteOutcomeEvent)event, objectBuilder);
        Permission permission = event.getPermission();
        JsonObjectBuilder permissionBuilder = Json.createObjectBuilder();
        permissionBuilder.add("type", permission.getClass().getName());
        permissionBuilder.add("actions", permission.getActions());
        permissionBuilder.add("name", permission.getName());
        objectBuilder.add("permission", permissionBuilder);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Supplier<DateFormat> dateFormatSupplier = SimpleDateFormat::new;

        Builder() {
        }

        public Builder setDateFormatSupplier(Supplier<DateFormat> dateFormatSupplier) {
            this.dateFormatSupplier = Assert.checkNotNullParam("dateFormatSupplier", dateFormatSupplier);
            return this;
        }

        public SecurityEventVisitor<?, String> build() {
            return new JsonSecurityEventFormatter(this);
        }
    }
}

